/*
 * $RCSfile: Model.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region;

import org.resmedicinae.resmedlib.*;

/**
 * This class represents a model.
 *
 * It is the super class of the model level classes in the framework's ontology:<br>
 *  <ul>
 *      <li>Network</li>
 *      <li>Family</li>
 *      <li>System</li>
 *      <li>Block</li>
 *      <li>Region (History/Record)</li>
 *      <li>Component (Unit)</li>
 *      <li>Part (Heading)</li>
 *      <li>Chain (Combination/Description)</li>
 *      <li>Term (Principle)</li>
 *      <li>Sign</li>
 *      <li>Number</li>
 *      <li>Digit</li>
 *  </ul>
 *
 * @version $Revision: 1.6 $ $Date: 2002/12/03 13:23:44 $ $Author: zone3 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Model extends Region {

    /** ?? */    
    public static final String MODEL_KEY = "MODEL_KEY";
}

