/*
 * $RCSfile: Fraction.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.number;

import org.resmedicinae.resmedlib.*;

/**
 * This class represents a fraction.
 *
 * A fraction is also known as float or double. It has a part
 * "before and after a point", namely a numerator and a denominator.
 *
 * @version $Revision: 1.8 $ $Date: 2002/12/10 17:27:44 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Fraction extends org.resmedicinae.resmedlib.Number {

    //
    // Static values.
    //

    /** The minimum value. */
    public static final double MINIMUM = java.lang.Double.MIN_VALUE;

    /** The maximum value. */
    public static final double MAXIMUM = java.lang.Double.MAX_VALUE;

    /** The default value. */
    public static final double DEFAULT = 0.0;

    //
    // Constructable.
    //
    
    /**
     * Constructs this double.
     */
    public Fraction() {

        super();
    }

    /**
     * Constructs this double.<br><br>
     *
     * Normally, constructors are NOT used in the ResMedLib framework,
     * because no counterparts (destructors) exist in the java language.
     * The aim of this prohibition is to ensure a proper startup and shutdown
     * (lifecycle) of every item in the system.<br><br>
     *
     * However, when it comes to lower abstraction (language) levels of our
     * ontology, we need to make some exceptions:<br>
     * Whenever an integer like "0", "1", "2" is given,
     * the java language constructs a new integer object anyway.
     * So, it doesn't matter if also we are creating integers which do not
     * get properly destroyed by the lifecycle, just by the garbage collector
     * after an indefinable time.
     * Most often, such integers are needed/created as static variables to define
     * constants, e.g. attribute ids. That's why we need this integer constructor.
     *
     * @param d the primitive double value
     */
    public Fraction(double d) {

        super();
        setJavaObject(new java.lang.Double(d));
    }
    
    //
    // Encapsulated java double.
    //
    
    /**
     * Creates an encapsulated java double.
     *
     * @return the encapsulated java double
     */
    public java.lang.Object createJavaObject() {

        return new java.lang.Double(createJavaPrimitive());
    }

    //
    // Java primitive.
    //
    
    /**
     * Creates the java primitive.
     *
     * @return the java primitive
     */
    public double createJavaPrimitive() {

        return Fraction.DEFAULT;
    }

    /**
     * Destroys the java primitive.
     *
     * @param p the java primitive
     */
    public void destroyJavaPrimitive(double p) {
    }

    /**
     * Sets the java primitive.
     *
     * @param p the java primitive
     * @exception NullPointerException if the java object is null
     */
    public void setJavaPrimitive(double p) throws NullPointerException {
    }

    /**
     * Returns the java primitive.
     *
     * @return the java primitive
     * @exception NullPointerException if the java object is null
     */
    public double getJavaPrimitive() throws NullPointerException {

        double p = Fraction.DEFAULT;
        java.lang.Double j = (java.lang.Double) getJavaObject();
        
        if (j != null) {

            p = j.doubleValue();

        } else {
        
            throw new NullPointerException("Could not get java primitive. The java object is null.");
        }            

        return p;
    }
}

