/*
 * $RCSfile: Portal.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.family;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.block.*;
import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.block.view.graphical.*;
import org.resmedicinae.resmedlib.chain.*;
import org.resmedicinae.resmedlib.region.view.graphical.*;

/**
 * This class represents a portal.<br><br>
 *
 * A portal system is capable of hosting multiple child systems which can be
 * internal, i.e. inherited from the ResMedLib framework or external processes.<br><br>
 *
 * The portal basically contains a tree with a hierarchy of all available
 * systems (modules). This tree can be displayed by the corresponding view
 * as menu or tree view. On clicking a system, it gets started. Systems can
 * be run standalone or from within this portal system. It is easily possible
 * to write additional modules and integrate them into this portal system.<br><br>
 *
 * Child systems can be integrated into the portal system's Frame as Frame,
 * InternalFrame or TabPage.
 *
 * @version $Revision: 1.12 $ $Date: 2002/12/15 23:50:52 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 * @see <a href="http://resmedicinae.sf.net/model/implementation/index.html">Creating a Res Medicinae Module</a>
 */
public class Portal extends Family {

    //
    // Name.
    //

    /**
     * Creates a name.
     *
     * @return the name
     * @exception NullPointerException if the name is null
     */
    public org.resmedicinae.resmedlib.term.String createName() throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.term.String n = new org.resmedicinae.resmedlib.term.String();

        if (n != null) {

            n.initialize();
            n.setJavaObject("Res Medicinae Portal");

        } else {

            throw new NullPointerException("Could not create name. The name is null.");
        }

        return n;
    }

    //
    // Version.
    //

    /**
     * Creates a version.
     *
     * @return the version
     * @exception NullPointerException if the version is null
     */
    public org.resmedicinae.resmedlib.term.String createVersion() throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.term.String v = new org.resmedicinae.resmedlib.term.String();

        if (v != null) {

            v.initialize();
            v.setJavaObject("0.0.4.0");

        } else {

            throw new NullPointerException("Could not create version. The version is null.");
        }

        return v;
    }

    //
    // Date.
    //

    /**
     * Creates a date.
     *
     * @return the date
     * @exception NullPointerException if the date is null
     */
    public org.resmedicinae.resmedlib.term.String createDate() throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.term.String d = new org.resmedicinae.resmedlib.term.String();

        if (d != null) {

            d.initialize();
            d.setJavaObject("30.09.2002");

        } else {

            throw new NullPointerException("Could not create date. The date is null.");
        }

        return d;
    }

    //
    // Authors.
    //

    /**
     * Creates the authors.
     *
     * @return the authors
     * @exception NullPointerException if the authors is null
     */
    public org.resmedicinae.resmedlib.term.String createAuthors() throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.term.String a = new org.resmedicinae.resmedlib.term.String();

        if (a != null) {

            a.initialize();
            a.setJavaObject("Christian Heller\n<christian.heller@tuxtax.de>\n- initiated project\n- maintains ResMedLib framework\n- created Portal module\n");

        } else {

            throw new NullPointerException("Could not create authors. The authors is null.");
        }

        return a;
    }

    //
    // Helpers.
    //

    /**
     * Creates a helpers.
     *
     * @return the helpers
     * @exception NullPointerException if the helpers is null
     */
    public org.resmedicinae.resmedlib.term.String createHelpers() throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.term.String h = new org.resmedicinae.resmedlib.term.String();

        if (h != null) {

            h.initialize();
            h.setJavaObject("Karsten Hilbert\n<karsten.hilbert@gmx.net>\n- maintains the Analysis Document\n- helps out in many things\n\n"
                + "Michael Simon\n<michael.simon@gmx.net>\n- created ANT build.xml files\n- created .bat build/start files\n- prepared IzPack installer\n\n"
                + "Henrik Brandes\n<henrik-b@gmx.de>\n- created ANT build.xml files\n- created .bat build/start files\n- prepared IzPack installer\n\n"
                + "Chris Fraser\n<pangaea@comcen.com.au>\n- provided the 'Littlefish' project resources\n\n"
                + "Andrew Arch\n<archa@anz.com>\n- provided the 'Littlefish' project resources\n\n"
                + "Sebastian Hilbert\n<sebastian.hilbert@gmx.net>\n- designed the Res Medicinae logo\n\n"
                + "Johannes Vieweg\n<jvg@gmx.net>\n- provided a PDF version of the Design Document\n\n");

        } else {

            throw new NullPointerException("Could not create helpers. The helpers is null.");
        }

        return h;
    }

    //
    // Inspirations.
    //

    /**
     * Creates the inspirations.
     *
     * @return the inspirations
     * @exception NullPointerException if the inspirations is null
     */
    public org.resmedicinae.resmedlib.term.String createInspirations() throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.term.String i = new org.resmedicinae.resmedlib.term.String();
        
        if (i != null) {

            i.initialize();
            i.setJavaObject("Scope\nhttp://www.sourceforge.net/projects/scope\n- Hierarchical Model View Controller (HMVC) Design Pattern\n\n"
                + "Apache-Jakarta-Framework\nhttp://jakarta.apache.org\nComponent Lifecycle\n\n"
                + "Linux Kontor\nhttp://www.sourceforge.net/projects/kontor\nEnterprise Resource Planning System\n\n");

        } else {

            throw new NullPointerException("Could not create inspirations. The inspirations is null.");
        }

        return i;
    }

    //
    // Configuration.
    //

    /*
     * Creates the configuration.
     *
     * @return the configuration
     * @exception NullPointerException if the portal configuration is null
     */
    public Configuration createConfiguration() throws Exception, NullPointerException {

        Configuration c = new Configuration();

        if (c != null) {

            c.initialize();
            c.setJavaObject(java.util.prefs.Preferences.systemNodeForPackage(getClass().getPackage().getClass()));

        } else {

            throw new NullPointerException("Could not create portal configuration. The portal configuration is null.");
        }

        return c;
    }

    //
    // Graphical view.
    //

    /**
     * Creates a graphical view.
     *
     * @return the graphical view
     * @exception NullPointerException if the graphical view mode is null
     * @exception Exception if the graphical view mode is not known
     */
    public GraphicalView createGraphicalView() throws Exception, NullPointerException {

        PortalView v = new PortalView();

        if (v != null) {

            v.globalize((Item) get(org.resmedicinae.resmedlib.System.GLOBALS));
            v.initialize();
            v.link();

        } else {

            throw new NullPointerException("Could not create portal graphical view. The portal graphical view is null.");
        }

        return v;
    }

    //
    // Loadable.
    //

    /**
     * Loads this component.
     *
     * @param m the model
     */
    public void load(Object m) throws Exception {

/*??
        super.load(m);

        //?? Temporary, until ResMedLib offers tree.
        TreeModel model = new DefaultTreeModel(((MainApplicationModel) getModel()).getAvailableApplications());
        ((PortalView) getView()).getSystemTreeView().setModel(model);
        ((PortalView) getView()).getMenuBar().getSystemMenu().setModel(model);
*/
    }

    //
    // Application tree configuration dialog.
    //

    /**
     * Configures application tree in a dialog.
     *
     * @exception NullPointerException if the application tree configuration dialog is null
     */
    private void configureApplicationTree() throws NullPointerException {

/*??
        log(Level.CONFIG, "Create configuration dialog.");
        ApplicationTreeConfigurationDialog d = new ApplicationTreeConfigurationDialog(GuiController.getGuiController().getActiveFrame(), "Configure Settings", true, (ApplicationTreeNode) this.mainApplication.getAvailableApplications().getRoot());

        if (d != null) {

            d.setSize(new Dimension(700, 600));

            Dimension dialogSize = d.getPreferredSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

            if (dialogSize.height > screenSize.height) {

                dialogSize.height = screenSize.height;
            }

            if (dialogSize.width > screenSize.width) {

                dialogSize.width = screenSize.width;
            }

            d.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
            d.setVisible(true);

        } else {

            throw new NullPointerException("Could not create about dialog. About dialog is null.");
        }
*/
    }

    //
    // ResMedicinae configuration dialog.
    //

    /**
     * Configures Res Medicinae in a dialog.
     *
     * @exception NullPointerException if the configure Res Medicinae dialog is null
     */
    private void configureResMedicinae() throws NullPointerException {

/*??
        ResMedicinaeConfigurationDialog d = new ResMedicinaeConfigurationDialog(GuiController.getGuiController().getActiveFrame(), "Configure Settings", true, this.mainApplication);

        if (d != null) {

            d.setSize(new Dimension(700, 600));

            Dimension dialogSize = d.getPreferredSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

            if (dialogSize.height > screenSize.height) {

                dialogSize.height = screenSize.height;
            }

            if (dialogSize.width > screenSize.width) {

                dialogSize.width = screenSize.width;
            }

            d.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
            d.setVisible(true);

        } else {

            throw new NullPointerException("Could not create about dialog. About dialog is null.");
        }
*/
    }

    //
    // Change display mode.
    //

    /**
     * Changes the display mode.
     *
     * If the display mode is changed, the following will happen:
     * - the views of all child controllers of this controller are destroyed
     * - the view of this controller is destroyed
     * - the actual display mode value is set
     * - a new view for this controller is created
     * - new views for all child controllers of this controller are created
     *
     * @param mode the display mode
     * @exception NullPointerException if the view is null
     * @exception Exception if the given display mode does not exist
     */
    public void changeDisplayMode(org.resmedicinae.resmedlib.number.Integer mode) throws Exception, NullPointerException {

/*??
        SwingView v = (SwingView) getView();

        if (v != null) {

            if ((mode == DisplayFactory.FRAME_DISPLAY)
                || (mode == DisplayFactory.INTERNAL_FRAME_DISPLAY)
                || (mode == DisplayFactory.TAB_PAGE_DISPLAY)) {

                if (mode != v.getDisplayMode()) {

                    // Hide view displays of all child controllers of this controller.
                    hideViews();

                    // Set display mode.
                    v.setDisplayMode(mode);
                    v.setChildApplicationComponent(null);

                    // Show view displays for all child controllers of this controller.
                    showViews();
                }

            } else {

                throw new Exception("Could not change display mode. The given display mode does not exist.");
            }

        } else {

            throw new NullPointerException("Could not change display mode. The view is null.");
        }
*/
    }

    /**
     * Show view displays for all application views.
     *
     * @exception NullPointerException if the child controller container is null
     */
    protected void showViews() throws Exception, NullPointerException {

/*??
        // Determine child controllers.
        List l = getChildren();

        if (l != null) {

            Object o = null;

            for (org.resmedicinae.resmedlib.number.Integer i = 0; i < l.size(); i++) {

                // Determine child controller.
                o = l.get(i);

                if (o instanceof org.resmedicinae.resmedlib.System) {

//??                    ((org.resmedicinae.resmedlib.System) o).show((View) ((org.resmedicinae.resmedlib.System) o).getView());
                }
            }

        } else {

            throw new NullPointerException("Could not show view. The child controller container is null.");
        }
*/
    }

    /**
     * Hide view displays of all application views.
     *
     * @exception NullPointerException if the child controller container is null
     */
    protected void hideViews() throws Exception, NullPointerException {

/*??
        // Determine child controllers.
        List l = getChildren();

        if (l != null) {

            Object o = null;

            for (org.resmedicinae.resmedlib.number.Integer i = 0; i < l.size(); i++) {

                // Determine child controller.
                o = l.get(i);

                if (o instanceof org.resmedicinae.resmedlib.System) {

//??                    ((org.resmedicinae.resmedlib.System) o).hide((View) ((org.resmedicinae.resmedlib.System) o).getView());
                }
            }

        } else {

            throw new NullPointerException("Could not hide view. The child controller container is null.");
        }
*/
    }

    //
    // Linkable.
    //

    /**
     * Links the children of this portal.
     *
     * @exception NullPointerException if the portal view is null
     * @exception NullPointerException if the portal contents panel is null
     * @exception NullPointerException if the portal split pane is null
     * @exception NullPointerException if the tree is null
     */
    public void link() throws Exception, NullPointerException {

        super.link();

        PortalView v = (PortalView) get(Portal.GRAPHICAL_VIEW);
        
        if (v != null) {

            PortalContentsPanel cp = (PortalContentsPanel) v.get(PortalView.CONTENTS_PANEL);
            
            if (cp != null) {
                
                PortalSplitPane sp = (PortalSplitPane) cp.get(PortalContentsPanel.PORTAL_SPLIT_PANE);
                
                if (sp != null) {
                    
                    Tree t = (Tree) sp.get(PortalSplitPane.LEFT_COMPONENT);

                    if (t != null) {

                        t.set(Tree.MODEL, get(Portal.AVAILABLE_SYSTEMS));

                        //?? t.addTreeSelectionListener(this);

                    } else {

                        throw new NullPointerException("Could not link portal. The tree is null.");
                    }
            
                } else {
        
                    throw new NullPointerException("Could not link portal. The portal split pane is null.");
                }
        
            } else {
    
                throw new NullPointerException("Could not link portal. The portal contents panel is null.");
            }
    
        } else {

            throw new NullPointerException("Could not link portal. The portal view is null.");
        }
    }

    /**
     * Unlinks the children of this portal.
     */
    public void unlink() throws Exception {
        
        try {
            
        } finally {
            
            super.unlink();
        }
    }
}

