/*
 * $RCSfile: Launcher.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.family;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.block.view.*;

/**
 * This class represents a launcher.<br><br>
 *
 * Its only task is to startup and shutdown a system.
 * It uses the normal <code>createSystem</code> method of the parent class.
 * The <code>destroySystem</code> method, however, is overloaded to exit
 * the whole java system when this system gets destroyed.
 *
 * @version $Revision: 1.4 $ $Date: 2002/12/16 14:12:04 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Launcher extends Family {

    //
    // Graphical view.
    //

    /**
     * Creates a graphical view.
     *
     * @return the graphical view
     */
    public GraphicalView createGraphicalView() throws Exception, NullPointerException {

        return null;
    }

    //
    // System.
    //

    /**
     * Runs the system.
     *
     * This method was introduced additionally to createSystem and destroySystem
     * to provide a convenient way for automatic startup and shutdown of a system.
     *
     * @param loc the system location
     * @param args the system arguments
     * @param wp the system workpath
     * @exception NullPointerException if the system is null
     * @exception NullPointerException if the shutdown flag is null
     */
    public void run(org.resmedicinae.resmedlib.term.String loc, org.resmedicinae.resmedlib.term.String args, org.resmedicinae.resmedlib.term.String wp) throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.System s = createSystem(loc, args, wp);

        if (s != null) {
            
            org.resmedicinae.resmedlib.digit.Boolean b = null; 

            while (true) {

                b = (org.resmedicinae.resmedlib.digit.Boolean) s.get(org.resmedicinae.resmedlib.System.SHUTDOWN_FLAG); 

                if (b != null) {
    
                    if (b.isUnequalTo(org.resmedicinae.resmedlib.digit.Boolean.FALSE)) {

                        destroySystem(s);

                        //
                        // Runtime.getRuntime().exit(0);
                        // and
                        // System.exit(0);
                        // do the same thing.
                        // The program exits normally, when the last non-daemon thread exits.
                        //
                        log(Launcher.INFO_LOG_LEVEL, "Exit system.");
                        java.lang.Runtime.getRuntime().exit(0);
                    }

                } else {
        
                    throw new NullPointerException("Could not run system. The shutdown flag is null.");
                }
            }

        } else {

            throw new NullPointerException("Could not run system. The system is null.");
        }
    }

    //
    // Splash window.
    //

    /**
     * Shows the component splash window.
     *
     * @param c the component splash window
     * @exception NullPointerException if the component is null
     */
/*??
    private void showComponentSplashWindow(BasicApplication c) throws Exception, NullPointerException {

        if (c != null) {

//??            if (c instanceof Splashable) {

            log(Level.INFO, "Show the component splash window.");
//??            c.setSplashWindowController(c.getDefaultSplashWindowController());
//??            c.showSplashWindowController(c.getSplashWindowController());
//??            }

        } else {

            throw new NullPointerException("Could not show component splash window. The component is null.");
        }
    }

    /**
     * Disposes the component splash window.
     *
     * @param c the component splash window
     * @exception NullPointerException if the component is null
     */
/*??
    private void hideComponentSplashWindow(BasicApplication c) throws Exception, NullPointerException {

        if (c != null) {

//??            if (c instanceof Splashable) {

            log(Level.INFO, "Hide the component splash window.");
//??            c.hideSplashWindowController(c.getSplashWindowController());
//??            c.destroySplashWindowController(c.getSplashWindowController());
//??            c.setSplashWindowController(null);
//??            }

        } else {

            throw new NullPointerException("Could not hide component splash window. The component is null.");
        }
    }
*/
}

