/*
 * $RCSfile: Mapper.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.domain.dataaccess;

import java.lang.*;
import java.sql.*;
import java.util.*;
import org.resmedicinae.resmedlib.component.logger.*;
import org.resmedicinae.resmedlib.domain.*;

/**
 * This class represents a mapper.
 *
 * It pulls data out of a row set to create an object.
 *
 * @version $Revision: 1.2 $ $Date: 2002/06/12 18:49:41 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Mapper extends Object {

    /** The logger. */
    private Logger logger;

    /**
     * Returns the logger.
     *
     * @return the logger
     */
    public Logger getLogger() {

        return this.logger;
    }

    /**
     * Sets the logger.
     *
     * @param logger the logger
     */
    public void setLogger(Logger logger) {

        this.logger = logger;
    }

    /**
     * Loads data from the result set into the domain object.
     *
     * @param o the domain object
     * @param rs the result set
     * @exception NullPointerException if the domain object is null
     * @exception NullPointerException if the result set is null
     */
    public void load(DomainObject o, ResultSet rs) throws NullPointerException, SQLException {

        if (o != null) {

            if (rs != null) {

                o.setId(new Long(rs.getLong("id")));

            } else {

                throw new NullPointerException("Could not load domain object. The result set is null.");
            }

        } else {

            throw new NullPointerException("Could not load domain object. The domain object is null.");
        }
    }

    /**
     * Updates the database with the given domain object data.
     *
     * @param o the domain object
     * @param s the update statement
     * @exception NullPointerException if the update statement is null
     * @exception NullPointerException if the domain object is null
     */
    public void update(DomainObject o, PreparedStatement s) throws NullPointerException, SQLException {

        if (s != null) {

            if (o != null) {

                s.setInt(4, o.getId().intValue());

            } else {

                throw new NullPointerException("Could not update database. The domain object is null.");
            }

        } else {

            throw new NullPointerException("Could not update database. The update statement is null.");
        }
    }

    /**
     * Inserts the domain object into the database.
     *
     * @param o the domain object
     * @param s the update statement
     * @exception NullPointerException if the insert statement is null
     * @exception NullPointerException if the domain object is null
     */
    public void insert(DomainObject o, PreparedStatement s) throws NullPointerException, SQLException {

        if (s != null) {

            if (o != null) {

                s.setInt(4, o.getId().intValue());

            } else {

                throw new NullPointerException("Could not update database. The domain object is null.");
            }

        } else {

            throw new NullPointerException("Could not update database. The insert statement is null.");
        }
    }
}

