/*
 * $RCSfile: DomainObject.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.domain;

import java.lang.*;
import org.resmedicinae.resmedlib.component.logger.*;

/**
 * This class represents a domain object.
 *
 * @version $Revision: 1.5 $ $Date: 2002/06/12 18:49:40 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class DomainObject extends Object {

    /** The logger. */
    private Logger logger;

    /** The object identification number. */
    private Long id;

    /**
     * Returns the logger.
     *
     * @return the logger
     */
    public Logger getLogger() {

        return this.logger;
    }

    /**
     * Sets the logger.
     *
     * @param logger the logger
     */
    public void setLogger(Logger logger) {

        this.logger = logger;
    }

    /**
     * Returns the object identification number.
     *
     * @return the object identification number
     */
    public Long getId() {

        return this.id;
    }

    /**
     * Sets the object identification number.
     *
     * @param id the object identification number
     */
    public void setId(Long id) {

        this.id = id;
    }
}

