/*
 * $RCSfile: WindowDisplayFactory.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.view.swing;

import java.lang.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents a window display factory.
 *
 * @version $Revision: 1.5 $ $Date: 2002/06/12 18:49:40 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class WindowDisplayFactory extends DisplayFactory {

    /**
     * Creates window display.
     *
     * First, a new window is created.
     * Then, the window's root pane is initialized.
     *
     * @param v the application view to create a display for
     * @param pv the parent application view
     * @return the root pane of the display
     * @exception NullPointerException if the window is null
     */
    public ResRootPane createDisplay(SwingView v, SwingView pv) throws NullPointerException {

        ResRootPane r = null;
        ResWindow w = new ResWindow();

        if (w != null) {

            r = (ResRootPane) w.getRootPane();

            initializeRootPane(r, v);
            initializeDisplay(w, v);

        } else {

            throw new NullPointerException("Could not create display. The window is null.");
        }

        return r;
    }

    /**
     * Destroys window display.
     *
     * @param v the swing view whose display is to be destroyed
     * @param pv the parent application view
     * @param r the root pane of the application view
     * @exception NullPointerException if the root pane is null
     */
    public void destroyDisplay(SwingView v, SwingView pv, ResRootPane r) throws NullPointerException {

        if (r != null) {

            ResWindow w = (ResWindow) r.getParent();

            finalizeRootPane(r, v);
            finalizeDisplay(w, v);

        } else {

            throw new NullPointerException("Could not destroy display. The root pane is null.");
        }
    }

    /**
     * Brings display to front.
     *
     * @param r the root pane of the application view whose display is to be brought to front
     * @exception NullPointerException if the root pane is null
     * @exception NullPointerException if the ... ?? is null
     */
    public void bringDisplayToFront(ResRootPane r) throws NullPointerException {
    }

    /**
     * Initializes the display.
     *
     * @param w the window
     * @param v the swing view
     * @exception NullPointerException if the window or the swing view is null
     */
    private void initializeDisplay(ResWindow w, SwingView v) throws NullPointerException {

        if ((w != null) && (v != null)) {

//??            w.setBounds(v.getWindowBounds());
            w.pack();
            w.addWindowListener(new WindowDisplayAdapter(v));
            w.show();

        } else {

            throw new NullPointerException("Could not initialize display. The window or the swing view is null.");
        }
    }

    /**
     * Finalizes the display.
     *
     * @param w the window
     * @param v the swing view
     * @exception NullPointerException if the window or the swing view is null
     */
    private void finalizeDisplay(ResWindow w, SwingView v) throws NullPointerException {

        if ((w != null) && (v != null)) {

            w.hide();

            // Save bounds of window for when redisplayed.
            v.setWindowBounds(w.getBounds());

        } else {

            throw new NullPointerException("Could not finalize display. The window or the swing view is null.");
        }
    }
}

