/*
 * $RCSfile: ResRadioButtonMenuItem.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.view.swing;

import java.awt.event.*;
import java.util.logging.*;
import javax.swing.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents a radio button menu item.
 *
 * @version $Revision: 1.3 $ $Date: 2002/06/12 18:49:40 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ResRadioButtonMenuItem extends JRadioButtonMenuItem {

    /** The control id. */
    private String controlId;

    /** The owning view. When selected, the menuitem causes its owner to issue a Control. */
    private View owner;

    /**
     * Returns the control id.
     *
     * @return the control id
     */
    public String getControlId() {

        return controlId;
    }

    /**
     * Sets the control id.
     *
     * @param controlId the control id
     */
    public void setControlId(String controlId) {

        this.controlId = controlId;
    }

    /**
     * Returns the owning view.
     *
     * @return the owning view
     */
    public View getOwner() {

        return owner;
    }

    /**
     * Sets the owning view.
     *
     * @param view the owning view
     */
    public void setOwner(View owner) {

        owner = owner;
    }

    /**
     * Fires a Control to the corresponding Controller.
     *
     * If there is no such Controller, the search will continue upwards
     * in the View hierarchy for the next controller.
     *
     * @param evt the action event that was received by this button
     */
    protected void fireActionPerformed(ActionEvent evt) {

        View v = getOwner();

        if (v != null) {

//??            v.issueControl(createControl());
        }
    }

    /**
     * Creates a Control.
     *
     * Override this to create something other than a simple no-parameter Control.
     *
     * @return a Control
     */
    protected Control createControl() {

        return null; //??new Control(getControlId());
    }
}

