/*
 * $RCSfile: ResMenuItem.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.view.swing;

import java.lang.*;
import javax.swing.*;
import org.resmedicinae.resmedlib.component.component.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents a menu item.
 *
 * @version $Revision: 1.5 $ $Date: 2002/08/08 21:55:16 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ResMenuItem extends JMenuItem /*??implements PropertyView*/ {
    
    //
    // Attributes.
    //

    /** The control id. */
    private String controlId;

    /** The control parameter. */
    private Object controlParameter;

    //
    // Control specific attributes.
    //
    
    /** The controller. */
    private Controller controller;
    
    /** The model. */
    private Object model;

    /** The owner. */
    private SwingView owner;
    
    //
    // Accelerator.
    //

    /**
     * Returns the default accelerator.
     *
     * @return the default accelerator
     */
/*??
    public KeyStroke getDefaultAccelerator() {

        return null;
    }

    //
    // Armed.
    //

    /**
     * Returns the default is armed flag.
     *
     * @return the default is armed flag
     */
/*??
    public boolean getDefaultIsArmed() {

        return true;
    }

    //
    // Enabled.
    //

    /**
     * Returns the default is enabled flag.
     *
     * @return the default is enabled flag
     */
/*??
    public boolean getDefaultIsEnabled() {

        return false;
    }

    //
    // Action command.
    //

    /**
     * Returns the default action command.
     *
     * @return the default action command
     */
/*??
    public String getDefaultActionCommand() {

        return "";
    }

    //
    // Text.
    //

    /**
     * Returns the default text.
     *
     * @return the default text
     */
/*??
    public String getDefaultText() {

        return "Empty Item";
    }

    //
    // Control id.
    //

    /**
     * Returns the control id.
     *
     * @return the control id
     */
    public String getControlId() {

        return this.controlId;
    }

    /**
     * Sets the control id.
     *
     * @param controlId the control id
     */
    public void setControlId(String controlId) {

        this.controlId = controlId;
    }

    //
    // Control parameter.
    //

    /**
     * Returns the control parameter.
     *
     * @return the control parameter
     */
    public Object getControlParameter() {

        return this.controlParameter;
    }

    /**
     * Sets the control parameter.
     *
     * @param controlParameter the control parameter
     */
    public void setControlParameter(Object controlParameter) {

        this.controlParameter = controlParameter;
    }

    //
    // Controller.
    //

    /**
     * Returns the controller.
     *
     * @return the controller
     */
    public Controller getController() {

        return this.controller;
    }

    /**
     * Sets the controller.
     *
     * @param controller the controller
     */
    public void setController(Controller controller) {

        this.controller = controller;
    }

    //
    // Model.
    //

    /**
     * Returns the model.
     *
     * @return the model
     */
/*??
    public Object getModel() {

        return this.model;
    }

    /**
     * Sets the model.
     *
     * @param model the model
     */
/*??
    public void setModel(Object model) {

        this.model = model;
    }

    //
    // Owner.
    //

    /**
     * Returns the owner.
     *
     * @return the owner
     */
    public SwingView getOwner() {

        return this.owner;
    }

    /**
     * Sets the owner.
     *
     * @param owner the owner
     */
    public void setOwner(SwingView owner) {

        this.owner = owner;
    }

    //
    // Initializable.
    //

    /**
     * Initializes the menu item.
     */
    public void initialize() {

/*??
        // AbstractButton
        setActionCommand(getDefaultActionCommand());
        setText(getDefaultText());

        // JMenuItem
        setAccelerator(getDefaultAccelerator());
        setArmed(getDefaultIsArmed());
        setEnabled(getDefaultIsEnabled());
*/
    }
    
    //
    // Create control.
    //
    
    /**
     * Creates a control.
     *
     * @return the control issued when the button is pressed
     */
    protected Control createControl() {
        
        Control c = new Control();

        if (c != null) {

            c.setId(getControlId());
            
        } else {
            
            throw new NullPointerException("Could not create control. The control is null.");
        }

        return c;
    }
    
    //
    // Control issuing.
    //
    
    /**
     * Issues a control to this view's controller.
     *
     * @param c the control to be issued
     */
    public void issue(Control control) {
    }
}

