/*
 * $RCSfile: ResMenuBar.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.view.swing;

import java.lang.*;
import javax.swing.*;
import org.resmedicinae.resmedlib.component.control.*;

/**
 * This class represents a menu bar.
 *
 * @version $Revision: 1.7 $ $Date: 2002/08/08 21:55:16 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ResMenuBar extends JMenuBar {

    // The controller.
    private Controller controller;
    
    //
    // Role methods.
    //

    /**
     * Returns the default exit menu item.
     *
     * @return the default exit menu item
     * @exception NullPointerException if the menu item is null
     */
    public ResMenuItem getDefaultExitMenuItem() throws NullPointerException {

        ResMenuItem mi = new ResMenuItem();

        if (mi != null) {

            mi.initialize();

        } else {

            throw new NullPointerException("Could not create menu item. The menu item is null.");
        }

        return mi;
    }

    /**
     * Returns the model object that is bound to this view.
     *
     * @return the model object that is bound to this view
     */
    public Object getModel() {

        return getBoundModel();
    }

    /**
     * Sets the model object that is bound to this view.
     *
     * @param o the model object
     */
    public void setModel(Object o) {

        setBoundModel(o);
    }

    /**
     * Returns the swing bound model's actual bound model.
     *
     * @return the swing bound model's actual bound model
     */
    public Object getBoundModel() {

        return null;
    }

    /**
     * Sets the actual bound model at swing bound model.
     *
     * @param o the bound model object
     */
    public void setBoundModel(Object o) {
    }

    /**
     * Refreshes the view.
     */
    public void refresh() {
    }

    /**
     * Returns the Controller.
     *
     * Don't assign a direct controller.
     * Instead, delegate to the containing SwingView that has a parent controller.
     */
    public Controller getController() {

        return this.controller;
    }

    /**
     * Sets the Controller.
     *
     * @param controller the controller
     */
    public void setController(Controller controller) {

        this.controller = controller;
    }

    /**
     * Issues control.
     *
     * Don't assign a direct controller to List.
     * Instead, delegate to the containing SwingView that has a parent controller.
     *
     * @param c the control
     */
    public void issueControl(Control c) {

        //?? Eliminate scope dependency here.
//??        org.scopemvc.view.swing.SwingUtil.issueControl(this, c);
    }

    //
    // Initializable.
    //

    /**
     * Initializes this component.
     */
    public void initialize() throws Exception {

        add(getDefaultExitMenuItem());
    }

    /**
     * Finalizes this component.
     */
    public void finalizz() throws Exception {

//??        remove(getExitMenuItem());
    }
}

