/*
 * $RCSfile: ResDialog.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.view.swing;

import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.*;

/**
 * This class represents a dialog.
 *
 * @version $Revision: 1.2 $ $Date: 2002/05/02 10:18:34 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ResDialog extends JDialog implements ApplicationDisplay {

    /**
     * Constructs dialog.
     *
     * @param f the frame owning this dialog
     * @param title the dialog title
     * @param modal the flag indicating whether or not the dialog is modal
     */
    public ResDialog(Frame f) {

        this(f, null, false);
    }

    /**
     * Constructs dialog.
     *
     * @param f the frame owning this dialog
     * @param title the dialog title
     * @param modal the flag indicating whether or not the dialog is modal
     */
    public ResDialog(Frame f, String title, boolean modal) {

        super(f, title, modal);
    }

    /**
     * Constructs dialog.
     *
     * @param d the dialog owning this dialog
     * @param title the dialog title
     * @param modal the flag indicating whether or not the dialog is modal
     */
    public ResDialog(Dialog d) {

        this(d, null, false);
    }

    /**
     * Constructs dialog.
     *
     * @param d the dialog owning this dialog
     * @param title the dialog title
     * @param modal the flag indicating whether or not the dialog is modal
     */
    public ResDialog(Dialog d, String title, boolean modal) {

        super(d, title, modal);
    }

    /**
     * Creates root pane.
     *
     * @return the root pane
     */
    protected JRootPane createRootPane() {

        return new ResRootPane();
    }
}

