/*
 * $RCSfile: InternalFrameDisplayAdapter.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.view.swing;

import java.lang.*;
import javax.swing.event.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents an adapter that listens to internal frame events.
 *
 * It is to be attached to internal frames created by a display factory
 * so that they issue a Control on closing.
 *
 * @version $Revision: 1.4 $ $Date: 2002/06/12 18:49:40 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class InternalFrameDisplayAdapter extends InternalFrameAdapter implements DisplayAdapter {

    /** The view. */
    private SwingView view;

    /**
     * Constructs an object.
     *
     * @param v the view
     */
    public InternalFrameDisplayAdapter(SwingView v) {

        setView(v);
    }

    /**
     * Returns the view.
     *
     * @return the view
     */
    public SwingView getView() {

        return this.view;
    }

    /**
     * Sets the view.
     *
     * @param view the view
     */
    public void setView(SwingView view) {

        this.view = view;
    }

    /**
     * Invoked when the user attempts to close the window from the window's
     * system menu.
     *
     * If the program does not explicitly hide or dispose the window while
     * processing this event, the window close operation will be cancelled.
     *
     * @param evt the internal frame closing event
     */
    public void internalFrameClosing(InternalFrameEvent evt) {

//??        getView().issueControl(getView().getCloseControl());
    }
}

