/*
 * $RCSfile: MenuItem.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.view.graphical;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.component.view.*;
import org.resmedicinae.resmedlib.number.Integer;
import org.resmedicinae.resmedlib.term.String;

/**
 * This class represents a menu item.
 *
 * @version $Revision: 1.5 $ $Date: 2002/12/18 17:11:27 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class MenuItem extends GraphicalViewComponent {

    //
    // Static attribute ids.
    //

    /** The label id. */
    public static final String LABEL = new String("label");

    /** The mnemonic id. */
    public static final String MNEMONIC = new String("mnemonic");

    /** The signal id. */
    public static final String SIGNAL = new String("signal");

    //
    // Child management.
    //

    /**
     * Adds the item to become a child of this item.
     *
     * @param n the name
     * @param i the item
     * @exception NullPointerException if the name is null
     */
    public void set(String n, Item i) throws NullPointerException {

        super.set(n, i);

        if (n != null) {

            if (n.isEqualTo(MenuItem.LABEL)) {

                setLabel((String) i);

            } else if (n.isEqualTo(MenuItem.MNEMONIC)) {

                setMnemonic((Integer) i);

            } else if (n.isEqualTo(MenuItem.SIGNAL)) {

                setSignal((String) i);
            }

        } else {

            throw new NullPointerException("Could not set item. The name is null.");
        }
    }

    /**
     * Removes the child item from this item.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void remove(String n) throws NullPointerException {

        try {
                
            if (n != null) {
    
                if (n.isEqualTo(MenuItem.LABEL)) {

                    removeLabel((String) get(n));

                } else if (n.isEqualTo(MenuItem.MNEMONIC)) {

                    removeMnemonic((Integer) get(n));

                } else if (n.isEqualTo(MenuItem.SIGNAL)) {
    
                    removeSignal((String) get(n));
                }

            } else {
    
                throw new NullPointerException("Could not remove item. The name is null.");
            }

        } finally {
            
            super.remove(n);
        }
    }

    //
    // Encapsulated java swing menu item.
    //

    /**
     * Creates an encapsulated java swing menu item.
     *
     * @return the encapsulated java swing menu item
     * @exception NullPointerException if the encapsulated java swing menu item is null
     */
    public java.lang.Object createJavaObject() throws NullPointerException {

        javax.swing.JMenuItem mi = new javax.swing.JMenuItem();

        if (mi != null) {

            mi.setText("Menu Item");
            mi.setEnabled(org.resmedicinae.resmedlib.digit.Boolean.TRUE);

        } else {

            throw new NullPointerException("Could not create encapsulated java swing menu item. The encapsulated java swing menu item is null.");
        }

        return mi;
    }

    //
    // Label.
    //

    /**
     * Creates the label.
     *
     * @return the label
     * @exception NullPointerException if the label is null
     */
    public String createLabel() throws Exception, NullPointerException {

        return new String("Menu Item");

/**?? Introduce new Type for each String --> Terms --> Terminology!
        String l = new String();

        if (l != null) {

            l.globalize(get(MenuItem.GLOBALS));
            l.initialize();
            l.link();
            
        } else {

            throw new NullPointerException("Could not create label. The label is null.");
        }

        return l;
*/
    }

    /**
     * Destroys the label.
     *
     * @param l the label
     * @exception NullPointerException if the label is null
     */
    public void destroyLabel(String l) throws Exception, NullPointerException {

/**?? Introduce new Type for each String --> Terms --> Terminology!
        if (l != null) {

            l.unlink();
            l.finalizz();
            l.deglobalize(get(MenuItem.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy label. The label is null.");
        }
*/
    }

    /**
     * Sets the label.
     *
     * @param l the label
     * @exception NullPointerException if the java abstract button is null
     * @exception NullPointerException if the label is null
     */
    public void setLabel(String l) throws NullPointerException {

        javax.swing.AbstractButton b = (javax.swing.AbstractButton) getJavaObject();

        if (b != null) {

            if (l != null) {

                b.setText((java.lang.String) l.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set label. The label is null.");
            }

        } else {

            throw new NullPointerException("Could not set label. The java abstract button is null.");
        }
    }

    /**
     * Removes the label.
     *
     * @param l the label
     * @exception NullPointerException if the java abstract button is null
     * @exception NullPointerException if the label is null
     */
    public void removeLabel(String l) throws NullPointerException {

        javax.swing.AbstractButton b = (javax.swing.AbstractButton) getJavaObject();

        if (b != null) {

            if (l != null) {

                b.setText(null);

            } else {
    
                throw new NullPointerException("Could not remove label. The label is null.");
            }

        } else {

            throw new NullPointerException("Could not remove label. The java abstract button is null.");
        }
    }

    //
    // Mnemonic.
    //

    /**
     * Creates the mnemonic.
     *
     * @return the mnemonic
     * @exception NullPointerException if the mnemonic is null
     */
    public Integer createMnemonic() throws Exception, NullPointerException {

        return new Integer(0);

/**?? Introduce new Type for each String --> Terms --> Terminology!
        Integer m = new Integer();

        if (m != null) {

            m.globalize(get(MenuItem.GLOBALS));
            m.initialize();
            m.link();
            
        } else {

            throw new NullPointerException("Could not create mnemonic. The mnemonic is null.");
        }

        return m;
*/
    }

    /**
     * Destroys the mnemonic.
     *
     * @param m the mnemonic
     * @exception NullPointerException if the mnemonic is null
     */
    public void destroyMnemonic(Integer m) throws Exception, NullPointerException {

/**?? Introduce new Type for each String --> Terms --> Terminology!
        if (m != null) {

            m.unlink();
            m.finalizz();
            m.deglobalize(get(MenuItem.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy mnemonic. The mnemonic is null.");
        }
*/
    }

    /**
     * Sets the mnemonic.
     *
     * @param m the mnemonic
     * @exception NullPointerException if the java abstract button is null
     * @exception NullPointerException if the mnemonic is null
     * @exception NullPointerException if the mnemonic java object is null
     */
    public void setMnemonic(Integer m) throws NullPointerException {

        javax.swing.AbstractButton b = (javax.swing.AbstractButton) getJavaObject();

        if (b != null) {

            if (m != null) {

                java.lang.Integer i = (java.lang.Integer) m.getJavaObject();

                if (i != null) {
                    
                    b.setMnemonic(i.intValue());

                } else {
        
                    throw new NullPointerException("Could not set mnemonic. The mnemonic java object is null.");
                }

            } else {
    
                throw new NullPointerException("Could not set mnemonic. The mnemonic is null.");
            }

        } else {

            throw new NullPointerException("Could not set mnemonic. The java abstract button is null.");
        }
    }

    /**
     * Removes the mnemonic.
     *
     * @param m the mnemonic
     * @exception NullPointerException if the java abstract button is null
     * @exception NullPointerException if the mnemonic is null
     * @exception NullPointerException if the mnemonic java object is null
     */
    public void removeMnemonic(Integer m) throws NullPointerException {

        javax.swing.AbstractButton b = (javax.swing.AbstractButton) getJavaObject();

        if (b != null) {

            if (m != null) {

                java.lang.Integer i = (java.lang.Integer) m.getJavaObject();

                if (i != null) {
                    
                    b.setMnemonic(0);

                } else {
        
                    throw new NullPointerException("Could not set mnemonic. The mnemonic java object is null.");
                }

            } else {
    
                throw new NullPointerException("Could not remove mnemonic. The mnemonic is null.");
            }

        } else {

            throw new NullPointerException("Could not remove mnemonic. The java abstract button is null.");
        }
    }

    //
    // Signal.
    //
    
    /**
     * Sets the signal.
     *
     * @param s the signal
     * @exception NullPointerException if the java abstract button is null
     * @exception NullPointerException if the signal is null
     */
    public void setSignal(String s) throws NullPointerException {

        javax.swing.AbstractButton b = (javax.swing.AbstractButton) getJavaObject();

        if (b != null) {

            if (s != null) {

                b.setActionCommand((java.lang.String) s.getJavaObject());
//??                b.addActionListener(s);

            } else {
    
                throw new NullPointerException("Could not set signal. The signal is null.");
            }

        } else {

            throw new NullPointerException("Could not set signal. The java abstract button is null.");
        }
    }

    /**
     * Removes the signal.
     *
     * @param s the signal
     * @exception NullPointerException if the java abstract button is null
     * @exception NullPointerException if the signal is null
     */
    public void removeSignal(String s) throws NullPointerException {

        javax.swing.AbstractButton b = (javax.swing.AbstractButton) getJavaObject();

        if (b != null) {

            if (s != null) {

                b.setActionCommand(null);
//??                b.removeActionListener(s);

            } else {
    
                throw new NullPointerException("Could not remove signal. The signal is null.");
            }

        } else {

            throw new NullPointerException("Could not remove signal. The java abstract button is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this split pane.
     */
    public void initialize() throws Exception {

        super.initialize();

        set(MenuItem.LABEL, createLabel());
        set(MenuItem.MNEMONIC, createMnemonic());
    }

    /**
     * Finalizes this split pane.
     */
    public void finalizz() throws Exception {

        try {

            destroyMnemonic((Integer) get(MenuItem.MNEMONIC));
            remove(MenuItem.MNEMONIC);

            destroyLabel((String) get(MenuItem.LABEL));
            remove(MenuItem.LABEL);

        } finally {

            super.finalizz();
        }
    }
}

