/*
 * $RCSfile: DisplayManager.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.view;

import java.lang.*;
import org.resmedicinae.resmedlib.component.component.*;
import org.resmedicinae.resmedlib.component.logger.*;

/**
 * This class represents a display manager.
 *
 * It cares about the creation and destruction of displays which can be:
 * - text
 * - swing
 * - servlet
 *
 * @version $Revision: 1.8 $ $Date: 2002/09/06 07:51:33 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class DisplayManager extends Component {

    //
    // Constants.
    //

    /** The role constant. */
    public static final String ROLE = "display_manager";

    /** The text view context constant. */
    public static final int TEXT = 0;

    /** The swing view context constant. */
    public static final int SWING = 1;

    /** The jsp view context constant. */
    public static final int JSP = 2;

    //
    // Role.
    //

    /**
     * Returns the role.
     *
     * @return the role
     */
    public String getRole() {

        return DisplayManager.ROLE;
    }

    //
    // Creation and destruction of displays.
    //

    /**
     * Creates a display for the view.
     *
     * If a root pane already exists for the given application view,
     * then the view's display is brought to front.
     * Otherwise, a new display will be created for the application view and
     * its root pane will be registered here.
     *
     * @param v the view
     * @param pv the parent view
     */
    public void createDisplay(View v, View pv) throws Exception {
    }

    /**
     * Destroys the display of the view.
     *
     * The root pane of the given application view will be unregistered here.
     *
     * @param v the view
     * @param pv the parent view
     */
    public void destroyDisplay(View v, View pv) throws Exception {
    }

    /**
     * Destroys all open displays.
     */
    public void destroyAllDisplays() {
    }

    //
    // Message display.
    //

    /**
     * Shows a message dialog.
     *
     * @param lev the level
     * @param msg the message
     * @param t the throwable
     */
    public void showMessage(Level lev, String msg, Throwable t) throws Exception {
    }
}

