/*
 * $RCSfile: JdbcFacade.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.model.jdbc;

import java.lang.*;
import java.sql.*;
import java.util.*;
import org.resmedicinae.resmedlib.component.model.*;
import org.resmedicinae.resmedlib.domain.*;

/**
 * This class represents a jdbc facade.
 *
 * It translates method calls into SQL queries.
 *
 * @version $Revision: 1.3 $ $Date: 2002/06/12 18:49:39 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class JdbcFacade extends Facade {

    /** The find statement. */
    private String findStatement;

    /** The insert statement. */
    private String insertStatement;

    /**
     * Returns the find statement.
     *
     * @return the find statement
     */
    public String getFindStatement() {

        return this.findStatement;
    }

    /**
     * Sets the find statement.
     *
     * @param findStatement the find statement
     */
    public void setFindStatement(String findStatement) {

        this.findStatement = findStatement;
    }

    /**
     * Returns the insert statement.
     *
     * @return the insert statement
     */
    public String getInsertStatement() {

        return this.insertStatement;
    }

    /**
     * Sets the insert statement.
     *
     * @param insertStatement the insert statement
     */
    public void setInsertStatement(String insertStatement) {

        this.insertStatement = insertStatement;
    }

    /**
     * Finds a domain object by id.
     *
     * @param id the domain object id
     * @return the domain object
     */
    public DomainObject find(long id) {

        return find(new Long(id));
    }

    /**
     * Finds a domain object.
     *
     * If the object cannot be found in the map of cached domain objects,
     * a query to the database will be started.
     *
     * @param id the domain object id
     * @return a domain object
     * @exception NullPointerException if the map of cached domain objects is null
     */
    protected DomainObject find(Long id) throws NullPointerException {

        DomainObject o = null;
        Map m = getLoadedObjects();

        if (m != null) {

            o = (DomainObject) m.get(id);

            if (o == null) {

                o = queryDatabase(id);
            }

        } else {

            throw new NullPointerException("Could not find domain object. The map of cached domain objects is null.");
        }

        return o;
    }

    /**
     * Queries the database.
     *
     * The retrieved result set will be used to load the domain object.
     *
     * @param id the domain object id
     * @return a domain object
     * @exception NullPointerException if the id is null
     * @exception NullPointerException if the statement is null
     */
    protected DomainObject queryDatabase(Long id) throws NullPointerException {

        DomainObject o = null;

        try {

/*??
            PreparedStatement s = DB.prepare(getFindStatement());

            if (id != null) {

                long l = id.longValue();

                if (s != null) {

                    s.setLong(1, l);

                    ResultSet rs = s.executeQuery();
                    o = load(rs);

                } else {

                    throw new NullPointerException("Could not find domain object. The find statement is null.");
                }

            } else {

                throw new NullPointerException("Could not find domain object. The id is null.");
            }
*/

        } finally {

//??            DB.cleanUp(s, rs);
        }

        return o;
    }

    /**
     * Loads a domain object.
     *
     * Notice that the identity map is checked twice, once by <code>find</code>
     * and once by <code>load</code>. There is a reason for this madness.</br>
     * The identity map is checked in <code>find</code> to save a trip to the
     * database, if the object is already there.
     * But the identity map also needs to be checked in <code>load</code>
     * because there may be queries that one can't be sure of resolving in the
     * identity map.</br>
     * For example, when trying to find everyone whose last name matches some
     * search pattern, then it is not sure that all such people are already
     * loaded. So, a query to the database has to be run.
     *
     * @param rs the result set
     * @return the domain object
     * @exception NullPointerException if the result set is null
     * @exception NullPointerException if the map of loaded domain objects is null
     */
    protected DomainObject load(ResultSet rs) throws NullPointerException, SQLException {

        DomainObject o = null;

        if (rs != null) {

            rs.next();
            long l = rs.getLong("id");
            Long id = new Long(l);
            Map m = getLoadedObjects();

            if (m != null) {

                //?? Is this test necessary?
//??                if (m.containsKey(id)) {

                o = (DomainObject) m.get(id);
//??                }

            } else {

                throw new NullPointerException("Could not load domain object. The map of loaded domain objects is null.");
            }

        } else {

            throw new NullPointerException("Could not load domain object. The result set is null.");
        }

        return o;
    }

    /**
     * Inserts the domain object.
     *
     * @param o the domain object
     * @return the id of the domain object
     * @exception NullPointerException if the map of loaded domain objects is null
     * @exception NullPointerException if the domain object is null
     * @exception NullPointerException if the insert statement is null
     */
    public Long insert(DomainObject o) throws NullPointerException {

        Long id = null; //??findNextDatabaseId();

        if (o != null) {

            o.setId(id);

/*??
            PreparedStatement s = DB.prepare(getInsertStatement());

            if (s != null) {

                s.setInt(1, id.intValue());
                doInsert(o, s); // Make it an overloaded method of this "insert" in child class!!
                s.execute();

                Map m = getLoadedObjects();

                if (m != null) {

                    m.put(id, o);

                } else {

                    throw new NullPointerException("Could not insert domain object. The map of loaded domain objects is null.");
                }

            } else {

                throw new NullPointerException("Could not insert domain object. The insert statement is null.");
            }
*/

        } else {

            throw new NullPointerException("Could not insert domain object. The domain object is null.");
        }

        return id;
    }
}

