/*
 * $RCSfile: PersistenceManager.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.model;

import java.lang.*;
import org.resmedicinae.resmedlib.component.component.*;
import org.resmedicinae.resmedlib.component.logger.*;

/**
 * This class represents a persistence manager.
 *
 * It manages the persistence mechanism for the component, for example:
 * - xml
 * - jdbc
 * - corba
 * - soap
 * - rmi
 *
 * @version $Revision: 1.3 $ $Date: 2002/06/12 18:49:38 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class PersistenceManager extends Component {

    //
    // Constants.
    //

    /** The role constant. */
    public static final String ROLE = "persistence_manager";

    /** The xml model constant. */
    public static final int XML = 0;

    /** The jdbc model constant. */
    public static final int JDBC = 1;

    /** The corba model constant. */
    public static final int CORBA = 2;

    /** The soap model constant. */
    public static final int SOAP = 3;

    /** The rmi model constant. */
    public static final int RMI = 4;

    //
    // Role.
    //

    /**
     * Returns the role.
     *
     * @return the role
     */
    public String getRole() {

        return PersistenceManager.ROLE;
    }
}

