/*
 * $RCSfile: Facade.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.model;

import java.lang.*;
import java.util.*;
import org.resmedicinae.resmedlib.component.component.*;

/**
 * This class represents an abstract facade.
 *
 * @version $Revision: 1.4 $ $Date: 2002/06/12 18:49:38 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Facade extends Component {

    /** The map caching loaded domain objects. */
    private Map loadedObjects;

    /**
     * Returns the map containing loaded objects.
     *
     * @return the map containing loaded objects
     */
    public Map getLoadedObjects() {

        return this.loadedObjects;
    }

    /**
     * Sets the map containing loaded objects.
     *
     * @param loadedObjectsMap the map containing loaded objects
     */
    public void setLoadedObjects(Map loadedObjects) {

        this.loadedObjects = loadedObjects;
    }

    /**
     * Initializes this object.
     */
    public void initialize() {

        setLoadedObjects(new HashMap());
    }
}

