/*
 * $RCSfile: Level.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.logger;

import java.lang.*;

/**
 * This class represents a logger level.
 *
 * @version $Revision: 1.6 $ $Date: 2002/05/07 09:07:05 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Level extends java.util.logging.Level {

    /** The level to turn off logging. */
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);

    /** The level indicating a serious failure. */
    public static final Level SEVERE = new Level("SEVERE", 1000);

    /** The level indicating a potential problem. */
    public static final Level WARNING = new Level("WARNING", 900);

    /** The level for informational messages. */
    public static final Level INFO = new Level("INFO", 800);

    /** The level for static configuration messages. */
    public static final Level CONFIG = new Level("CONFIG", 700);

    /** The level providing tracing information. */
    public static final Level FINE = new Level("FINE", 500);

    /** The level indicating a fairly detailed tracing message. */
    public static final Level FINER = new Level("FINER", 400);

    /** The level indicating a highly detailed tracing message. */
    public static final Level FINEST = new Level("FINEST", 300);

    /** The level indicating that all messages should be logged. */
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);

    /**
     * Constructs a named level with a given integer value.
     *
     * Note that this constructor is "protected" to allow subclassing.
     * In general clients of logging should use one of the constant level
     * objects such as SEVERE or FINEST.  However, if clients need to
     * add new logging levels, they may subclass Level and define new
     * constants.
     *
     * @param name the name of the level, for example "SEVERE"
     * @param value the integer value for the level
     */
    protected Level(String name, int value) {

        super(name, value);
    }
}

