/*
 * $RCSfile: User.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.control;

import java.lang.*;
import org.resmedicinae.resmedlib.component.component.*;

/**
 * This class represents a user.
 *
 * @version $Revision: 1.3 $ $Date: 2002/06/12 18:49:37 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class User extends Component {

    /** The login. */
    String login;

    /** The password. */
    String password;

    /** The configuration. */
    String configuration;

    /**
     * Returns the login.
     *
     * @return the login
     */
    public String getLogin() {

        return this.login;
    }

    /**
     * Sets the login.
     *
     * @param login the login
     */
    public void setLogin(String login) {

        this.login = login;
    }

    /**
     * Returns the password.
     *
     * @return the password
     */
    public String getPassword() {

        return this.password;
    }

    /**
     * Sets the password.
     *
     * @param password the password
     */
    public void setPassword(String password) {

        this.password = password;
    }

    /**
     * Returns the configuration.
     *
     * @return the configuration
     */
    public String getConfiguration() {

        return this.configuration;
    }

    /**
     * Sets the configuration.
     *
     * @param configuration the configuration
     */
    public void setConfiguration(String configuration) {

        this.configuration = configuration;
    }
}

