/*
 * $RCSfile: Controller.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.control;

import java.lang.*;
import org.resmedicinae.resmedlib.component.component.*;

/**
 * This class represents a controller.
 *
 * A controller can control a model and a view, following the
 * Model-View-Controller (MVC) design pattern.
 * - the view gets data from the model and displays them
 * - the controller reacts on view events in the <code>handle</code> method
 * - the model gets manipulated by the controller and then sends an update event to the view
 *
 * Design patterns:
 * - Controller in Model View Controller
 *
 * @version $Revision: 1.8 $ $Date: 2002/06/12 18:49:37 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Controller extends Component {

    //
    // Constants.
    //
    
    public static final String DESTROY_CONTROLLER_CONTROL_ID = "destroy_controller";
}

