/*
 * $RCSfile: Control.java,v $
 *
 * Copyright (c) 1999-2001. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.control;

import java.lang.*;
import org.resmedicinae.resmedlib.component.control.*;

/**
 * This class represents a control.
 *
 * It is passed up the chain of Controllers to invoke a piece of presentation logic.
 * Controllers match against the id of a Control passed into BasicController#handleControl.
 * If the id is recognised then the Controller can execute some presentation logic.
 * If the Control id is not recognised, the Control should be sent back on its journey
 * up the chain of responsibility by passing it to the parent Controller.
 * See Controller#passControlToParent
 *
 * Controls are received by a Controller from either a View or a child Controller.
 * Controls can optionally contain an Object parameter.
 *
 * The Control id is used by Controllers to recognise a Control and also as a key
 * to the user-readable version of the Control's name in UIStrings presented to
 * the user by the default error-handling mechanism in BasicController.
 *
 * @version $Revision: 1.7 $ $Date: 2002/06/12 18:49:37 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Control extends Object {

    //
    // Attributes.
    //
    
    /** The id. */
    private String id;

    /** The sender. */
    private Object sender;

    /** The matched flag. */
    private boolean matched;

    //
    // Id.
    //
    
    /**
     * Returns the id.
     *
     * @return the id
     */
    public String getId() {

        return this.id;
    }
     
    /**
     * Sets the id.
     *
     * @param id the id
     */
    public void setId(String id) {

        this.id = id;        
    }
    
    /**
     * Creates an id.
     *
     * @return the id
     */
    public String createId() {

        return "";        
    }
    
    /**
     * Destroys the id.
     *
     * @param id the id
     */
    public void destroyId(String id) {
    }

    //
    // Sender.
    //
    
    /**
     * Returns the sender.
     *
     * @return the sender
     */
    public Object getSender() {

        return this.sender;
    }
     
    /**
     * Sets the sender.
     *
     * @param sender the sender
     */
    public void setSender(Object sender) {

        this.sender = sender;        
    }

    /**
     * Creates a sender.
     *
     * @return the sender
     */
    public Object createSender() {

        return null;        
    }

    /**
     * Destroys the sender.
     *
     * @param sender the sender
     */
    public void destroySender(Object sender) {
    }

    //
    // Matched flag.
    //
    
    /**
     * Returns the matched flag.
     *
     * @return the matched flag
     */
    public boolean getMatched() {

        return this.matched;
    }
     
    /**
     * Sets the matched flag.
     *
     * @param matched the matched flag
     */
    public void setMatched(boolean matched) {

        this.matched = matched;        
    }
    
    /**
     * Creates a matched flag.
     *
     * @return the matched flag
     */
    public boolean createMatched() {

        return false;        
    }
    
    /**
     * Destroys the matched flag.
     *
     * @param matchedFlag the matched flag
     */
    public void destroyMatched(boolean matched) {
    }

    //
    // Initializable.
    //
    
    /**
     * Initializes this component.
     */
    public void initialize() {

        setId(createId());
        setSender(createSender());        
        setMatched(createMatched());        
    }

    /**
     * Finalizes this component.
     */
    public void finalizz() {

        destroyMatched(getMatched());
        setMatched(false);
        destroySender(getSender());        
        setSender(null); 
        destroyId(getId());
        setId(null);
    }

    //
    // Role methods.
    //
    
    /**
     * Returns a boolean value indicating whether or not the id matches.
     *
     * @param id the id string to be checked
     * @return the string representation of this object
     * @exception NullPointerException if the id is null
     */
    public boolean matches(String id) throws NullPointerException {

        boolean b = false;

        if (getMatched() == false) {
                
            if (id != null) {
    
                b = id.equals(getId());
    
                System.out.println("test set control id: " + getId());
                System.out.println("test control id to distinguish: " + id);
                System.out.println("test boolean: " + b);
                
                setMatched(b);
                
            } else {
                
                throw new NullPointerException("Could not compare ids. The id is null.");
            }
        }
        
        return b;
    }

    /**
     * Returns the string representation of this object.
     *
     * @return the string representation of this object
     */
    public String toString() {

        return getId();         
    }
}

