/*
 * $RCSfile: Context.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.component.context;

import java.lang.*;
import java.util.*;
import org.resmedicinae.resmedlib.component.component.*;

/**
 * This interface defines a context.
 *
 * It is needed by the Contextualizable interface defining contextualizable components.
 *
 * @version $Revision: 1.12 $ $Date: 2002/06/12 18:49:37 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Context extends Item {

    //
    // Attributes.
    //

    /** The map. */
    private Map map;

    //
    // Map.
    //

    /**
     * Returns the map.
     *
     * @return the map
     */
    public Map getMap() {

        return this.map;
    }

    /**
     * Sets the map.
     *
     * @param map the map
     */
    public void setMap(Map map) {

        this.map = map;
    }

    /**
     * Creates a hash table map.
     *
     * @return the hash table map
     */
    public Map createMap() {

        // Hashtable cannot be used here!
        // It can't hold null values which are used by some ResMedicinae applications.
        return new HashMap();
    }

    /**
     * Destroys the map.
     *
     * @param m the map
     * @exception NullPointerException if the map is null
     */
    public void destroyMap(Map m) throws NullPointerException {

        if (m != null) {

            m.clear();

        } else {

            throw new NullPointerException("Could not finalize context. The map is null.");
        }
    }

    //
    // Initializable.
    //

    /*
     * Initializes this component.
     */
    public void initialize() throws Exception {

        setMap(createMap());
    }

    /*
     * Finalizes this component.
     */
    public void finalizz() throws Exception {

        destroyMap(getMap());
        setMap(null);
    }

    //
    // Add and remove.
    //

    /**
     * Returns the object with the given key.
     *
     * @param key the key
     * @return the object with the given key
     */
    public Object getEntry(Object key) {

        Object o = null;
        Map m = getMap();

        if (m != null) {

            o = m.get(key);

        } else {

            throw new NullPointerException("Could not get object. The map is null.");
        }

        return o;
    }

    /**
     * Puts the object with the given key.
     *
     * @param key the key
     * @param value the object
     */
    public void putEntry(Object key, Object value) {

        Map m = getMap();

        if (m != null) {

            m.put(key, value);

        } else {

            throw new NullPointerException("Could not put object. The map is null.");
        }
    }

    /**
     * Removes the object with the given key.
     *
     * @param key the key
     */
    public void removeEntry(Object key) {

        Map m = getMap();

        if (m != null) {

            m.remove(key);

        } else {

            throw new NullPointerException("Could not remove object. The map is null.");
        }
    }
}

