/*
 * $RCSfile: Time.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.chain;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.number.*;

/**
 * This class represents a time.
 *
 * A time is always specifying the difference between an origin and
 * the poorg.resmedicinae.resmedlib.number.Integer in time itself and hence spans up a time space.
 *
 * A time is often called the fourth dimension in our abstract model
 * of the real world. It is determined by only one integer number but
 * can have various representations. The most famous representation
 * of time for us humans is the calendar. There are several types of
 * calendars that can be used, e.g. the Gregorian calendar. 
 *
 * @version $Revision: 1.4 $ $Date: 2002/09/21 21:14:00 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Time extends Chain {
    
    //
    // Attributes.
    //
    
    /** The time difference. */
    private org.resmedicinae.resmedlib.number.Integer t;
    
    //
    // The time difference.
    //
    
    /**
     * Returns the time difference.
     *
     * @return the time difference
     */
    public org.resmedicinae.resmedlib.number.Integer getT() {
        
        return this.t;
    }
    
    /**
     * Sets the time difference.
     *
     * @param t the time difference
     */
    public void setT(org.resmedicinae.resmedlib.number.Integer t) {

        this.t = t;
    }
}

