/*
 * $RCSfile: Space.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.chain;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.number.*;

/**
 * This class represents a geometrical point.
 *
 * A poorg.resmedicinae.resmedlib.number.Integer is always specifying the distance between an origin and the point
 * itself and hence spans up a room/space.
 *
 * A poorg.resmedicinae.resmedlib.number.Integer is defined as smallest abstract item in space.
 * It is determined by the three coordinates x, y and z.
 *
 * @version $Revision: 1.4 $ $Date: 2002/09/21 21:14:00 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Space extends Chain {
    
    //
    // Attributes.
    //

    /** The x coordinate. */
    private org.resmedicinae.resmedlib.number.Integer x;
    
    /** The y coordinate. */
    private org.resmedicinae.resmedlib.number.Integer y;
    
    /** The z coordinate. */
    private org.resmedicinae.resmedlib.number.Integer z;

    //
    // The x coordinate.
    //
    
    /**
     * Returns the x coordinate.
     *
     * @return the x coordinate
     */
    public org.resmedicinae.resmedlib.number.Integer getX() {
        
        return this.x;
    }
    
    /**
     * Sets the x coordinate.
     *
     * @param x the x coordinate
     */
    public void setX(org.resmedicinae.resmedlib.number.Integer x) {
        
        this.x = x;
    }
    
    //
    // The y coordinate.
    //
    
    /**
     * Returns the y coordinate.
     *
     * @return the y coordinate
     */
    public org.resmedicinae.resmedlib.number.Integer getY() {
        
        return this.y;
    }
    
    /**
     * Sets the y coordinate.
     *
     * @param y the y coordinate
     */
    public void setY(org.resmedicinae.resmedlib.number.Integer y) {
        
        this.y = y;
    }
    
    //
    // The z coordinate.
    //
    
    /**
     * Returns the z coordinate.
     *
     * @return the z coordinate
     */
    public org.resmedicinae.resmedlib.number.Integer getZ() {
        
        return this.z;
    }
    
    /**
     * Sets the z coordinate.
     *
     * @param z the z coordinate
     */
    public void setZ(org.resmedicinae.resmedlib.number.Integer z) {

        this.z = z;
    }
}

