/*
 * $RCSfile: LogRecord.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.chain;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.term.*;

/**
 * This class represents a log record.
 *
 * A log record corresponds to a chromosome in a human cell core which get
 * shorter in the process of cell duplication which causes cells to get old.
 *
 * In that meaning, a log record is something like the history of a component.
 * It keeps track of state changes, caused by events (signals). The log record
 * should be handed over from component to component within the globals structure.
 *
 * A system is responsible for writing out the record to console or file or
 * another location/medium, using mechanisms offered by the framework.
 * 
 * @version $Revision: 1.6 $ $Date: 2002/09/22 19:45:08 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class LogRecord extends Chain {

    //
    // Static attribute ids.
    //

    /** The message id. */
    public static final org.resmedicinae.resmedlib.term.String MESSAGE = new org.resmedicinae.resmedlib.term.String("message");

    /** The throwable id. */
    public static final org.resmedicinae.resmedlib.term.String THROWABLE = new org.resmedicinae.resmedlib.term.String("throwable");

    /** The java throwable. */
    private java.lang.Throwable throwable;

    //
    // Message.
    //

    /**
     * Creates a message.
     *
     * @return the message
     */
    public org.resmedicinae.resmedlib.term.String createMessage() {

        return null;
    }

    /**
     * Destroys the message.
     *
     * @param m the message
     */
    public void destroyMessage(org.resmedicinae.resmedlib.term.String m) {
    }

    //
    // Throwable.
    //

    /**
     * Creates a throwable.
     *
     * @return the throwable
     */
    public java.lang.Throwable createThrowable() {

        return null;
    }

    /**
     * Destroys the throwable.
     *
     * @param t the throwable
     */
    public void destroyThrowable(java.lang.Throwable t) {
    }

    /**
     * Sets the throwable.
     *
     * @param t the throwable
     */
    public void setThrowable(java.lang.Throwable t) {
        
        this.throwable = t;
    }

    /**
     * Returns the throwable.
     *
     * @return the throwable
     */
    public java.lang.Throwable getThrowable() {

        return this.throwable;
    }

    //
    // Initializable.
    //

    /**
     * Initializes this log record.
     */
    public void initialize() throws Exception {

        super.initialize();
        
        set(LogRecord.MESSAGE, createMessage());
        setThrowable(createThrowable());
    }

    /**
     * Finalizes this log record.
     */
    public void finalizz() throws Exception {

        try {

            destroyThrowable(getThrowable());
            setThrowable(null);
            destroyMessage((org.resmedicinae.resmedlib.term.String) get(LogRecord.MESSAGE));
            remove(LogRecord.MESSAGE);

        } finally {

            super.finalizz();
        }
    }
}

