/*
 * $RCSfile: TabPageFactory.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.block.viewfactory;

import org.resmedicinae.resmedlib.block.*;

/**
 * This class represents a tab page display factory.
 *
 * @version $Revision: 1.2 $ $Date: 2002/09/20 16:51:27 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class TabPageFactory extends ViewFactory {

    /**
     * Creates tab page display.
     *
     * First, a new tab page is created.
     * Then, the page's root pane is initialized.
     * Finally, the page will be added to the tabbed pane of the parent controller's view.
     *
     * @param v the application view to create a display for
     * @param pv the parent application view
     * @return the root pane of the display
     * @exception NullPointerException if the display is null
     */
/*??
    public ResRootPane createDisplay(SwingView v, SwingView pv) throws NullPointerException {

        ResRootPane r = null;
        ResTabPage p = new ResTabPage();

        if (p != null) {

            r = (ResRootPane) p.getRootPane();

            initializeRootPane(r, v);
            initializeDisplay(p, v);
            addToTabbedPane(p, (SwingView) pv);

        } else {

            throw new NullPointerException("Could not create display. The tab page is null.");
        }

        return r;
    }

    /**
     * Destroys tab page display.
     *
     * @param v the swing view whose display is to be destroyed
     * @param pv the parent application view
     * @param r the root pane of the application view
     * @exception NullPointerException if the root pane is null
     */
/*??
    public void destroyDisplay(SwingView v, SwingView pv, ResRootPane r) throws NullPointerException {

        if (r != null) {

            ResTabPage p = (ResTabPage) r.getParent();

            removeFromTabbedPane(p, (SwingView) pv);
            finalizeRootPane(r, v);
            finalizeDisplay(p, v);

        } else {

            throw new NullPointerException("Could not destroy display. The root pane is null.");
        }
    }

    /**
     * Brings display to front.
     *
     * @param r the root pane of the swing view whose display is to be brought to front
     * @exception NullPointerException if the root pane is null
     * @exception NullPointerException if the ... ?? is null
     */
/*??
    public void bringDisplayToFront(ResRootPane r) throws NullPointerException {

/*??
        if (r != null) {

            Window w = (Window) r.getParent();

            if (w != null) {

                w.toFront();

            } else {

                throw new NullPointerException("Could not bring display to front. The display of root pane is null.");
            }

        } else {

            throw new NullPointerException("Could not bring display to front. The root pane is null.");
        }
*/
/*??
    }

    /**
     * Initializes the display.
     *
     * @param p the tab page
     * @param v the swing view
     * @exception NullPointerException if the tab page or the application view is null
     */
/*??
    private void initializeDisplay(ResTabPage p, SwingView v) throws NullPointerException {

        if ((p != null) && (v != null)) {

//??            f.setTitle(v.getTitle());
//??            f.setIconImage(null);
            // Select internal frame and bring it to front.
//??            f.setSelected(true);
//??            f.pack();
//??            f.show();

        } else {

            throw new NullPointerException("Could not initialize display. The tab page or the swing view is null.");
        }
    }

    /**
     * Finalizes the display.
     *
     * @param p the tab page
     * @param v the application view
     * @exception NullPointerException if the internal frame or the swing view is null
     */
/*??
    private void finalizeDisplay(ResTabPage p, SwingView v) throws NullPointerException {

        if ((p != null) && (v != null)) {

//??            f.hide();

//??            v.setTitle(f.getTitle());
//??            v.setIconImage(null);
//??            v.setResizable(f.isResizable());
            // Select internal frame and bring it to front.
//??            v.setSelected(true);
            // Save bounds of window for when redisplayed.
//??            v.setViewBounds(f.getBounds());

        } else {

            throw new NullPointerException("Could not finalize display. The tab page or the swing view is null.");
        }
    }

    /**
     * Adds the tab page to the tabbed pane of the parent controller's view.
     *
     * @param p the tab page
     * @param v the swing view of the parent controller
     * @exception NullPointerException if the application view of the parent controller is null
     * @exception NullPointerException if the tabbed pane is null
     */
/*??
    private void addToTabbedPane(ResTabPage p, SwingView v) throws NullPointerException {

        if (v != null) {

            ResTabbedPane tp = (ResTabbedPane) v.getChildApplicationComponent();

            if (tp == null) {

                // Creates a tabbed pane and adds it as the new child
                // application component to the application view.
                tp = createTabbedPane();
                v.setChildApplicationComponent(tp);
            }

            if (tp != null) {

                // Finally adds the tab page to the tabbed pane.
                tp.add("test " + tp.getTabCount(), p);

            } else {

                throw new NullPointerException("Could not add to tabbed pane. The tabbed pane is null.");
            }

        } else {

            throw new NullPointerException("Could not add to tabbed pane. The swing view of the parent controller is null.");
        }
    }

    /**
     * Removes the tab page from the tabbed pane of the parent controller's view.
     *
     * @param p the tab page
     * @param v the swing view of the parent controller
     * @exception NullPointerException if the application view of the parent controller is null
     * @exception NullPointerException if the tabbed pane is null
     */
/*??
    private void removeFromTabbedPane(ResTabPage p, SwingView v) throws NullPointerException {

        if (v != null) {

            ResTabbedPane tp = (ResTabbedPane) v.getChildApplicationComponent();

            if (tp != null) {

                tp.remove(p);

            } else {

                throw new NullPointerException("Could not remove from tabbed pane. The tabbed pane is null.");
            }

        } else {

            throw new NullPointerException("Could not remove from tabbed pane. The swing view of the parent controller is null.");
        }
    }

    /**
     * Creates tabbed pane.
     *
     * @return the tabbed pane
     * @exception NullPointerException if the tabbed pane is null
     */
/*??
    private ResTabbedPane createTabbedPane() throws NullPointerException {

        ResTabbedPane p = new ResTabbedPane();

        if (p != null) {

            // Set faster outline drag mode. It improves performance while dragging because only the outline of an internal frame gui is painted.
//??            p.setDragMode(ResDesktopPane.OUTLINE_DRAG_MODE);

        } else {

            throw new NullPointerException("Could not create tabbed pane. The tabbed pane is null.");
        }

        return p;
    }
*/
}

