/*
 * $RCSfile: InternalFrameFactory.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.block.viewfactory;

import org.resmedicinae.resmedlib.block.*;

/**
 * This class represents an internal frame display factory.
 *
 * @version $Revision: 1.2 $ $Date: 2002/09/20 16:51:27 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class InternalFrameFactory extends ViewFactory {

    /**
     * Creates internal frame display.
     *
     * First, a new internal frame is created.
     * Then, the frame's root pane is initialized.
     * Finally, the frame will be added to the desktop pane of the parent controller's view.
     *
     * @param v the swing view to create a display for
     * @param pv the parent application view
     * @return the root pane of the display
     * @exception NullPointerException if the display is null
     */
/*??
    public ResRootPane createDisplay(SwingView v, SwingView pv) throws NullPointerException {

        ResRootPane r = null;
        ResInternalFrame f = new ResInternalFrame();

        if (f != null) {

            r = (ResRootPane) f.getRootPane();

            initializeRootPane(r, v);
            initializeDisplay(f, v);
            addToDesktopPane(f, (SwingView) pv);

        } else {

            throw new NullPointerException("Could not create display. The internal frame is null.");
        }

        return r;
    }

    /**
     * Destroys internal frame display.
     *
     * @param v the swing view whose display is to be destroyed
     * @param pv the parent application view
     * @param r the root pane of the application view
     * @exception NullPointerException if the root pane is null
     */
/*??
    public void destroyDisplay(SwingView v, SwingView pv, ResRootPane r) throws NullPointerException {

        if (r != null) {

            ResInternalFrame f = (ResInternalFrame) r.getParent();

            removeFromDesktopPane(f, (SwingView) pv);
            finalizeRootPane(r, v);
            finalizeDisplay(f, v);

        } else {

            throw new NullPointerException("Could not destroy display. The root pane is null.");
        }
    }

    /**
     * Brings display to front.
     *
     * @param r the root pane of the application view whose display is to be brought to front
     * @exception NullPointerException if the root pane is null
     * @exception NullPointerException if the ... ?? is null
     */
/*??
    public void bringDisplayToFront(ResRootPane r) throws NullPointerException {

/*??
        if (r != null) {

            Window w = (Window) r.getParent();

            if (w != null) {

                w.toFront();

            } else {

                throw new NullPointerException("Could not bring display to front. The display of root pane is null.");
            }

        } else {

            throw new NullPointerException("Could not bring display to front. The root pane is null.");
        }
*/
/*??
    }

    /**
     * Initializes the display.
     *
     * @param f the internal frame
     * @param v the swing view
     * @exception NullPointerException if the internal frame or the application view is null
     */
/*??
    private void initializeDisplay(ResInternalFrame f, SwingView v) throws NullPointerException {

        if ((f != null) && (v != null)) {

            f.setTitle(v.getTitle());
//??            f.setIconImage(null);
            f.setResizable(v.getResizable());
            // Select internal frame and bring it to front.
//??            f.setSelected(v.isSelected());
            f.setBounds(v.getFrameBounds());
            f.addInternalFrameListener(new InternalFrameDisplayAdapter(v));
            f.show();

        } else {

            throw new NullPointerException("Could not initialize display. The internal frame or the swing view is null.");
        }
    }

    /**
     * Finalizes the display.
     *
     * @param f the internal frame
     * @param v the swing view
     * @exception NullPointerException if the internal frame or the application view is null
     */
/*??
    private void finalizeDisplay(ResInternalFrame f, SwingView v) throws NullPointerException {

        if ((f != null) && (v != null)) {

            f.setVisible(false);
            f.dispose();

            v.setTitle(f.getTitle());
//??            v.setIconImage(null);
            v.setResizable(f.isResizable());
            // Select internal frame and bring it to front.
//??            v.setSelected(f.isSelected());
            // Save bounds of window for when redisplayed.
            v.setFrameBounds(f.getBounds());

        } else {

            throw new NullPointerException("Could not finalize display. The internal frame or the swing view is null.");
        }
    }

    /**
     * Adds the internal frame to the desktop pane of the parent controller's view.
     *
     * @param f the internal frame
     * @param v the swing view of the parent controller
     * @exception NullPointerException if the application view of the parent controller is null
     * @exception NullPointerException if the desktop pane is null
     */
/*??
    private void addToDesktopPane(ResInternalFrame f, SwingView v) throws NullPointerException {

        if (v != null) {

            ResDesktopPane p = (ResDesktopPane) v.getChildApplicationComponent();

            if (p == null) {

                // Creates a desktop pane and adds it as the new child
                // application component to the application view.
                p = createDesktopPane();
                v.setChildApplicationComponent(p);
            }

            if (p != null) {

                // Finally adds the internal frame to the desktop pane.
                p.add(f);

            } else {

                throw new NullPointerException("Could not add to desktop pane. The desktop pane is null.");
            }

        } else {

            throw new NullPointerException("Could not add to desktop pane. The swing view of the parent controller is null.");
        }
    }

    /**
     * Removes the internal frame from the desktop pane of the parent controller's view.
     *
     * @param f the internal frame
     * @param v the swing view of the parent controller
     * @exception NullPointerException if the application view of the parent controller is null
     * @exception NullPointerException if the desktop pane is null
     */
/*??
    private void removeFromDesktopPane(ResInternalFrame f, SwingView v) throws NullPointerException {

        if (v != null) {

            ResDesktopPane p = (ResDesktopPane) v.getChildApplicationComponent();

            if (p != null) {

                p.remove(f);

            } else {

                throw new NullPointerException("Could not remove from desktop pane. The desktop pane is null.");
            }

        } else {

            throw new NullPointerException("Could not remove from desktop pane. The swing view of the parent controller is null.");
        }
    }

    /**
     * Creates desktop pane.
     *
     * @return the desktop pane
     * @exception NullPointerException if the desktop pane is null
     */
/*??
    private ResDesktopPane createDesktopPane() throws NullPointerException {

        ResDesktopPane p = new ResDesktopPane();

        if (p != null) {

            // Set faster outline drag mode. It improves performance while dragging because only the outline of an internal frame gui is painted.
            p.setDragMode(ResDesktopPane.OUTLINE_DRAG_MODE);

        } else {

            throw new NullPointerException("Could not create desktop pane. The desktop pane is null.");
        }

        return p;
    }
*/
}

