/*
 * $RCSfile: PortalView.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.block.view.graphical;

import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.region.view.graphical.*;

/**
 * This class represents a portal view.
 *
 * It is based on a split pane containing a tree menu on the left.
 * The tree offers a hierarchy of categories with available system modules.
 * On the right side of the splitter, there is a container for child system views.
 *
 * @version $Revision: 1.5 $ $Date: 2002/12/12 15:31:06 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class PortalView extends GraphicalView {

    //
    // Menu bar.
    //

    /**
     * Creates a portal menu bar.
     *
     * @return the portal menu bar
     * @exception NullPointerException if the portal menu bar is null
     */
    public MenuBar createMenuBar() throws Exception, NullPointerException {

        PortalMenuBar mb = new PortalMenuBar();

        if (mb != null) {

            mb.globalize(get(PortalView.GLOBALS));
            mb.initialize();
            mb.link();

        } else {

            throw new NullPointerException("Could not create portal menu bar. The portal menu bar is null.");
        }

        return mb;
    }

    //
    // Tool bar.
    //

    /**
     * Creates a portal tool bar.
     *
     * @return the portal tool bar
     * @exception NullPointerException if the portal tool bar is null
     */
/*??
    public PortalToolBar createToolBar() throws Exception, NullPointerException {

        PortalToolBar tb = new PortalToolBar();

        if (tb != null) {

            tb.globalize(get(GraphicalView.GLOBALS));
            tb.initialize();
            tb.link();

        } else {

            throw new NullPointerException("Could not create portal tool bar. The portal tool bar is null.");
        }

        return tb;
    }

    //
    // Contents panel.
    //

    /**
     * Creates a contents panel.
     *
     * @return the contents panel
     * @exception NullPointerException if the contents panel is null
     */
    public ContentsPanel createContentsPanel() throws Exception, NullPointerException {

        PortalContentsPanel p = new PortalContentsPanel();

        if (p != null) {

            p.globalize(get(GraphicalView.GLOBALS));
            p.initialize();
            p.link();

        } else {

            throw new NullPointerException("Could not create portal contents panel. The portal contents panel is null.");
        }

        return p;
    }
}

