/*
 * $RCSfile: GraphicalView.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.block.view;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.block.*;
import org.resmedicinae.resmedlib.chain.*;
import org.resmedicinae.resmedlib.region.view.graphical.*;
import org.resmedicinae.resmedlib.region.view.graphical.frame.*;

/**
 * This class represents a graphical view.
 *
 * @version $Revision: 1.20 $ $Date: 2002/12/19 14:25:04 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class GraphicalView extends View {

    //
    // Static attribute ids.
    //

    /** The graphical view mode id. */
    public static final org.resmedicinae.resmedlib.term.String GRAPHICAL_VIEW_MODE = new org.resmedicinae.resmedlib.term.String("graphical_view_mode");

    /** The title id. */
    public static final org.resmedicinae.resmedlib.term.String TITLE = new org.resmedicinae.resmedlib.term.String("title");

    /** The icon id. */
    public static final org.resmedicinae.resmedlib.term.String ICON = new org.resmedicinae.resmedlib.term.String("icon");

    /** The menu bar id. */
    public static final org.resmedicinae.resmedlib.term.String MENU_BAR = new org.resmedicinae.resmedlib.term.String("menu_bar");

    /** The tool bar id. */
    public static final org.resmedicinae.resmedlib.term.String TOOL_BAR = new org.resmedicinae.resmedlib.term.String("tool_bar");

    /** The contents panel id. */
    public static final org.resmedicinae.resmedlib.term.String CONTENTS_PANEL = new org.resmedicinae.resmedlib.term.String("contents_panel");

    /** The status bar id. */
    public static final org.resmedicinae.resmedlib.term.String STATUS_BAR = new org.resmedicinae.resmedlib.term.String("status_bar");

    /** The bounds id. */
    public static final org.resmedicinae.resmedlib.term.String BOUNDS = new org.resmedicinae.resmedlib.term.String("bounds");

    /** The resizable flag id. */
    public static final org.resmedicinae.resmedlib.term.String RESIZABLE = new org.resmedicinae.resmedlib.term.String("resizable");

    /** The frame id. */
    public static final org.resmedicinae.resmedlib.term.String FRAME = new org.resmedicinae.resmedlib.term.String("frame");

    /** The look and feel id. */
    public static final org.resmedicinae.resmedlib.term.String LOOK_AND_FEEL = new org.resmedicinae.resmedlib.term.String("look_and_feel");

    /** The close signal id. */
    public static final org.resmedicinae.resmedlib.term.String CLOSE_SIGNAL = new org.resmedicinae.resmedlib.term.String("close_signal");

    /** The view decoder id. */
    public static final org.resmedicinae.resmedlib.term.String VIEW_DECODER = new org.resmedicinae.resmedlib.term.String("view_decoder");

    //
    // Static view modes.
    //

    /** The applet graphical view mode. */
    public static final org.resmedicinae.resmedlib.number.Integer APPLET_GRAPHICAL_VIEW_MODE = new org.resmedicinae.resmedlib.number.Integer(0);

    /** The window graphical view mode. */
    public static final org.resmedicinae.resmedlib.number.Integer WINDOW_GRAPHICAL_VIEW_MODE = new org.resmedicinae.resmedlib.number.Integer(1);

    /** The modal dialog graphical view mode. */
    public static final org.resmedicinae.resmedlib.number.Integer MODAL_DIALOG_GRAPHICAL_VIEW_MODE = new org.resmedicinae.resmedlib.number.Integer(2);

    /** The modeless dialog graphical view mode. */
    public static final org.resmedicinae.resmedlib.number.Integer MODELESS_DIALOG_GRAPHICAL_VIEW_MODE = new org.resmedicinae.resmedlib.number.Integer(3);

    /** The frame graphical view mode. */
    public static final org.resmedicinae.resmedlib.number.Integer FRAME_GRAPHICAL_VIEW_MODE = new org.resmedicinae.resmedlib.number.Integer(4);

    /** The internal frame graphical view mode. */
    public static final org.resmedicinae.resmedlib.number.Integer INTERNAL_FRAME_GRAPHICAL_VIEW_MODE = new org.resmedicinae.resmedlib.number.Integer(5);

    /** The tab page graphical view mode. */
    public static final org.resmedicinae.resmedlib.number.Integer TAB_PAGE_GRAPHICAL_VIEW_MODE = new org.resmedicinae.resmedlib.number.Integer(6);

    //
    // Attributes.
    //

    /** The bounds of the graphical view. */
    private java.awt.Rectangle bounds;

    //
    // Child management.
    //

    /**
     * Adds the item to become a child of this item.
     *
     * @param n the name
     * @param i the item
     * @exception NullPointerException if the name is null
     */
    public void set(org.resmedicinae.resmedlib.term.String n, Item i) throws NullPointerException {

        super.set(n, i);

        if (n != null) {

            if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.TITLE)) {

                setTitle((org.resmedicinae.resmedlib.term.String) i);

            } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.ICON)) {

                setIcon((org.resmedicinae.resmedlib.term.String) i);

            } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.MENU_BAR)) {

                setMenuBar((org.resmedicinae.resmedlib.region.view.graphical.MenuBar) i);

            } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.TOOL_BAR)) {

                setToolBar((org.resmedicinae.resmedlib.region.view.graphical.ToolBar) i);

            } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.CONTENTS_PANEL)) {

                setContentsPanel((org.resmedicinae.resmedlib.region.view.graphical.ContentsPanel) i);

            } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.STATUS_BAR)) {

                setStatusBar((org.resmedicinae.resmedlib.region.view.graphical.StatusBar) i);

            } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.BOUNDS)) {

//??                setBounds((java.awt.Rectangle) i);
                java.lang.System.out.println("WARNING: Bounds not set. Replace java.awt.Rectangle");

            } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.RESIZABLE)) {
                
                setResizable((org.resmedicinae.resmedlib.digit.Boolean) i);
            }

        } else {

            throw new NullPointerException("Could not set item. The name is null.");
        }
    }

    /**
     * Removes the child item from this item.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void remove(org.resmedicinae.resmedlib.term.String n) throws NullPointerException {

        try {
                
            if (n != null) {
    
                if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.TITLE)) {
    
                    removeTitle((org.resmedicinae.resmedlib.term.String) get(n));
    
                } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.ICON)) {
    
                    removeIcon((org.resmedicinae.resmedlib.term.String) get(n));
    
                } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.MENU_BAR)) {
    
                    removeMenuBar((org.resmedicinae.resmedlib.region.view.graphical.MenuBar) get(n));
    
                } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.TOOL_BAR)) {
    
                    removeToolBar((org.resmedicinae.resmedlib.region.view.graphical.ToolBar) get(n));
    
                } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.CONTENTS_PANEL)) {
    
                    removeContentsPanel((org.resmedicinae.resmedlib.region.view.graphical.ContentsPanel) get(n));
    
                } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.STATUS_BAR)) {
    
                    removeStatusBar((org.resmedicinae.resmedlib.region.view.graphical.StatusBar) get(n));
    
                } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.BOUNDS)) {

//??                    removeBounds((java.awt.Rectangle) get(n));
                    java.lang.System.out.println("WARNING: Bounds not set. Replace java.awt.Rectangle");
    
                } else if (n.isEqualTo(org.resmedicinae.resmedlib.block.view.GraphicalView.RESIZABLE)) {
                    
                    removeResizable((org.resmedicinae.resmedlib.digit.Boolean) get(n));
                }

            } else {
    
                throw new NullPointerException("Could not set item. The name is null.");
            }

        } finally {
            
            super.remove(n);
        }
    }

    //
    // Graphical view mode.
    //

    /**
     * Creates a graphical view mode.
     *
     * The default is: System.INTERNAL_FRAME_GRAPHICAL_VIEW_MODE
     *
     * @return the graphical view mode
     * @exception NullPointerException if the graphical view mode is null
     */
    public org.resmedicinae.resmedlib.number.Integer createGraphicalViewMode() throws Exception, NullPointerException {

        return GraphicalView.FRAME_GRAPHICAL_VIEW_MODE;
    }

    /**
     * Destroys the graphical view mode.
     *
     * @param m the graphical view mode
     * @exception NullPointerException if the graphical view mode is null
     */
    public void destroyGraphicalViewMode(org.resmedicinae.resmedlib.number.Integer m) throws Exception, NullPointerException {

        if (m != null) {

            m.finalizz();

        } else {

            throw new NullPointerException("Could not destroy graphical view mode. The graphical view mode is null.");
        }
    }

    //
    // Title.
    //

    /**
     * Creates a title.
     *
     * @return the title
     */
    public org.resmedicinae.resmedlib.term.String createTitle() {

        return null;
    }

    /**
     * Destroys the title.
     *
     * @param title the title
     */
    public void destroyTitle(org.resmedicinae.resmedlib.term.String title) {
    }

    /**
     * Sets the title.
     *
     * @param t the title
     * @exception NullPointerException if the frame is null
     */
    public void setTitle(org.resmedicinae.resmedlib.term.String t) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.setTitle(t);

        } else {

            throw new NullPointerException("Could not set title. The frame is null.");
        }
    }

    /**
     * Removes the title.
     *
     * @param t the title
     * @exception NullPointerException if the frame is null
     */
    public void removeTitle(org.resmedicinae.resmedlib.term.String t) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.removeTitle(t);

        } else {

            throw new NullPointerException("Could not remove title. The frame is null.");
        }
    }

    //
    // Icon.
    //

    /**
     * Creates an icon.
     *
     * @return the icon
     */
    public org.resmedicinae.resmedlib.term.String createIcon() {

        return new org.resmedicinae.resmedlib.term.String("icon");
    }

    /**
     * Destroys the icon.
     *
     * @param icon the icon
     */
    public void destroyIcon(org.resmedicinae.resmedlib.term.String icon) {
    }

    /**
     * Sets the icon.
     *
     * @param i the icon
     * @exception NullPointerException if the frame is null
     */
    public void setIcon(org.resmedicinae.resmedlib.term.String i) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.setIcon(i);

        } else {

            throw new NullPointerException("Could not set icon. The frame is null.");
        }
    }

    /**
     * Removes the icon.
     *
     * @param i the icon
     * @exception NullPointerException if the frame is null
     */
    public void removeIcon(org.resmedicinae.resmedlib.term.String i) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.removeIcon(i);

        } else {

            throw new NullPointerException("Could not remove icon. The frame is null.");
        }
    }

    //
    // Menu bar.
    //

    /**
     * Creates a menu bar.
     *
     * @return the menu bar
     * @exception NullPointerException if the menu bar is null
     */
    public MenuBar createMenuBar() throws Exception, NullPointerException {

        MenuBar mb = new MenuBar();
        
        if (mb != null) {

            mb.globalize(get(GraphicalView.GLOBALS));
            mb.initialize();
            mb.link();
            
        } else {

            throw new NullPointerException("Could not create menu bar. The menu bar is null.");
        }

        return mb;
    }

    /**
     * Destroys the menu bar.
     *
     * @param mb the menu bar
     * @exception NullPointerException if the menu bar is null
     */
    public void destroyMenuBar(MenuBar mb) throws Exception, NullPointerException {

        if (mb != null) {

            mb.unlink();
            mb.finalizz();
            mb.deglobalize(get(GraphicalView.GLOBALS));
            
        } else {

            throw new NullPointerException("Could not destroy menu bar. The menu bar is null.");
        }
    }

    /**
     * Sets the menu bar.
     *
     * @param m the menu bar
     * @exception NullPointerException if the frame is null
     */
    public void setMenuBar(org.resmedicinae.resmedlib.region.view.graphical.MenuBar m) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.setMenuBar(m);

        } else {

            throw new NullPointerException("Could not set menu bar. The frame is null.");
        }
    }

    /**
     * Removes the menu bar.
     *
     * @param m the menu bar
     * @exception NullPointerException if the frame is null
     */
    public void removeMenuBar(org.resmedicinae.resmedlib.region.view.graphical.MenuBar m) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.removeMenuBar(m);

        } else {

            throw new NullPointerException("Could not remove menu bar. The frame is null.");
        }
    }

    //
    // Tool bar.
    //

    /**
     * Creates a tool bar.
     *
     * @return the tool bar
     * @exception NullPointerException if the tool bar is null
     */
    public ToolBar createToolBar() throws Exception, NullPointerException {

        ToolBar tb = new ToolBar();

        if (tb != null) {

            tb.globalize(get(GraphicalView.GLOBALS));
            tb.initialize();
            tb.link();

        } else {

            throw new NullPointerException("Could not create tool bar. The tool bar is null.");
        }

        return tb;
    }

    /**
     * Destroys the tool bar.
     *
     * @param tb the tool bar
     * @exception NullPointerException if the tool bar is null
     */
    public void destroyToolBar(ToolBar tb) throws Exception, NullPointerException {

        if (tb != null) {

            tb.unlink();
            tb.finalizz();
            tb.deglobalize(get(GraphicalView.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy tool bar. The tool bar is null.");
        }
    }

    /**
     * Sets the tool bar.
     *
     * @param t the tool bar
     * @exception NullPointerException if the frame is null
     */
    public void setToolBar(org.resmedicinae.resmedlib.region.view.graphical.ToolBar t) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.setToolBar(t);

        } else {

            throw new NullPointerException("Could not set tool bar. The frame is null.");
        }
    }

    /**
     * Removes the tool bar.
     *
     * @param t the tool bar
     * @exception NullPointerException if the frame is null
     */
    public void removeToolBar(org.resmedicinae.resmedlib.region.view.graphical.ToolBar t) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.removeToolBar(t);

        } else {

            throw new NullPointerException("Could not remove tool bar. The frame is null.");
        }
    }

    //
    // Contents panel.
    //

    /**
     * Creates a contents panel.
     *
     * @return the contents panel
     * @exception NullPointerException if the contents panel is null
     */
    public ContentsPanel createContentsPanel() throws Exception, NullPointerException {

        ContentsPanel cp = new ContentsPanel();

        if (cp != null) {

            cp.globalize(get(GraphicalView.GLOBALS));
            cp.initialize();
            cp.link();

        } else {

            throw new NullPointerException("Could not create contents panel. The contents panel is null.");
        }

        return cp;
    }

    /**
     * Destroys the contents panel.
     *
     * @param cp the contents panel
     * @exception NullPointerException if the contents panel is null
     */
    public void destroyContentsPanel(ContentsPanel cp) throws Exception, NullPointerException {

        if (cp != null) {

            cp.unlink();
            cp.finalizz();
            cp.deglobalize(get(GraphicalView.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy contents panel. The contents panel is null.");
        }
    }

    /**
     * Sets the contents panel.
     *
     * @param c the contents panel
     * @exception NullPointerException if the frame is null
     */
    public void setContentsPanel(org.resmedicinae.resmedlib.region.view.graphical.ContentsPanel c) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.setContentsPanel(c);

        } else {

            throw new NullPointerException("Could not set contents panel. The frame is null.");
        }
    }

    /**
     * Removes the contents panel.
     *
     * @param c the contents panel
     * @exception NullPointerException if the frame is null
     */
    public void removeContentsPanel(org.resmedicinae.resmedlib.region.view.graphical.ContentsPanel c) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.removeContentsPanel(c);

        } else {

            throw new NullPointerException("Could not remove contents panel. The frame is null.");
        }
    }

    //
    // Status bar.
    //

    /**
     * Creates a status bar.
     *
     * @return the status bar
     * @exception NullPointerException if the status bar is null
     */
    public StatusBar createStatusBar() throws Exception, NullPointerException {

        StatusBar sb = new StatusBar();

        if (sb != null) {

            sb.globalize(get(GraphicalView.GLOBALS));
            sb.initialize();
            sb.link();

        } else {

            throw new NullPointerException("Could not create status bar. The status bar is null.");
        }

        return sb;
    }

    /**
     * Destroys the status bar.
     *
     * @param sb the status bar
     * @exception NullPointerException if the status bar is null
     */
    public void destroyStatusBar(StatusBar sb) throws Exception, NullPointerException {

        if (sb != null) {

            sb.unlink();
            sb.finalizz();
            sb.deglobalize(get(GraphicalView.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy status bar. The status bar is null.");
        }
    }

    /**
     * Sets the status bar.
     *
     * @param s the status bar
     * @exception NullPointerException if the frame is null
     */
    public void setStatusBar(org.resmedicinae.resmedlib.region.view.graphical.StatusBar s) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.setStatusBar(s);

        } else {

            throw new NullPointerException("Could not set status bar. The frame is null.");
        }
    }

    /**
     * Removes the status bar.
     *
     * @param s the status bar
     * @exception NullPointerException if the frame is null
     */
    public void removeStatusBar(org.resmedicinae.resmedlib.region.view.graphical.StatusBar s) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.removeStatusBar(s);

        } else {

            throw new NullPointerException("Could not remove status bar. The frame is null.");
        }
    }

    //
    // Bounds.
    //

    /**
     * Creates a rectangle storing the bounds.
     *
     * @return the rectangle storing the bounds
     */
    public java.awt.Rectangle createBounds() {

        // Determine width.
        int w = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getWidth());

        // Use centered x position by default.
        int x = 0;

        // Determine height.
        int h = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getHeight());

        // Use centered y position by default.
        int y = 0;

        return new java.awt.Rectangle(x, y, w, h);
    }

    /**
     * Destroys the rectangle storing the bounds.
     *
     * @param r the rectangle storing the bounds
     */
    public void destroyBounds(java.awt.Rectangle r) {
    }

    /**
     * Sets the bounds.
     *
     * @param b the bounds
     * @exception NullPointerException if the frame is null
     */
    public void setBounds(java.awt.Rectangle b) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.setBounds(b);

        } else {

            throw new NullPointerException("Could not set bounds. The frame is null.");
        }
    }

    /**
     * Removes the bounds.
     *
     * @param b the bounds
     * @exception NullPointerException if the frame is null
     */
    public void removeBounds(java.awt.Rectangle b) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.removeBounds(b);

        } else {

            throw new NullPointerException("Could not remove bounds. The frame is null.");
        }
    }

    /**
     * Configures the bounds.
     *
     * @param def the default bounds
     * @return the bounds
     * @exception NullPointerException if the configuration is null
     * @exception NullPointerException if the default bounds is null
     */
    public java.awt.Rectangle configureBounds(java.awt.Rectangle def) throws NullPointerException {

        java.awt.Rectangle r = def;
        Configuration c = (Configuration) get(GraphicalView.CONFIGURATION);

        if (c != null) {

            if (def != null) {
    
/*??
                int x = c.getWindowX((int) Math.floor(def.getX()));
                int y = c.getWindowY((int) Math.floor(def.getY()));
                int w = c.getWindowWidth((int) Math.floor(def.getWidth()));
                int h = c.getWindowHeight((int) Math.floor(def.getHeight()));

                if ((x != def.getX()) || (y != def.getY()) || (w != def.getWidth()) || (h != def.getHeight())) {
                
                    r = new java.awt.Rectangle(x, y, w, h);
                }
*/

            } else {
    
                throw new NullPointerException("Could not configure bounds. The default bounds is null.");
            }

        } else {

            throw new NullPointerException("Could not configure bounds. The configuration is null.");
        }
    
        return r;
    }

    /**
     * Deconfigures the bounds.
     *
     * @param r the bounds
     * @exception NullPointerException if the configuration is null
     * @exception NullPointerException if the bounds is null
     */
    public void deconfigureBounds(java.awt.Rectangle r) throws NullPointerException {

        Configuration c = (Configuration) get(GraphicalView.CONFIGURATION);

        if (c != null) {

            if (r != null) {
    
/*??
                c.setWindowX((int) Math.floor(r.getX()));
                c.setWindowY((int) Math.floor(r.getY()));
                c.setWindowWidth((int) Math.floor(r.getWidth()));
                c.setWindowHeight((int) Math.floor(r.getHeight()));
*/

            } else {
    
                throw new NullPointerException("Could not deconfigure window bounds. The window bounds is null.");
            }

        } else {

            throw new NullPointerException("Could not deconfigure window bounds. The configuration is null.");
        }
    }

    //
    // Resizable.
    //

    /**
     * Creates a resizable flag.
     *
     * @return the resizable flag
     */
    public org.resmedicinae.resmedlib.digit.Boolean createResizable() throws Exception {

        return new org.resmedicinae.resmedlib.digit.Boolean(org.resmedicinae.resmedlib.digit.Boolean.TRUE);
    }

    /**
     * Destroys the resizable flag.
     *
     * @param r the resizable flag
     * @exception NullPointerException if the resizable flag is null
     */
    public void destroyResizable(org.resmedicinae.resmedlib.digit.Boolean r) throws Exception {
    }

    /**
     * Sets the resizable flag.
     *
     * @param r the resizable flag
     * @exception NullPointerException if the frame is null
     */
    public void setResizable(org.resmedicinae.resmedlib.digit.Boolean r) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.setResizable(r);

        } else {

            throw new NullPointerException("Could not set resizable flag. The frame is null.");
        }
    }

    /**
     * Removes the resizable flag.
     *
     * @param r the resizable flag
     * @exception NullPointerException if the frame is null
     */
    public void removeResizable(org.resmedicinae.resmedlib.digit.Boolean r) throws NullPointerException {

        Frame f = (Frame) get(GraphicalView.FRAME);

        if (f != null) {

            f.removeResizable(r);

        } else {

            throw new NullPointerException("Could not remove resizable flag. The frame is null.");
        }
    }

    //
    // Frame.
    //

    /**
     * Creates a frame.
     *
     * @return the frame
     * @exception NullPointerException if the frame is null
     */
    public Frame createFrame() throws Exception, NullPointerException {

        Frame f = null;
        org.resmedicinae.resmedlib.number.Integer i = (org.resmedicinae.resmedlib.number.Integer) get(GraphicalView.GRAPHICAL_VIEW_MODE);

        if (i != null) {

            if (i.isEqualTo(GraphicalView.APPLET_GRAPHICAL_VIEW_MODE)) {
    
                f = new Applet();
    
            } else if (i.isEqualTo(GraphicalView.WINDOW_GRAPHICAL_VIEW_MODE)) {
    
                f = new Window();
    
            } else if (i.isEqualTo(GraphicalView.MODAL_DIALOG_GRAPHICAL_VIEW_MODE)) {
    
                f = new Dialog();
    
            } else if (i.isEqualTo(GraphicalView.MODELESS_DIALOG_GRAPHICAL_VIEW_MODE)) {
    
                f = new Dialog();
    
            } else if (i.isEqualTo(GraphicalView.FRAME_GRAPHICAL_VIEW_MODE)) {
    
                f = new StandardFrame();
    
            } else if (i.isEqualTo(GraphicalView.INTERNAL_FRAME_GRAPHICAL_VIEW_MODE)) {
    
                f = new InternalFrame();
    
            } else if (i.isEqualTo(GraphicalView.TAB_PAGE_GRAPHICAL_VIEW_MODE)) {
    
                f = new TabPage();
            }

        } else {

            throw new NullPointerException("Could not create frame. The graphical view mode is null.");
        }

        if (f != null) {

            f.globalize((Item) get(GraphicalView.GLOBALS));
            f.initialize();
            f.link();

        } else {

            throw new NullPointerException("Could not create frame. The frame is null.");
        }
        
        return f;
    }

    /**
     * Destroys the frame.
     *
     * @param f the frame
     * @exception NullPointerException if the frame is null
     */
    public void destroyFrame(Frame f) throws Exception, NullPointerException {

        if (f != null) {
            
            f.unlink();
            f.finalizz();
            f.deglobalize(get(GraphicalView.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy frame. The frame is null.");
        }
    }

    //
    // Look and feel.
    //

    /**
     * Creates a look and feel.
     *
     * @return the look and feel
     */
    public javax.swing.LookAndFeel createLookAndFeel() {

        return new javax.swing.plaf.metal.MetalLookAndFeel();
    }

    /**
     * Destroys the look and feel.
     */
    public void destroyLookAndFeel(javax.swing.LookAndFeel lookAndFeel) {
    }

    /**
     * Configures the look and feel.
     *
     * @param def the default look and feel
     * @exception NullPointerException if the configuration is null
     * @exception NullPointerException if the default look and feel is null
     * @exception NullPointerException if the look and feel id string is null
     * @exception Exception if the look and feel is invalid
     */
/*??
    public javax.swing.LookAndFeel configureLookAndFeel(javax.swing.LookAndFeel def) throws Exception, NullPointerException {

        javax.swing.LookAndFeel laf = def;
        Configuration c = (Configuration) get(GraphicalView.CONFIGURATION);
        
        if (c != null) {
            
            if (def != null) {
                
                org.resmedicinae.resmedlib.term.String s = c.getLookAndFeel(def.getID());
    
                if (s != null) {

                    if (s.equals(def.getID()) == false) {
                            
                        if (s.equals("Metal")) {
        
                            laf = new javax.swing.plaf.metal.MetalLookAndFeel();
        
                        } else if (s.equals("Motif")) {
        
                            laf = new com.sun.java.swing.plaf.motif.MotifLookAndFeel();
        
/*??
                        } else if (s.equals("Mac")) {
        
                            laf = new com.sun.java.swing.plaf.mac.MacLookAndFeel();
*/
/*??
        
                        } else if (s.equals("Windows")) {
        
                            laf = new com.sun.java.swing.plaf.windows.WindowsLookAndFeel();
        
                        } else {
        
                            throw new Exception("Could not configure look and feel. The look and feel is invalid.");
                        }
                    }
        
                } else {
    
                    throw new NullPointerException("Could not configure look and feel. The look and feel id string is null.");
                }
    
            } else {

                throw new NullPointerException("Could not configure look and feel. The default look and feel is null.");
            }

        } else {

            throw new NullPointerException("Could not configure look and feel. The configuration is null.");
        }
        
        return laf;
    }
    
    /**
     * Deconfigures the look and feel.
     *
     * @exception NullPointerException if the configuration is null
     * @exception NullPointerException if the look and feel is null
     */
/*??
    public void deconfigureLookAndFeel(javax.swing.LookAndFeel laf) throws NullPointerException {

        Configuration c = (Configuration) get(GraphicalView.CONFIGURATION);
        
        if (c != null) {

            if (laf != null) {
                
                c.setLookAndFeel(laf.getID());

            } else {
    
                throw new NullPointerException("Could not deconfigure look and feel. The look and feel is null.");
            }

        } else {

            throw new NullPointerException("Could not deconfigure look and feel. The configuration is null.");
        }
    }

    //
    // Close signal.
    //

    /**
     * Creates a signal sent when the window containing this view is closed.
     *
     * @return the signal sent when the window containing this view is closed
     * @exception NullPointerException if the signal is null
     */
    public Signal createCloseSignal() throws NullPointerException {

        Signal s = new Signal();

        if (s != null) {

//??            s.setId(Controller.DESTROY_CONTROLLER_CONTROL_ID);
//??            s.setSender((Controller) getController());

        } else {
            
            throw new NullPointerException("Could not create close signal. The signal is null.");
        }
        
        return s;
    }

    /**
     * Destroys the signal sent when the window containing this view is closed.
     *
     * @param s the signal sent when the window containing this view is closed
     * @exception NullPointerException if the signal is null
     */
    public void destroyCloseSignal(Signal s) throws NullPointerException {

        if (s != null) {

//??            s.setId(Controller.DESTROY_CONTROLLER_CONTROL_ID);
//??            s.setSender((Controller) getController());

        } else {
            
            throw new NullPointerException("Could not destroy close signal. The signal is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this swing view.
     *
     * @exception NullPointerException if the configuration is null
     */
    public void initialize() throws Exception, NullPointerException {

        super.initialize();

        Configuration c = (Configuration) get(GraphicalView.CONFIGURATION);

        if (c != null) {

            javax.swing.UIManager.setLookAndFeel(createLookAndFeel());
            set(GraphicalView.GRAPHICAL_VIEW_MODE, c.get(GraphicalView.GRAPHICAL_VIEW_MODE, createGraphicalViewMode()));
/*??
            set(GraphicalView.WINDOW_BOUNDS, configureWindowBounds(createWindowBounds()));
            set(GraphicalView.DIALOG_BOUNDS, configureDialogBounds(createDialogBounds()));
            set(GraphicalView.FRAME_BOUNDS, configureFrameBounds(createFrameBounds()));
            set(GraphicalView.INTERNAL_FRAME_BOUNDS, configureInternalFrameBounds(createInternalFrameBounds()));
*/
            set(GraphicalView.FRAME, createFrame());
            set(GraphicalView.TITLE, c.get(GraphicalView.TITLE, createTitle()));
            set(GraphicalView.ICON, createIcon());
            set(GraphicalView.MENU_BAR, createMenuBar());
            set(GraphicalView.TOOL_BAR, createToolBar());
            set(GraphicalView.CONTENTS_PANEL, createContentsPanel());
            set(GraphicalView.STATUS_BAR, createStatusBar());
            set(GraphicalView.RESIZABLE, c.get(GraphicalView.RESIZABLE, createResizable()));
            set(GraphicalView.CLOSE_SIGNAL, createCloseSignal());

        } else {

            throw new NullPointerException("Could not initialize graphical view. The configuration is null.");
        }
    }

    /**
     * Finalizes this swing view.
     *
     * @exception NullPointerException if the configuration is null
     */
    public void finalizz() throws Exception, NullPointerException {

        try {
            
            Configuration c = (Configuration) get(GraphicalView.CONFIGURATION);

            if (c != null) {

                destroyCloseSignal((Signal) get(GraphicalView.CLOSE_SIGNAL));
                remove(GraphicalView.CLOSE_SIGNAL);

                c.set(GraphicalView.RESIZABLE, (org.resmedicinae.resmedlib.digit.Boolean) get(GraphicalView.RESIZABLE));
                destroyResizable((org.resmedicinae.resmedlib.digit.Boolean) get(GraphicalView.RESIZABLE));
                remove(GraphicalView.RESIZABLE);

                destroyStatusBar((StatusBar) get(GraphicalView.STATUS_BAR));
                remove(GraphicalView.STATUS_BAR);

                destroyContentsPanel((ContentsPanel) get(GraphicalView.CONTENTS_PANEL));
                remove(GraphicalView.CONTENTS_PANEL);
    
                destroyToolBar((ToolBar) get(GraphicalView.TOOL_BAR));
                remove(GraphicalView.TOOL_BAR);

                destroyMenuBar((MenuBar) get(GraphicalView.MENU_BAR));
                remove(GraphicalView.MENU_BAR);
    
                destroyIcon((org.resmedicinae.resmedlib.term.String) get(GraphicalView.ICON));
                remove(GraphicalView.ICON);

                c.set(GraphicalView.TITLE, (org.resmedicinae.resmedlib.term.String) get(GraphicalView.TITLE));
                destroyTitle((org.resmedicinae.resmedlib.term.String) get(GraphicalView.TITLE));
                remove(GraphicalView.TITLE);

                destroyFrame((org.resmedicinae.resmedlib.region.view.graphical.Frame) get(GraphicalView.FRAME));
                remove(GraphicalView.FRAME);

/*??
                deconfigureInternalFrameBounds((java.awt.Rectangle) get(GraphicalView.INTERNAL_FRAME_BOUNDS));
                destroyInternalFrameBounds((java.awt.Rectangle) get(GraphicalView.INTERNAL_FRAME_BOUNDS));
                remove(GraphicalView.INTERNAL_FRAME_BOUNDS);
    
                deconfigureFrameBounds((java.awt.Rectangle) get(GraphicalView.FRAME_BOUNDS));
                destroyFrameBounds((java.awt.Rectangle) get(GraphicalView.FRAME_BOUNDS));
                remove(GraphicalView.FRAME_BOUNDS);
    
                deconfigureDialogBounds((java.awt.Rectangle) get(GraphicalView.DIALOG_BOUNDS));
                destroyDialogBounds((java.awt.Rectangle) get(GraphicalView.DIALOG_BOUNDS));
                remove(GraphicalView.DIALOG_BOUNDS);
    
                deconfigureWindowBounds((java.awt.Rectangle) get(GraphicalView.WINDOW_BOUNDS));
                destroyWindowBounds((java.awt.Rectangle) get(GraphicalView.WINDOW_BOUNDS));
                remove(GraphicalView.WINDOW_BOUNDS);
*/

                c.set(GraphicalView.GRAPHICAL_VIEW_MODE, (org.resmedicinae.resmedlib.number.Integer) get(GraphicalView.GRAPHICAL_VIEW_MODE));
                destroyGraphicalViewMode((org.resmedicinae.resmedlib.number.Integer) get(GraphicalView.GRAPHICAL_VIEW_MODE));
                remove(GraphicalView.GRAPHICAL_VIEW_MODE);

                destroyLookAndFeel(javax.swing.UIManager.getLookAndFeel());

            } else {

                throw new NullPointerException("Could not finalize graphical view. The configuration is null.");
            }

        } finally {
            
            super.finalizz();
        }
    }

    //
    // Linkable.
    //

    /**
     * Links this swing view.
     *
     * @exception NullPointerException if the frame is null
     */
    public void link() throws Exception, NullPointerException {

        super.link();

        Frame f = (Frame) get(GraphicalView.FRAME);
        
        if (f != null) {

            f.set(GraphicalView.TITLE, get(GraphicalView.TITLE));
            f.set(GraphicalView.ICON, get(GraphicalView.ICON));
            f.set(GraphicalView.MENU_BAR, get(GraphicalView.MENU_BAR));
            f.set(GraphicalView.TOOL_BAR, get(GraphicalView.TOOL_BAR));
            f.set(GraphicalView.CONTENTS_PANEL, get(GraphicalView.CONTENTS_PANEL));
            f.set(GraphicalView.STATUS_BAR, get(GraphicalView.STATUS_BAR));
            f.set(GraphicalView.BOUNDS, get(GraphicalView.BOUNDS));
            f.set(GraphicalView.RESIZABLE, get(GraphicalView.RESIZABLE));

        } else {

            throw new NullPointerException("Could not link graphical view. The frame is null.");
        }
    }

    /**
     * Unlinks this swing view.
     *
     * @exception NullPointerException if the frame is null
     */
    public void unlink() throws Exception, NullPointerException {

        try {
            
            Frame f = (Frame) get(GraphicalView.FRAME);
            
            if (f != null) {

                f.remove(GraphicalView.RESIZABLE);
                f.remove(GraphicalView.BOUNDS);
                f.remove(GraphicalView.STATUS_BAR);
                f.remove(GraphicalView.CONTENTS_PANEL);
                f.remove(GraphicalView.TOOL_BAR);
                f.remove(GraphicalView.MENU_BAR);
                f.remove(GraphicalView.ICON);
                f.remove(GraphicalView.TITLE);

            } else {
    
                throw new NullPointerException("Could not link graphical view. The frame is null.");
            }

        } finally {

            super.unlink();
        }
    }
}

