/*
 * $RCSfile: View.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.block;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.chain.*;
import org.resmedicinae.resmedlib.region.model.*;

/**
 * This class represents a view.
 *
 * A view corresponds to both an eye and a muscle in an animal's or human's body.
 * It is a special block that is able to receive input events (eye) but is also
 * able to display output (muscle action).
 *
 * The ontological parent class which is responsible for creating this view block,
 * will also have to assign a reference to a controller (brain) whose task is to
 * control inputs and organise the display of outputs in the view. 
 *
 * @version $Revision: 1.8 $ $Date: 2002/12/12 15:31:06 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class View extends Block {

    //
    // Static attribute ids.
    //

    /** The controller id. */
    public static final org.resmedicinae.resmedlib.term.String CONTROLLER = new org.resmedicinae.resmedlib.term.String("controller");
}

