/*
 * $RCSfile: Controller.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.block;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.chain.*;
import org.resmedicinae.resmedlib.region.*;
import org.resmedicinae.resmedlib.region.controller.*;
import org.resmedicinae.resmedlib.region.controller.decoder.*;
import org.resmedicinae.resmedlib.region.controller.encoder.*;
import org.resmedicinae.resmedlib.region.model.*;
import org.resmedicinae.resmedlib.term.String;
//?? Temporary!
import org.resmedicinae.resmedlib.block.view.GraphicalView;

/**
 * This class represents a controller.<br><br>
 *
 * A controller corresponds to the brain in an animal's or human's body.
 * Its main task is to receive input signals, process information and finally
 * send output signals.<br><br>
 *
 * Following this order of actions, the controller consists of three types of regions:
 *  <ul>
 *      <li><code>Sensor</code></li>
 *      <li><code>Processor</code></li>
 *      <li><code>Motor</code></li>
 *  </ul>
 *
 * @version $Revision: 1.16 $ $Date: 2002/12/19 14:25:04 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Controller extends Block {

    //
    // Static attribute ids.
    //

    /** The model id. */
    public static final org.resmedicinae.resmedlib.term.String MODEL = new org.resmedicinae.resmedlib.term.String("model");

    /** The view decoder id. */
    public static final org.resmedicinae.resmedlib.term.String VIEW_DECODER = new org.resmedicinae.resmedlib.term.String("view_decoder");

    /** The processor id. */
    public static final org.resmedicinae.resmedlib.term.String PROCESSOR = new org.resmedicinae.resmedlib.term.String("processor");

    /** The view encoder id. */
    public static final org.resmedicinae.resmedlib.term.String VIEW_ENCODER = new org.resmedicinae.resmedlib.term.String("view_encoder");

    //
    // Static signal ids.
    //
    
    /** The create system signal id. */
    public static final org.resmedicinae.resmedlib.term.String CREATE_SYSTEM_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("create_system");

    /** The destroy system signal id. */
    public static final org.resmedicinae.resmedlib.term.String DESTROY_SYSTEM_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("destroy_system");

    /** The cut signal id. */
    public static final org.resmedicinae.resmedlib.term.String CUT_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("cut");

    /** The copy signal id. */
    public static final org.resmedicinae.resmedlib.term.String COPY_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("copy");

    /** The paste signal id. */
    public static final org.resmedicinae.resmedlib.term.String PASTE_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("paste");

    /** The show tool bar signal id. */
    public static final org.resmedicinae.resmedlib.term.String SHOW_TOOL_BAR_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("show_tool_bar");

    /** The show status bar signal id. */
    public static final org.resmedicinae.resmedlib.term.String SHOW_STATUS_BAR_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("show_status_bar");

    /** The configure menu bar signal id. */
    public static final org.resmedicinae.resmedlib.term.String CONFIGURE_MENU_BAR_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("configure_menu_bar");

    /** The configure tool bar signal id. */
    public static final org.resmedicinae.resmedlib.term.String CONFIGURE_TOOL_BAR_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("configure_tool_bar");

    /** The configure status bar signal id. */
    public static final org.resmedicinae.resmedlib.term.String CONFIGURE_STATUS_BAR_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("configure_status_bar");

    /** The configure key bindings signal id. */
    public static final org.resmedicinae.resmedlib.term.String CONFIGURE_KEY_BINDINGS_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("configure_key_bindings");

    /** The show help contents signal id. */
    public static final org.resmedicinae.resmedlib.term.String SHOW_HELP_CONTENTS_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("show_help_contents");

    /** The report bug signal id. */
    public static final org.resmedicinae.resmedlib.term.String REPORT_BUG_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("report_bug");

    /** The link to website signal id. */
    public static final org.resmedicinae.resmedlib.term.String LINK_TO_WEBSITE_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("link_to_website");

    //
    // Static portal system signal ids.
    //

    /** The show systems tree signal id. */
    public static final org.resmedicinae.resmedlib.term.String SHOW_SYSTEMS_TREE_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("show_systems_tree");

    /** The configure systems tree signal id. */
    public static final org.resmedicinae.resmedlib.term.String CONFIGURE_SYSTEMS_TREE_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("configure_systems_tree");

    /** The configure res medicinae signal id. */
    public static final org.resmedicinae.resmedlib.term.String CONFIGURE_RES_MEDICINAE_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("configure_res_medicinae");

    /** The iconify all signal id. */
    public static final org.resmedicinae.resmedlib.term.String ICONIFY_ALL_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("iconify_all");

    /** The close signal id. */
    public static final org.resmedicinae.resmedlib.term.String CLOSE_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("close");

    /** The close all signal id. */
    public static final org.resmedicinae.resmedlib.term.String CLOSE_ALL_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("close_all");

    /** The cascade signal id. */
    public static final org.resmedicinae.resmedlib.term.String CASCADE_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("cascade");

    /** The tile vertically signal id. */
    public static final org.resmedicinae.resmedlib.term.String TILE_VERTICALLY_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("tile_vertically");

    /** The tile horizontally signal id. */
    public static final org.resmedicinae.resmedlib.term.String TILE_HORIZONTALLY_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("tile_horizontally");

    /** The set frame display signal id. */
    public static final org.resmedicinae.resmedlib.term.String SET_FRAME_DISPLAY_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("set_frame_display");

    /** The set internal frame display signal id. */
    public static final org.resmedicinae.resmedlib.term.String SET_INTERNAL_FRAME_DISPLAY_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("set_internal_frame_display");

    /** The set tab page display signal id. */
    public static final org.resmedicinae.resmedlib.term.String SET_TAB_PAGE_DISPLAY_SIGNAL_ID = new org.resmedicinae.resmedlib.term.String("set_tab_page_display");

    //
    // Model.
    //

    /**
     * Creates a model.
     *
     * @return the model
     * @exception NullPointerException if the model is null
     */
    public Model createModel() {

        return null;
    }

    /**
     * Destroys the model.
     *
     * @param model the model
     */
    public void destroyModel(Model model) {
    }

    //
    // View decoder.
    //

    /**
     * Creates a view decoder.
     *
     * @return the view decoder
     * @exception NullPointerException if the view decoder is null
     */
    public ViewDecoder createViewDecoder() throws Exception, NullPointerException {

        ViewDecoder u = new ViewDecoder();
        
        if (u != null) {

            u.globalize(get(Controller.GLOBALS));
            u.initialize();
            u.link();     

        } else {

            throw new NullPointerException("Could not create view decoder. The view decoder is null.");            
        }

        return u;
    }

    /**
     * Destroys the view decoder.
     *
     * @param u the view decoder
     * @exception NullPointerException if the view decoder is null
     */
    public void destroyViewDecoder(ViewDecoder u) throws Exception, NullPointerException {

        if (u != null) {

            u.unlink();     
            u.finalizz();
            u.deglobalize(get(Controller.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy view decoder. The view decoder is null.");            
        }
    }

    //
    // Processor.
    //

    /**
     * Creates a processor.
     *
     * @return the processor
     * @exception NullPointerException if the processor is null
     */
    public Processor createProcessor() {

        return null;
    }

    /**
     * Destroys the processor.
     *
     * @param p the processor
     */
    public void destroyProcessor(Processor p) {
    }

    //
    // View encoder.
    //

    /**
     * Creates a view encoder.
     *
     * @return the view encoder
     * @exception NullPointerException if the view encoder is null
     */
    public ViewEncoder createViewEncoder() throws Exception, NullPointerException {

        ViewEncoder e = new ViewEncoder();
        
        if (e != null) {

            e.globalize(get(Controller.GLOBALS));
            e.initialize();
            e.link();     

        } else {

            throw new NullPointerException("Could not create view encoder. The view encoder is null.");            
        }
        
        return e;
    }

    /**
     * Destroys the view encoder.
     *
     * @param e the view encoder
     * @exception NullPointerException if the view encoder is null
     */
    public void destroyViewEncoder(ViewEncoder e) throws Exception, NullPointerException {

        if (e != null) {

            e.unlink();     
            e.finalizz();
            e.deglobalize(get(Controller.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy view encoder. The view encoder is null.");            
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this controller.
     *
     * @exception NullPointerException if the configuration is null
     */
    public void initialize() throws Exception, NullPointerException {

        super.initialize();

        Configuration c = (Configuration) get(Controller.CONFIGURATION);

        if (c != null) {

            set(Controller.MODEL, createModel());

            org.resmedicinae.resmedlib.digit.Boolean viewDecoder = c.get(Controller.VIEW_DECODER, new org.resmedicinae.resmedlib.digit.Boolean(true));

            if ((viewDecoder != null) && (viewDecoder.isUnequalTo(org.resmedicinae.resmedlib.digit.Boolean.FALSE))) {

                set(Controller.VIEW_DECODER, createViewDecoder());
            }

            org.resmedicinae.resmedlib.digit.Boolean processor = c.get(Controller.PROCESSOR, new org.resmedicinae.resmedlib.digit.Boolean(true));

            if ((processor != null) && (processor.isUnequalTo(org.resmedicinae.resmedlib.digit.Boolean.FALSE))) {

                set(Controller.PROCESSOR, createProcessor());
            }

            org.resmedicinae.resmedlib.digit.Boolean viewEncoder = c.get(Controller.VIEW_ENCODER, new org.resmedicinae.resmedlib.digit.Boolean(true));

            if ((viewEncoder != null) && (viewEncoder.isUnequalTo(org.resmedicinae.resmedlib.digit.Boolean.FALSE))) {

                set(Controller.VIEW_ENCODER, createViewEncoder());
            }

        } else {

            throw new NullPointerException("Could not initialize controller. The configuration is null.");
        }
    }

    /**
     * Finalizes this controller.
     *
     * @exception NullPointerException if the configuration is null
     */
    public void finalizz() throws Exception, NullPointerException {

        try {

            Configuration c = (Configuration) get(Controller.CONFIGURATION);

            if (c != null) {

                if (get(Controller.VIEW_ENCODER) != null) {

                    c.set(Controller.VIEW_ENCODER, new org.resmedicinae.resmedlib.digit.Boolean(true));
                    destroyViewEncoder((ViewEncoder) get(Controller.VIEW_ENCODER));
                    remove(Controller.VIEW_ENCODER);

                } else {

                    c.set(Controller.VIEW_ENCODER, new org.resmedicinae.resmedlib.digit.Boolean(false));
                }

                if (get(Controller.PROCESSOR) != null) {

                    c.set(Controller.PROCESSOR, new org.resmedicinae.resmedlib.digit.Boolean(true));
                    destroyProcessor((Processor) get(Controller.PROCESSOR));
                    remove(Controller.PROCESSOR);

                } else {

                    c.set(Controller.PROCESSOR, new org.resmedicinae.resmedlib.digit.Boolean(false));
                }

                if (get(Controller.VIEW_DECODER) != null) {

                    c.set(Controller.VIEW_DECODER, new org.resmedicinae.resmedlib.digit.Boolean(true));
                    destroyViewDecoder((ViewDecoder) get(Controller.VIEW_DECODER));
                    remove(Controller.VIEW_DECODER);

                } else {

                    c.set(Controller.VIEW_DECODER, new org.resmedicinae.resmedlib.digit.Boolean(false));
                }

                destroyModel((Model) get(Controller.MODEL));
                remove(Controller.MODEL);

            } else {

                throw new NullPointerException("Could not finalize controller. The configuration is null.");
            }

        } finally {
            
            super.finalizz();
        }
    }

    //
    // Controlling.
    //

    /**
     * Controls the question operation and data.
     *
     * This is done in three steps:
     * <ol>
     *     <li>Decode question data to receive domain data</li>
     *     <li>Process operation on domain data</li>
     *     <li>Encode domain data to receive answer data</li>
     * </ol>
     *
     * @param o the question operation
     * @param d the question data
     * @return the answer data
     * @exception NullPointerException if the view decoder is null
     * @exception NullPointerException if the processor is null
     * @exception NullPointerException if the view encoder is null
     */
    public Model control(String o, GraphicalView d) throws Exception, NullPointerException {

        Model a = null;
        DomainModel m = null;
        ViewDecoder vuc = (ViewDecoder) get(Controller.VIEW_DECODER);

        if (vuc != null) {

            m = vuc.decode(d);

        } else {

            throw new NullPointerException("Could not process model. The view decoder is null.");
        }

        Processor p = (Processor) get(Controller.PROCESSOR);

        if (p != null) {

            m = p.process(o, m);

        } else {

            throw new NullPointerException("Could not process model. The processor is null.");
        }

        ViewEncoder vec = (ViewEncoder) get(Controller.VIEW_ENCODER);

        if (vec != null) {

            a = vec.encode(m);

        } else {

            throw new NullPointerException("Could not process model. The view encoder is null.");
        }

/*??
            if (s.matches(Controller.CREATE_ABOUT_DIALOG_SIGNAL_ID) == true) {

                set(createAboutDialog());

            } else if (s.matches(Controller.DESTROY_ABOUT_DIALOG_SIGNAL_ID) == true) {

                remove((AboutDialog) s.getSender());
                destroyAboutDialog((AboutDialog) s.getSender());
            }

/*??
            // Handle unhandled controls.
            if (((Control) c).getMatched() == false) {

                ...forward to other controller regions...
            }
*/

/*??
            if (((Control) c).matches(Controller.CREATE_APPLICATION_SIGNAL_ID)) {

                ApplicationTreeNode n = (ApplicationTreeNode) ((Control) c).getSender();
                
                if (n != null) {
                
                    add(createApplication(n.getLocation(), n.getArguments(), n.getWorkPath()));

                } else {

                    throw new NullPointerException("Could not create application. The application tree node is null.");
                }

            } else if (((Control) c).matches(Controller.DESTROY_APPLICATION_SIGNAL_ID)) {

                BasicApplication a = (BasicApplication) c.getSender();

                // The user initiates a DESTROY_APPLICATION_SIGNAL_ID control event
                // in a menu bar, a tool bar or a windowbutton, to close an application.
                // Normally, the application has no handle for this destroy event and
                // hence passes it up to its parent controller which finally destroys the application.
                // However, if the child application is a main application itself,
                // it is capable of destroying applications but it would be wrong
                // to let the application destroy itself!
                // Therefore, it is checked here, if the ctrl application parameter
                // equals this. If not, then this application is the parent of the
                // given ctrl application parameter and it is allowed to destroy the application.
                // If the ctrl parameter equals this application, then the control
                // is set unmatched so that the parent application can handle the control again.
                if (a != this) {
                
                    destroyApplication(a);
                
                } else {
                 
                    ((Control) c).setMatched(false);
                }

            } else if (((Control) c).matches(Controller.CONFIGURE_APPLICATION_TREE_SIGNAL_ID)) {

                configureApplicationTree();

            } else if (((Control) c).matches(Controller.CONFIGURE_RES_MEDICINAE_SIGNAL_ID)) {

                configureResMedicinae();

            } else if (((Control) c).matches(Controller.SET_FRAME_DISPLAY_SIGNAL_ID)) {

                changeDisplayMode(DisplayFactory.FRAME_DISPLAY);

            } else if (((Control) c).matches(Controller.SET_INTERNAL_FRAME_DISPLAY_SIGNAL_ID)) {

                changeDisplayMode(DisplayFactory.INTERNAL_FRAME_DISPLAY);

            } else if (((Control) c).matches(Controller.SET_TAB_PAGE_DISPLAY_SIGNAL_ID)) {

                changeDisplayMode(DisplayFactory.TAB_PAGE_DISPLAY);
            }

/*??
            if (evt.getActionCommand().equals(Controller.SET_FRAME_DISPLAY_SIGNAL_ID)) {
    
//??                changeDisplayMode(DisplayFactory.FRAME_DISPLAY);
    
            } else if (evt.getActionCommand().equals(Controller.SET_INTERNAL_FRAME_DISPLAY_SIGNAL_ID)) {
    
//??                changeDisplayMode(DisplayFactory.INTERNAL_FRAME_DISPLAY);
    
            } else if (evt.getActionCommand().equals(Controller.SET_TAB_PAGE_DISPLAY_SIGNAL_ID)) {
    
//??                changeDisplayMode(DisplayFactory.TAB_PAGE_DISPLAY);
            }
*/

        return a;
    }
}

