/*
 * $RCSfile: System.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib;

import org.resmedicinae.resmedlib.block.*;
import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.block.view.graphical.*;
import org.resmedicinae.resmedlib.chain.*;
import org.resmedicinae.resmedlib.digit.Boolean;
import org.resmedicinae.resmedlib.term.String;
//?? Temporary!
import org.resmedicinae.resmedlib.region.Model;

/**
 * This class represents a system.<br><br>
 *
 * It is a super class and forms an own level in the framework's ontology:
 *  <ul>
 *      <li>Network</li>
 *      <li>Family</li>
 *      <li>System</li>
 *      <li>Block</li>
 *      <li>Region</li>
 *      <li>Component</li>
 *      <li>Part</li>
 *      <li>Chain</li>
 *      <li>Term</li>
 *      <li>Sign</li>
 *      <li>Number</li>
 *      <li>Digit</li>
 *  </ul>
 *
 * A system corresponds to an animal or human organism.<br><br>
 *
 * There are several types of systems which are child classes of this class.
 * Among them are <code>Server</code>, <code>WebServer</code> etc.,
 * <code>Agent</code>, <code>MainSystem</code> and others.<br><br>
 *
 * It is important to note that users of systems are treated as system
 * themselves. Taking the metapher of a system being a human person,
 * each system has capabilities to communicate with other systems,
 * may it be alive users (user interface) or programs running on the same
 * (local communication) or other machines (remote communication).
 *
 * Classes inheriting from this class can be run standalone or
 * from within a main application.
 *
 * @version $Revision: 1.34 $ $Date: 2002/12/19 14:24:22 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class System extends Block implements
    java.awt.event.ActionListener,
    javax.swing.event.DocumentListener,
    java.awt.event.FocusListener,
    javax.swing.event.InternalFrameListener,
    java.awt.event.ItemListener,
    java.awt.event.KeyListener,
    javax.swing.event.ListSelectionListener,
    java.awt.event.MouseListener,
    java.awt.event.MouseMotionListener,
    javax.swing.event.TreeSelectionListener,
    java.awt.event.WindowFocusListener,
    java.awt.event.WindowListener,
    java.awt.event.WindowStateListener {

    //
    // Static attribute ids.
    //

    /** The name. */
    public static final String NAME = new String("name");

    /** The version. */
    public static final String VERSION = new String("version");

    /** The date. */
    public static final String DATE = new String("date");

    /** The slogan id. */
    public static final String SLOGAN = new String("slogan");

    /** The logo. */
    public static final String LOGO = new String("logo");

    /** The copyright. */
    public static final String COPYRIGHT = new String("copyright");

    /** The contact. */
    public static final String CONTACT = new String("contact");

    /** The description id. */
    public static final String DESCRIPTION = new String("description");

    /** The authors. */
    public static final String AUTHORS = new String("authors");

    /** The helpers. */
    public static final String HELPERS = new String("helpers");

    /** The inspirations. */
    public static final String INSPIRATIONS = new String("inspirations");

    /** The license. */
    public static final String LICENSE = new String("license");

    /** The controller id. */
    public static final String CONTROLLER = new String("controller");

    /** The textual view id. */
    public static final String TEXTUAL_VIEW = new String("textual_view");

    /** The graphical view id. */
    public static final String GRAPHICAL_VIEW = new String("graphical_view");

    /** The web view id. */
    public static final String WEB_VIEW = new String("web_view");

    /** The communication partners count id. */
    public static final String COMMUNICATION_PARTNERS_COUNT = new String("communication_partners_count");

    /** The communication partner id. */
    public static final String COMMUNICATION_PARTNER = new String("communication_partner");

    /** The shutdown flag id. */
    public static final String SHUTDOWN_FLAG = new String("shutdown_flag");

    //
    // Static signal ids.
    //

    /** The shutdown signal id. */
    public static final String SHUTDOWN_SIGNAL = new String("shutdown_signal");

    //
    // Name.
    //

    /**
     * Creates a name.
     *
     * @return the name
     * @exception NullPointerException if the name is null
     */
    public String createName() throws Exception, NullPointerException {

        String n = new String();
        
        if (n != null) {
            
            n.initialize();
            n.setJavaObject("Res Medicinae");

        } else {

            throw new NullPointerException("Could not create name. The name is null.");
        }

        return n;
    }

    /*
     * Destroys the name.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void destroyName(String n) throws Exception, NullPointerException {

        if (n != null) {
            
            n.finalizz();

        } else {

            throw new NullPointerException("Could not destroy name. The name is null.");
        }
    }

    //
    // Version.
    //

    /**
     * Creates a version.
     *
     * @return the version
     * @exception NullPointerException if the version is null
     */
    public String createVersion() throws Exception, NullPointerException {

        String v = new String();

        if (v != null) {
            
            v.initialize();
            v.setJavaObject("0.0.4.0");

        } else {

            throw new NullPointerException("Could not create version. The version is null.");
        }

        return v;
    }

    /*
     * Destroys the version.
     *
     * @param v the version
     * @exception NullPointerException if the version is null
     */
    public void destroyVersion(String v) throws Exception, NullPointerException {

        if (v != null) {
            
            v.finalizz();

        } else {

            throw new NullPointerException("Could not destroy version. The version is null.");
        }
    }

    //
    // Date.
    //

    /**
     * Creates a date.
     *
     * @return the date
     * @exception NullPointerException if the date is null
     */
    public String createDate() throws Exception, NullPointerException {

        String d = new String();
        
        if (d != null) {

            d.initialize();
            d.setJavaObject("30.09.2002");

        } else {

            throw new NullPointerException("Could not create date. The date is null.");
        }

        return d;
    }

    /*
     * Destroys the date.
     *
     * @param d the date
     * @exception NullPointerException if the date is null
     */
    public void destroyDate(String d) throws Exception, NullPointerException {

        if (d != null) {
            
            d.finalizz();

        } else {

            throw new NullPointerException("Could not destroy date. The date is null.");
        }
    }

    //
    // Slogan.
    //

    /**
     * Creates a slogan.
     *
     * @return the slogan
     * @exception NullPointerException if the slogan is null
     */
    public String createSlogan() throws Exception, NullPointerException {

        String s = new String();
        
        if (s != null) {
            
            s.initialize();
            s.setJavaObject("- Information in Medicine -");

        } else {

            throw new NullPointerException("Could not create slogan. The slogan is null.");
        }

        return s;
    }

    /*
     * Destroys the slogan.
     *
     * @param s the slogan
     * @exception NullPointerException if the slogan is null
     */
    public void destroySlogan(String s) throws Exception, NullPointerException {

        if (s != null) {
            
            s.finalizz();

        } else {

            throw new NullPointerException("Could not destroy slogan. The slogan is null.");
        }
    }

    //
    // Logo.
    //

    /**
     * Creates a logo.
     *
     * @return the logo
     * @exception NullPointerException if the logo is null
     */
    public String createLogo() throws Exception, NullPointerException {

        String l = new String();
        
        if (l != null) {
            
            l.initialize();

        } else {

            throw new NullPointerException("Could not create logo. The logo is null.");
        }

        return l;
    }

    /*
     * Destroys the logo.
     *
     * @param l the logo
     * @exception NullPointerException if the logo is null
     */
    public void destroyLogo(String l) throws Exception, NullPointerException {

        if (l != null) {
            
            l.finalizz();

        } else {

            throw new NullPointerException("Could not destroy logo. The logo is null.");
        }
    }

    //
    // Copyright.
    //

    /**
     * Creates the copyright.
     *
     * @return the copyright
     * @exception NullPointerException if the copyright is null
     */
    public String createCopyright() throws Exception, NullPointerException {

        String c = new String();
        
        if (c != null) {
            
            c.initialize();
            c.setJavaObject("Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.");

        } else {

            throw new NullPointerException("Could not create copyright. The copyright is null.");
        }
        
        return c;
    }

    /*
     * Destroys the copyright.
     *
     * @param c the copyright
     * @exception NullPointerException if the copyright is null
     */
    public void destroyCopyright(String c) throws Exception, NullPointerException {

        if (c != null) {
            
            c.finalizz();

        } else {

            throw new NullPointerException("Could not destroy copyright. The copyright is null.");
        }
    }

    //
    // Contact.
    //

    /**
     * Creates a contact.
     *
     * @return the contact
     * @exception NullPointerException if the contact is null
     */
    public String createContact() throws Exception, NullPointerException {

        String c = new String();
        
        if (c != null) {

            c.initialize();
            c.setJavaObject("http://www.resmedicinae.org");

        } else {

            throw new NullPointerException("Could not create contact. The contact is null.");
        }

        return c;
    }

    /*
     * Destroys the contact.
     *
     * @param c the contact
     * @exception NullPointerException if the contact is null
     */
    public void destroyContact(String c) throws Exception, NullPointerException {

        if (c != null) {
            
            c.finalizz();

        } else {

            throw new NullPointerException("Could not destroy contact. The contact is null.");
        }
    }

    //
    // Description.
    //

    /**
     * Creates a description.
     *
     * @return the description
     * @exception NullPointerException if the description is null
     */
    public String createDescription() throws Exception, NullPointerException {

        String d = new String();
        
        if (d != null) {

            d.initialize();
            d.setJavaObject("Free Medical Information System");

        } else {

            throw new NullPointerException("Could not create description. The description is null.");
        }

        return d;
    }

    /*
     * Destroys the description.
     *
     * @param d the description
     * @exception NullPointerException if the description is null
     */
    public void destroyDescription(String d) throws Exception, NullPointerException {

        if (d != null) {

            d.finalizz();

        } else {

            throw new NullPointerException("Could not destroy description. The description is null.");
        }
    }

    //
    // Authors.
    //

    /**
     * Creates the authors.
     *
     * @return the authors
     * @exception NullPointerException if the authors is null
     */
    public String createAuthors() throws Exception, NullPointerException {

        String a = new String();
        
        if (a != null) {

            a.initialize();
            a.setJavaObject("Unspecified Authors.\n"
                + "Try to contact these project administrators:\n\n"
                + "Christian Heller\n<christian.heller@tuxtax.de>\n\n"
                + "Karsten Hilbert\n<karsten.hilbert@gmx.net>");

        } else {

            throw new NullPointerException("Could not create authors. The authors is null.");
        }

        return a;
    }

    /*
     * Destroys the authors.
     *
     * @param a the authors
     * @exception NullPointerException if the authors is null
     */
    public void destroyAuthors(String a) throws Exception, NullPointerException {

        if (a != null) {
            
            a.finalizz();

        } else {

            throw new NullPointerException("Could not destroy authors. The authors is null.");
        }
    }

    //
    // Helpers.
    //

    /**
     * Creates a helpers.
     *
     * @return the helpers
     * @exception NullPointerException if the helpers is null
     */
    public String createHelpers() throws Exception, NullPointerException {

        String h = new String();
        
        if (h != null) {
            
            h.initialize();

        } else {

            throw new NullPointerException("Could not create helpers. The helpers is null.");
        }

        return h;
    }

    /*
     * Destroys the helpers.
     *
     * @param h the helpers
     * @exception NullPointerException if the helpers is null
     */
    public void destroyHelpers(String h) throws Exception, NullPointerException {

        if (h != null) {
            
            h.finalizz();

        } else {

            throw new NullPointerException("Could not destroy helpers. The helpers is null.");
        }
    }

    //
    // Inspirations.
    //

    /**
     * Creates the inspirations.
     *
     * @return the inspirations
     * @exception NullPointerException if the inspirations is null
     */
    public String createInspirations() throws Exception, NullPointerException {

        String i = new String();
        
        if (i != null) {

            i.initialize();

        } else {

            throw new NullPointerException("Could not create inspirations. The inspirations is null.");
        }

        return i;
    }

    /*
     * Destroys the inspirations.
     *
     * @param i the inspirations
     * @exception NullPointerException if the inspirations is null
     */
    public void destroyInspirations(String i) throws Exception, NullPointerException {

        if (i != null) {
            
            i.finalizz();

        } else {

            throw new NullPointerException("Could not destroy inspirations. The inspirations is null.");
        }
    }

    //
    // License.
    //

    /**
     * Creates the license.
     *
     * @return the license
     * @exception NullPointerException if the license is null
     */
    public String createLicense() throws Exception, NullPointerException {

        String l = new String();
        
        if (l != null) {
            
            l.initialize();
            l.setJavaObject("This software is published under the GPL GNU General Public License.\n"
                + "This program is free software; you can redistribute it and/or\n"
                + "modify it under the terms of the GNU General Public License\n"
                + "as published by the Free Software Foundation; either version 2\n"
                + "of the License, or (at your option) any later version.\n\n"
                + "This program is distributed in the hope that it will be useful,\n"
                + "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
                + "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n"
                + "GNU General Public License for more details.\n\n"
                + "You should have received a copy of the GNU General Public License\n"
                + "along with this program; if not, write to the Free Software\n"
                + "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n"
                + "Find the GPL license and more information at: http://www.gnu.org");

        } else {

            throw new NullPointerException("Could not create license. The license is null.");
        }

        return l;
    }

    /*
     * Destroys the license.
     *
     * @param l the license
     * @exception NullPointerException if the license is null
     */
    public void destroyLicense(String l) throws Exception, NullPointerException {

        if (l != null) {
            
            l.finalizz();

        } else {

            throw new NullPointerException("Could not destroy license. The license is null.");
        }
    }

    //
    // Controller.
    //

    /**
     * Creates a controller.
     *
     * @return the controller
     * @exception NullPointerException if the controller is null
     */
    public Controller createController() throws Exception, NullPointerException {

        Controller c = new Controller();
        
        if (c != null) {

            c.globalize((Item) get(System.GLOBALS));
            c.initialize();
            c.link();

        } else {

            throw new NullPointerException("Could not create controller. The controller is null.");
        }

        return c;
    }

    /**
     * Destroys the controller.
     *
     * @param c the controller
     * @exception NullPointerException if the controller is null
     */
    public void destroyController(Controller c) throws Exception, NullPointerException {

        if (c != null) {

            c.unlink();
            c.finalizz();
            c.deglobalize((Item) get(System.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy controller. The controller is null.");
        }
    }
    
    //
    // Textual view.
    //

    /**
     * Creates a textual view.
     *
     * @return the textual view
     * @exception NullPointerException if the textual view is null
     */
    public TextualView createTextualView() throws Exception, NullPointerException {

        TextualView v = null;

        if (v != null) {

            v.globalize((Item) get(System.GLOBALS));
            v.initialize();
            v.link();

        } else {

            throw new NullPointerException("Could not create textual view. The textual view is null.");
        }

        return v;
    }

    /**
     * Destroys the textual view.
     *
     * @param v the textual view
     * @exception NullPointerException if the textual view is null
     */
    public void destroyTextualView(TextualView v) throws Exception, NullPointerException {

        if (v != null) {

            v.unlink();
            v.finalizz();
            v.deglobalize((Item) get(System.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy textual view. The textual view is null.");
        }
    }

    //
    // Graphical view.
    //

    /**
     * Creates a graphical view.
     *
     * @return the graphical view
     * @exception NullPointerException if the graphical view mode is null
     * @exception Exception if the graphical view mode is not known
     */
    public GraphicalView createGraphicalView() throws Exception, NullPointerException {

        GraphicalView v = new GraphicalView();

        if (v != null) {

            v.globalize((Item) get(System.GLOBALS));
            v.initialize();
            v.link();

        } else {

            throw new NullPointerException("Could not create graphical view. The graphical view is null.");
        }

        return v;
    }

    /**
     * Destroys the graphical view.
     *
     * @param v the graphical view
     * @exception NullPointerException if the graphical view is null
     */
    public void destroyGraphicalView(GraphicalView v) throws Exception, NullPointerException {

        if (v != null) {

            v.unlink();
            v.finalizz();
            v.deglobalize((Item) get(System.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy graphical view. The graphical view is null.");
        }
    }

    //
    // Web view.
    //

    /**
     * Creates a web view.
     *
     * @return the web view
     * @exception NullPointerException if the web view is null
     */
    public WebView createWebView() throws Exception, NullPointerException {

        WebView v = null;

        if (v != null) {

            v.globalize((Item) get(System.GLOBALS));
            v.initialize();
            v.link();

        } else {

            throw new NullPointerException("Could not create web view. The web view is null.");
        }

        return v;
    }

    /**
     * Destroys the web view.
     *
     * @param v the web view
     * @exception NullPointerException if the web view is null
     */
    public void destroyWebView(WebView v) throws Exception, NullPointerException {

        if (v != null) {

            v.unlink();
            v.finalizz();
            v.deglobalize((Item) get(System.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy web view. The web view is null.");
        }
    }

    //
    // Shutdown flag.
    //

    /**
     * Creates the shutdown flag.
     *
     * @return the shutdown flag
     */
    public Boolean createShutdownFlag() {

        return new Boolean(Boolean.FALSE);
    }

    /**
     * Destroys the shutdown flag.
     *
     * @param f the shutdown flag
     */
    public void destroyShutdownFlag(Boolean f) {
    }

    //
    // Splash window.
    //

    /**
     * Creates the splash window.
     *
     * @return the splash window
     */
/*??
    public SplashWindow createSplashWindow() throws Exception {

        SplashWindow c = new SplashWindow();

        // Bring component through birth process.
        bear(c);

        return c;
    }

    /**
     * Destroys the splash window.
     *
     * @param c the splash window
     */
/*??
    public void destroySplashWindow(SplashWindow c) throws Exception {

        // Bring component through death process.
        kill(c);
    }

    /**
     * Advances the splash window.
     *
     * Prints out a message using the logger.
     *
     * @param step the value to set the progress bar to
     * @param msg the message
     */
/*??
    public void advanceSplashWindow(org.resmedicinae.resmedlib.number.Integer step, String msg) throws Exception {

        SplashWindow sw = getSplashWindow();

        if (sw != null) {

            sw.advance(step, msg);
        }
    }

    //
    // Login dialog.
    //

    /**
     * Creates the login dialog.
     *
     * @exception NullPointerException if the login dialog is null
     */
/*??
    public LoginDialog createLoginDialog() throws Exception, NullPointerException {

        LoginDialog c = new LoginDialog();

        // Bring component through birth process.
        bear(c);

        return c;
    }

    /**
     * Destroys the login dialog.
     *
     * @exception NullPointerException if the login dialog is null
     */
/*??
    public void destroyLoginDialog(LoginDialog c) throws Exception, NullPointerException {

        // Bring component through death process.
        kill(c);
    }

    //
    // About dialog.
    //

    /**
     * Creates the about dialog.
     *
     * @exception NullPointerException if the context is null
     */
/*??
    private AboutDialog createAboutDialog() throws Exception, NullPointerException {

        AboutDialog c = new AboutDialog();

        Context ctxt = getContext();

        if (ctxt != null) {

            ctxt.putEntry("name", getName());
            ctxt.putEntry("version", getVersion());
            ctxt.putEntry("date", getDate());
            ctxt.putEntry("slogan", getSlogan());
            ctxt.putEntry("logo", getLogo());
            ctxt.putEntry("copyright", getCopyright());
            ctxt.putEntry("contact", getContact());
            ctxt.putEntry("description", getDescription());
            ctxt.putEntry("authors", getAuthors());
            ctxt.putEntry("helpers", getHelpers());
            ctxt.putEntry("inspirations", getInspirations());
            ctxt.putEntry("license", getLicense());

        } else {

            throw new NullPointerException("Could not create about dialog. The context is null.");
        }

        bear(c);

        return c;
    }

    /**
     * Destroys the about dialog.
     *
     * @param c the about dialog
     */
/*??
    private void destroyAboutDialog(AboutDialog c) throws Exception {

        kill(c);
    }

    //
    // User.
    //

    /**
     * Creates a user.
     *
     * @return the user
     */
/*??
    public User createUser() throws Exception {

        User u = new User();

        if (u != null) {

        LoginDialog c = new LoginDialog();

            // Bring component through birth process.
            c.initialize();

        } else {

            throw new NullPointerException("Could not create user. The user is null.");
        }

        return u;
    }

    /**
     * Destroys the user.
     *
     * @param u the user
     */
/*??
    public void destroyUser(User u) throws Exception {

            u.finalizz();
    }

    //
    // Initializable.
    //

    /**
     * Initializes this system.
     *
     * @exception NullPointerException if the configuration is null
     */
    public void initialize() throws Exception, NullPointerException {

        super.initialize();

        Configuration c = (Configuration) get(System.CONFIGURATION);

        if (c != null) {

            set(System.NAME, createName());
            set(System.VERSION, createVersion());
            set(System.DATE, createDate());

            String slogan = c.get(System.SLOGAN, createSlogan());

            if ((slogan != null) && !slogan.equals("null")) {

                set(System.SLOGAN, slogan);
            }

            set(System.LOGO, createLogo());
            set(System.COPYRIGHT, createCopyright());
            set(System.CONTACT, createContact());

            String description = c.get(System.DESCRIPTION, createDescription());

            if ((description != null) && !description.equals("null")) {

                set(System.DESCRIPTION, description);
            }

            set(System.AUTHORS, createAuthors());
            set(System.HELPERS, createHelpers());
            set(System.INSPIRATIONS, createInspirations());
            set(System.LICENSE, createLicense());

            Boolean controller = c.get(System.CONTROLLER, new Boolean(true));

            if ((controller != null) && (controller.isUnequalTo(Boolean.FALSE))) {

                set(System.CONTROLLER, createController());
            }

            Boolean textualView = c.get(System.TEXTUAL_VIEW, new Boolean(false));

            if ((textualView != null) && (textualView.isUnequalTo(Boolean.FALSE))) {

                set(System.TEXTUAL_VIEW, createTextualView());
            }

            Boolean graphicalView = c.get(System.GRAPHICAL_VIEW, new Boolean(true));

            if ((graphicalView != null) && (graphicalView.isUnequalTo(Boolean.FALSE))) {

                set(System.GRAPHICAL_VIEW, createGraphicalView());
            }

            Boolean webView = c.get(System.WEB_VIEW, new Boolean(false));

            if ((webView != null) && (webView.isUnequalTo(Boolean.FALSE))) {

                set(System.WEB_VIEW, createWebView());
            }

            set(System.SHUTDOWN_FLAG, createShutdownFlag());

//??            set(dialogs);
//??            set(createUser());

        } else {

            throw new NullPointerException("Could not initialize system. The configuration is null.");
        }
    }

    /**
     * Finalizes this system.
     *
     * @exception NullPointerException if the configuration is null
     */
    public void finalizz() throws Exception, NullPointerException {

        try {

            Configuration c = (Configuration) get(System.CONFIGURATION);

            if (c != null) {

/*??
                dialogs

                destroyUser(getUser());
                setUser(null);
*/

                destroyShutdownFlag((Boolean) get(System.SHUTDOWN_FLAG));
                remove(System.SHUTDOWN_FLAG);

                if (get(System.WEB_VIEW) != null) {

                    c.set(System.WEB_VIEW, new Boolean(true));
                    destroyWebView((WebView) get(System.WEB_VIEW));
                    remove(System.WEB_VIEW);

                } else {

                    c.set(System.WEB_VIEW, new Boolean(false));
                }

                if (get(System.GRAPHICAL_VIEW) != null) {

                    c.set(System.GRAPHICAL_VIEW, new Boolean(true));
                    destroyGraphicalView((GraphicalView) get(System.GRAPHICAL_VIEW));
                    remove(System.GRAPHICAL_VIEW);

                } else {

                    c.set(System.GRAPHICAL_VIEW, new Boolean(false));
                }

                if (get(System.TEXTUAL_VIEW) != null) {

                    c.set(System.TEXTUAL_VIEW, new Boolean(true));
                    destroyTextualView((TextualView) get(System.TEXTUAL_VIEW));
                    remove(System.TEXTUAL_VIEW);

                } else {

                    c.set(System.TEXTUAL_VIEW, new Boolean(false));
                }

                if (get(System.CONTROLLER) != null) {

                    c.set(System.CONTROLLER, new Boolean(true));
                    destroyController((Controller) get(System.CONTROLLER));
                    remove(System.CONTROLLER);

                } else {

                    c.set(System.CONTROLLER, new Boolean(false));
                }

                destroyLicense((String) get(System.LICENSE));
                remove(System.LICENSE);

                destroyInspirations((String) get(System.INSPIRATIONS));
                remove(System.INSPIRATIONS);

                destroyHelpers((String) get(System.HELPERS));
                remove(System.HELPERS);

                destroyAuthors((String) get(System.AUTHORS));
                remove(System.AUTHORS);

                c.set(System.DESCRIPTION, (String) get(System.DESCRIPTION));
                destroyDescription((String) get(System.DESCRIPTION));
                remove(System.DESCRIPTION);

                destroyContact((String) get(System.CONTACT));
                remove(System.CONTACT);

                destroyCopyright((String) get(System.COPYRIGHT));
                remove(System.COPYRIGHT);

                destroyLogo((String) get(System.LOGO));
                remove(System.LOGO);

                c.set(System.SLOGAN, (String) get(System.SLOGAN));
                destroySlogan((String) get(System.SLOGAN));
                remove(System.SLOGAN);

                destroyDate((String) get(System.DATE));
                remove(System.DATE);

                destroyVersion((String) get(System.VERSION));
                remove(System.VERSION);

                destroyName((String) get(System.NAME));
                remove(System.NAME);

            } else {
                
                throw new NullPointerException("Could not finalize system. The configuration is null.");
            }

        } finally {

            super.finalizz();
        }
    }

    //
    // Linkable.
    //
    
    /**
     * Links this system.
     *
     * @exception NullPointerException if the controller is null
     * @exception NullPointerException if the graphical view is null
     */
    public void link() throws Exception, NullPointerException {

        super.link();

        Controller c = (Controller) get(System.CONTROLLER);
        
        if (c != null) {
            
            GraphicalView v = (GraphicalView) get(System.GRAPHICAL_VIEW);

            if (v != null) {

                v.set(GraphicalView.VIEW_DECODER, c.get(Controller.VIEW_DECODER));

                //?? Temporary start.
                org.resmedicinae.resmedlib.region.view.graphical.PortalMenuBar mb = (org.resmedicinae.resmedlib.region.view.graphical.PortalMenuBar) v.get(GraphicalView.MENU_BAR);
                org.resmedicinae.resmedlib.region.view.graphical.menu.SystemsMenu sm = (org.resmedicinae.resmedlib.region.view.graphical.menu.SystemsMenu) mb.get(org.resmedicinae.resmedlib.region.view.graphical.PortalMenuBar.SYSTEMS_MENU);
                org.resmedicinae.resmedlib.component.view.graphical.menuitem.ExitMenuItem mi = (org.resmedicinae.resmedlib.component.view.graphical.menuitem.ExitMenuItem) sm.get(org.resmedicinae.resmedlib.region.view.graphical.menu.SystemsMenu.EXIT_MENU_ITEM);

                mi.set(org.resmedicinae.resmedlib.component.view.graphical.MenuItem.SIGNAL, System.SHUTDOWN_SIGNAL);
                //?? Temporary finish.

            } else {
                
                throw new NullPointerException("Could not link system. The graphical view is null.");
            }

        } else {

            throw new NullPointerException("Could not link system. The controller is null.");
        }
    }

    /**
     * Unlinks this system.
     *
     * @exception NullPointerException if the controller is null
     * @exception NullPointerException if the graphical view is null
     */
    public void unlink() throws Exception, NullPointerException {

        try {

            Controller c = (Controller) get(System.CONTROLLER);
            
            if (c != null) {
                
                GraphicalView v = (GraphicalView) get(System.GRAPHICAL_VIEW);
        
                if (v != null) {
    
                    v.remove(GraphicalView.VIEW_DECODER);
    
                } else {
                    
                    throw new NullPointerException("Could not link system. The graphical view is null.");
                }
    
            } else {
    
                throw new NullPointerException("Could not link system. The controller is null.");
            }

        } finally {

            super.unlink();
        }
    }

    //
    // Askable.
    //

    /**
     * Asks this system.
     *
     * @param o the question operation
     * @param d the question data
     * @return the answer data
     * @exception NullPointerException if the operation is null
     * @exception NullPointerException if the controller is null
     */
    public Model ask(String o, GraphicalView d) throws Exception, NullPointerException {

        Model a = null;

        if (o != null) {

            java.lang.System.out.println("test o: " + o);

            if (o.isEqualTo(System.SHUTDOWN_SIGNAL)) {

                java.lang.System.out.println("test shutdown");
                set(System.SHUTDOWN_FLAG, new Boolean(Boolean.TRUE));

            } else {
                
                Controller c = (Controller) get(System.CONTROLLER);
        
                if (c != null) {
        
                    a = c.control(o, d);
        
                } else {
        
                    throw new NullPointerException("Could not ask system. The controller is null.");
                }
            }

        } else {

            throw new NullPointerException("Could not ask system. The operation is null.");
        }

        return a;
    }

    //
    // Log in and out.
    //

    /**
     * Logs in the user.
     *
     * @param u the user
     * @exception NullPointerException if the user is null
     */
/*??
    public void login(User u) throws NullPointerException {

        if (u != null) {

            //?? What to do here? Reconfigure, Reinitialize, Reshow...!
            a.setUser(createUser());
            a.login(getUser());

        } else {

            throw new NullPointerException("Could not login user. The user is null.");
        }
    }

    /**
     * Logs out the user.
     *
     * @param u the user
     * @exception NullPointerException if the user is null
     */
/*??
    public void logout(User u) throws NullPointerException {

        if (u != null) {

            //?? What to do here? Reconfigure, Reinitialize, Reshow...!
            c.logout(getUser());
            c.destroyUser(getUser());
            c.setUser(null);

        } else {

            throw new NullPointerException("Could not logout user. The user is null.");
        }
    }
*/

    //
    // Temporary methods to:
    // - catch ALL events of the java AWT/Swing framework
    // - extract the actual signal string
    // - forward the signal to the controller
    //
    // These methods are to be removed as soon as this framework
    // supports mouse event handling.
    //

    /**
     * Catches action events.
     *
     * @param evt the event
     */                
    public void actionPerformed(java.awt.event.ActionEvent evt) {

        try {

            java.lang.System.out.println("test evt: " + evt);
            ask(new String(evt.getActionCommand()), (GraphicalView) ((Controller) get(System.CONTROLLER)).get(System.GRAPHICAL_VIEW));
            java.lang.System.out.println("test cmd: " + evt.getActionCommand());

        } catch (Exception e) {

            java.lang.System.out.println("ERROR: Could not catch action event. The action event is null.");
        }
    }

	/**
	 * Evaluates the event if some attribute has changed
	 *
     * @param evt the event
	 */
	public void changedUpdate(javax.swing.event.DocumentEvent evt) {
	}

	/**
	 * Evaluates the event if something was inserted into the text area
	 *
     * @param evt the event
	 */
	public void insertUpdate(javax.swing.event.DocumentEvent evt) {
	}

    /**
     * Handles all item events of the whole application.
	 *
     * @param evt the event
     */                
    public void itemStateChanged(java.awt.event.ItemEvent evt) {
    }

    /**
     * Handles all keyPressed events of the whole application.
	 *
     * @param evt the event
     */                
    public void keyPressed(java.awt.event.KeyEvent evt) {        
    }

    /**
     * Handles all keyTyped events of the whole application.
	 *
     * @param evt the event
     */                
    public void keyTyped(java.awt.event.KeyEvent evt) {        
    }

   /**
    * Handles all keyReleased events of the whole application.
	 *
     * @param evt the event
    */            
    public void keyReleased(java.awt.event.KeyEvent evt) {
    }

    /**
     * Handles all mouseClicked events of the whole application.
	 *
     * @param evt the event
     */                
    public void mouseClicked(java.awt.event.MouseEvent evt) {
    }

    /**
     * Not implemented.
	 *
     * @param evt the event
     */
    public void mouseDragged(java.awt.event.MouseEvent evt) { 
    }

    /**
     * Not implemented.
	 *
     * @param evt the event
     */
    public void mouseEntered(java.awt.event.MouseEvent evt) {
    }
   
    /**
     * Not implemented.
	 *
     * @param evt the event
     */
    public void mouseExited(java.awt.event.MouseEvent evt) {
    }

    /**
     * Mouse moves are registered. If the mouse moved over a polygon area, the polygon is
     * drawn. The polygon info panel is also updated. If one polygon is already painted, and
     * the mouse is still on it, it will no be painted again (see isPainted()). If mouse moves
     * out of a polygon the whole panel is repainted and also overidden the painted polygons
     * Of course in this case the info panel is also updated.
	 *
     * @param evt the event
     */
    public void mouseMoved(java.awt.event.MouseEvent evt) {
    }

    /**
     * Not implemented.
	 *
     * @param evt the event
     */
    public void mousePressed(java.awt.event.MouseEvent evt) { 
    }

    /**
     * Not implemented.
	 *
     * @param evt the event
     */
    public void mouseReleased(java.awt.event.MouseEvent evt) { 
    }

	/**
	 * Evaluates the event if something was removed from the text area
	 *
     * @param evt the event
	 */
	public void removeUpdate(javax.swing.event.DocumentEvent evt) {
	}

    /**
     * Here are all valueChanged events of the whole application handled. These 
     * are events from tables, or lists.
	 *
     * @param evt the event
     */                
    public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
    }

    /**
     * Listens and reacts to tree selection events.
     *
     * ?? Delete this method as soon as a ResTree component with event/control handling is provided!
     * ?? The direct call of Controller in this method is very unclean design!
     * ?? The Controller should only react to Control Events of the MVC framework!
	 *
     * @param evt the event
     */
    public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {

/*??
        // Determine application tree view as the event's source.
        ResTree tv = (ResTree) evt.getSource();

        if (tv != null) {

            // Determine selected application tree node.
            ApplicationTreeNode n = (ApplicationTreeNode) tv.getLastSelectedPathComponent();

            if (n != null) {

                if (n.isLeaf()) {

                    if (n.isExternal() == false) {

                        try {

                            // Create the application corresponding to the clicked tree node.
                            createApplication(n.getLocation(), n.getArguments(), n.getWorkPath());

                        } catch (Exception e) {

//??                            log(Level.SEVERE, "Error while creating application.", e);
                            java.lang.System.out.println("Error while creating application." + e);
                        }

                    } else {

                        try {

                            // Create the external application corresponding to the clicked tree node.
                            createExternalApplication(n.getLocation()/*??getCommand()*//*??, n.getArguments(), n.getWorkPath());

                        } catch (Exception e) {

//??                            log(Level.SEVERE, "Error while creating external application.", e);
                            java.lang.System.out.println("Error while creating external application." + e);
                        }
                    }
                }
            }
        }
*/
    }

    //
    // Focus listener.
    //

    /**
     * Invoked when a component gains the keyboard focus.
	 *
     * @param evt the event
     */
    public void focusGained(java.awt.event.FocusEvent evt) {
    }

    /**
     * Invoked when a component loses the keyboard focus.
	 *
     * @param evt the event
     */
    public void focusLost(java.awt.event.FocusEvent evt) {
    }

    //
    // Window events.
    //

    /**
     * Invoked when a window has been opened.
     *
     * @param evt the window event
     */
    public void windowOpened(java.awt.event.WindowEvent evt) {
    }

    /**
     * Invoked when a window is in the process of being closed.
     * The close operation can be overridden at this point.
     *
     * @param evt the window event
     * @exception NullPointerException if the view is null
     */
    public void windowClosing(java.awt.event.WindowEvent evt) throws NullPointerException {

/*??
        SwingView v = getView();

        if (v != null) {

//??            v.issueControl(v.getCloseControl());

        } else {

            throw new NullPointerException("Could not issue control. The view is null.");
        }
*/
    }

    /**
     * Invoked when a window has been closed.
     *
     * @param evt the window event
     */
    public void windowClosed(java.awt.event.WindowEvent evt) {
    }

    /**
     * Invoked when a window is iconified.
     *
     * @param evt the window event
     */
    public void windowIconified(java.awt.event.WindowEvent evt) {
    }

    /**
     * Invoked when a window is de-iconified.
     *
     * @param evt the window event
     */
    public void windowDeiconified(java.awt.event.WindowEvent evt) {
    }

    /**
     * Invoked when a window is activated.
     *
     * @param evt the window event
     */
    public void windowActivated(java.awt.event.WindowEvent evt) {
    }

    /**
     * Invoked when a window is de-activated.
     *
     * @param evt the window event
     */
    public void windowDeactivated(java.awt.event.WindowEvent evt) {
    }

    /**
     * Invoked when a window state is changed.
     *
     * @param evt the window event
     */
    public void windowStateChanged(java.awt.event.WindowEvent evt) {
    }

    /**
     * Invoked when the Window is set to be the focused Window, which means
     * that the Window, or one of its subcomponents, will receive keyboard
     * events.
     *
     * @param evt the window event
     */
    public void windowGainedFocus(java.awt.event.WindowEvent evt) {
    }

    /**
     * Invoked when the Window is no longer the focused Window, which means
     * that keyboard events will no longer be delivered to the Window or any of
     * its subcomponents.
     *
     * @param evt the window event
     */
    public void windowLostFocus(java.awt.event.WindowEvent evt) {
    }

    //
    // Internal frame events.
    //

    /**
     * Invoked when an internal frame has been opened.
     *
     * @param evt the internal frame event
     */
    public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
    }

    /**
     * Invoked when an internal frame is in the process of being closed.
     * The close operation can be overridden at this point.
     *
     * @param evt the internal frame event
     */
    public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {

//??        getView().issueControl(getView().getCloseControl());
    }

    /**
     * Invoked when an internal frame has been closed.
     *
     * @param evt the internal frame event
     */
    public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
    }

    /**
     * Invoked when an internal frame is iconified.
     *
     * @param evt the internal frame event
     */
    public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
    }

    /**
     * Invoked when an internal frame is de-iconified.
     *
     * @param evt the internal frame event
     */
    public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
    }

    /**
     * Invoked when an internal frame is activated.
     *
     * @param evt the internal frame event
     */
    public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
    }

    /**
     * Invoked when an internal frame is de-activated.
     *
     * @param evt the internal frame event
     */
    public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
    }
}

