/*
 * $RCSfile: Structure.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib;

/**
 * This class represents a structure. 
 *
 * Its purpose is to keep child items that an item consists of.
 *
 * Structures can be quite different. An atom has electrons around it,
 * a molecule can be built of different atoms in a certain structure,
 * a human dna encrypts its information by putting molecules in a special
 * order and so on.
 *
 * In programming, however, the most useful structures are:<br>
 *  <ul>
 *      <li>Collection (List, Set)</li>
 *      <li>Map</li>
 *      <li>Array</li>
 *  </ul>
 * These are child classes inheriting from this class.
 *
 * @version $Revision: 1.3 $ $Date: 2002/09/21 21:13:32 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Structure extends java.lang.Object {

    //
    // Attributes.
    //
    
    /** The access method. */
    private AccessMethod accessMethod;

    //
    // Access method.
    //
    
    /**
     * Returns the access method.
     *
     * @return the access method
     */
    public AccessMethod getAccessMethod() {
        
        return this.accessMethod;
    }
    
    /**
     * Sets the access method.
     * 
     * @param accessMethod the access method
     */
    public void setAccessMethod(AccessMethod accessMethod) {

        this.accessMethod = accessMethod;
    }
    
    /**
     * Creates an access method.
     *
     * @return the access method
     * @exception NullPointerException if the access method is null
     */
    public AccessMethod createAccessMethod() throws NullPointerException {

        AccessMethod am = new AccessMethod();
        
        if (am != null) {

        } else {
            
            throw new NullPointerException("Could not create access method. The access method is null.");
        }
        
        return am;        
    }
    
    /**
     * Destroys the access method.
     *
     * @param am the access method
     * @exception NullPointerException if the access method is null
     */
    public void destroyAccessMethod(AccessMethod am) throws NullPointerException {

        if (am != null) {

        } else {
            
            throw new NullPointerException("Could not destroy access method. The access method is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this item.
     */
    public void initialize() throws Exception {
        
        setAccessMethod(createAccessMethod());
    }

    /**
     * Finalizes this item.
     *
     * The method's name is <code>finalizz</code> and not
     * <code>finalize</code> because java's top most class
     * <code>Object</code> already uses <code>finalize</code>.
     */
    public void finalizz() throws Exception {
        
        destroyAccessMethod(getAccessMethod());
        setAccessMethod(null);
    }
}

