/*
 * $RCSfile: Signal.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib;

/**
 * This class represents a signal.<br><br>
 *
 * It is a super class but does NOT form an own level in the framework's ontology.
 * Rather its purpose is to enable easy communication between items of the
 * single ontological levels which are:
 *  <ul>
 *      <li>Network</li>
 *      <li>Family</li>
 *      <li>System</li>
 *      <li>Block</li>
 *      <li>Region</li>
 *      <li>Component</li>
 *      <li>Part</li>
 *      <li>Chain</li>
 *      <li>Term</li>
 *      <li>Sign</li>
 *      <li>Number</li>
 *      <li>Digit</li>
 *  </ul>
 *
 * A signal corresponds to electrical or chemical signals in human body, respectively.
 * That is, electrons move along between cells so that a potential is built up.
 * Once a threshold value is reached, the cell will forward the signal to other
 * cells. Also, neurotransmitters such as Acetylcholin have an important role
 * in this process. Find more details in anatomical/neuro literature.<br><br>
 * 
 * --- 8< --- (old comment; possibly to be deleted later)
 * It is passed up the chain of Controllers to invoke a piece of presentation logic.
 * Controllers match against the id of a Control passed into BasicController#handleControl.
 * If the id is recognised then the Controller can execute some presentation logic.
 * If the Control id is not recognised, the Control should be sent back on its journey
 * up the chain of responsibility by passing it to the parent Controller.
 * See Controller#passControlToParent<br><br>
 *
 * Controls are received by a Controller from either a View or a child Controller.
 * Controls can optionally contain an Object parameter.<br><br>
 *
 * The Control id is used by Controllers to recognise a Control and also as a key
 * to the user-readable version of the Control's name in UIStrings presented to
 * the user by the default error-handling mechanism in BasicController.
 * --- 8< --- (end of old comment)
 *
 * @version $Revision: 1.4 $ $Date: 2002/09/22 19:45:07 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Signal extends Item {

    //
    // Attributes.
    //
    
    /** The id. */
    private String id;

    /** The sender. */
    private Item sender;

    /** The matched flag. */
    private org.resmedicinae.resmedlib.digit.Boolean matched;

    //
    // Id.
    //
    
    /**
     * Creates an id.
     *
     * @return the id
     */
    public String createId() {

        return "";        
    }
    
    /**
     * Destroys the id.
     *
     * @param id the id
     */
    public void destroyId(String id) {
    }

    /**
     * Sets the id.
     *
     * @param id the id
     */
    public void setId(String id) {

        this.id = id;        
    }
    
    /**
     * Returns the id.
     *
     * @return the id
     */
    public String getId() {

        return this.id;
    }
     
    //
    // Sender.
    //
    
    /**
     * Creates a sender.
     *
     * @return the sender
     */
    public Item createSender() {

        return null;        
    }

    /**
     * Destroys the sender.
     *
     * @param sender the sender
     */
    public void destroySender(Item sender) {
    }

    /**
     * Sets the sender.
     *
     * @param sender the sender
     */
    public void setSender(Item sender) {

        this.sender = sender;        
    }

    /**
     * Returns the sender.
     *
     * @return the sender
     */
    public Item getSender() {

        return this.sender;
    }
     
    //
    // Matched flag.
    //
    
    /**
     * Creates a matched flag.
     *
     * @return the matched flag
     * @exception NullPointerException if the matched flag is null
     */
    public org.resmedicinae.resmedlib.digit.Boolean createMatched() throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.digit.Boolean f = new org.resmedicinae.resmedlib.digit.Boolean(); 
        
        if (f != null) {
            
            f.initialize();
            
        } else {
        
            throw new NullPointerException("Could not create matched flag. The matched flag is null."); 
        }
        
        return f;        
    }
    
    /**
     * Destroys the matched flag.
     *
     * @param f the matched flag
     * @exception NullPointerException if the matched flag is null
     */
    public void destroyMatched(org.resmedicinae.resmedlib.digit.Boolean f) throws Exception, NullPointerException {

        if (f != null) {
            
            f.finalizz();
            
        } else {
        
            throw new NullPointerException("Could not destroy matched flag. The matched flag is null."); 
        }
    }

    /**
     * Sets the matched flag.
     *
     * @param f the matched flag
     */
    public void setMatched(org.resmedicinae.resmedlib.digit.Boolean f) {

        this.matched = f;        
    }
    
    /**
     * Returns the matched flag.
     *
     * @return the matched flag
     */
    public org.resmedicinae.resmedlib.digit.Boolean getMatched() {

        return this.matched;
    }
     
    //
    // Initializable.
    //
    
    /**
     * Initializes this signal.
     */
    public void initialize() throws Exception {

        setId(createId());
        setSender(createSender());        
        setMatched(createMatched());        
    }

    /**
     * Finalizes this signal.
     */
    public void finalizz() throws Exception {

        destroyMatched(getMatched());
        setMatched(null);

        destroySender(getSender());        
        setSender(null); 

        destroyId(getId());
        setId(null);
    }

    //
    // Comparison.
    //
    
    /**
     * Returns a org.resmedicinae.resmedlib.digit.Boolean value indicating whether or not the id matches.
     *
     * @param id the id string to be checked
     * @return the string representation of this object
     * @exception NullPointerException if the id is null
     */
/*??
    public org.resmedicinae.resmedlib.digit.Boolean isEqualTo(String id) throws NullPointerException {

        org.resmedicinae.resmedlib.digit.Boolean b = false;

        if (getMatched() == false) {
                
            if (id != null) {
    
                b = id.equals(getId());
    
                setMatched(b);
                
            } else {
                
                throw new NullPointerException("Could not compare ids. The id is null.");
            }
        }
        
        return b;
    }
*/
}

