/*
 * $RCSfile: Family.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib;

import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.chain.*;
import org.resmedicinae.resmedlib.system.*;
import org.resmedicinae.resmedlib.term.*;

/**
 * This class represents a family.
 *
 * It is a super class and forms an own level in the framework's ontology:
 *  <ul>
 *      <li>Network</li>
 *      <li>Family</li>
 *      <li>System</li>
 *      <li>Block</li>
 *      <li>Region</li>
 *      <li>Component</li>
 *      <li>Part</li>
 *      <li>Chain</li>
 *      <li>Term</li>
 *      <li>Sign</li>
 *      <li>Number</li>
 *      <li>Digit</li>
 *  </ul>
 *
 * A family corresponds to a biotop in biology or a family in human society.
 *
 * @version $Revision: 1.23 $ $Date: 2002/12/13 15:35:46 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Family extends System {

    //
    // Static attribute ids.
    //

    /** The available systems id. */
    public static final org.resmedicinae.resmedlib.term.String AVAILABLE_SYSTEMS = new org.resmedicinae.resmedlib.term.String("available_systems");

    /** The systems count id. */
    public static final org.resmedicinae.resmedlib.term.String SYSTEMS_COUNT = new org.resmedicinae.resmedlib.term.String("systems_count");

    /** The system location id. */
    public static final org.resmedicinae.resmedlib.term.String SYSTEM_LOCATION = new org.resmedicinae.resmedlib.term.String("system_location");

    /** The system arguments id. */
    public static final org.resmedicinae.resmedlib.term.String SYSTEM_ARGUMENTS = new org.resmedicinae.resmedlib.term.String("system_arguments");
    
    /** The system workpath id. */
    public static final org.resmedicinae.resmedlib.term.String SYSTEM_WORKPATH = new org.resmedicinae.resmedlib.term.String("system_workpath");

    /** The system id. */
    public static final org.resmedicinae.resmedlib.term.String SYSTEM = new org.resmedicinae.resmedlib.term.String("system");

    /** The external systems count id. */
    public static final org.resmedicinae.resmedlib.term.String EXTERNAL_SYSTEMS_COUNT = new org.resmedicinae.resmedlib.term.String("external_systems_count");

    /** The external system command with arguments id. */
    public static final org.resmedicinae.resmedlib.term.String EXTERNAL_SYSTEM_COMMAND = new org.resmedicinae.resmedlib.term.String("external_system_command");

    /** The external system id. */
    public static final org.resmedicinae.resmedlib.term.String EXTERNAL_SYSTEM = new org.resmedicinae.resmedlib.term.String("external_system");

    //
    // Available systems.
    //

    /**
     * Creates available systems.
     *
     * @return the available systems
     * @exception NullPointerException if the available systems is null
     */
    public org.resmedicinae.resmedlib.Family createAvailableSystems() throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.Family as = new org.resmedicinae.resmedlib.Family();

        if (as != null) {

        } else {

            throw new NullPointerException("Could not create available systems. The available systems is null.");
        }

        return as;
    }

    /**
     * Destroys the available systems.
     *
     * @param as the available systems
     * @exception NullPointerException if the available systems is null
     */
    public void destroyAvailableSystems(org.resmedicinae.resmedlib.Family as) throws Exception, NullPointerException {

        if (as != null) {

        } else {

            throw new NullPointerException("Could not destroy available systems. The available systems is null.");
        }
    }

    //
    // Systems count.
    //

    /**
     * Creates the systems count.
     *
     * @return the systems count
     */
    public org.resmedicinae.resmedlib.number.Integer createSystemsCount() {

        return new org.resmedicinae.resmedlib.number.Integer(0);
    }

    /*
     * Destroys the systems count.
     *
     * @param c the systems count
     */
    public void destroySystemsCount(org.resmedicinae.resmedlib.number.Integer c) {
    }

    //
    // System location.
    //

    /**
     * Creates a system location.
     *
     * @return the system location
     */
    public org.resmedicinae.resmedlib.term.String createSystemLocation() {

        return new org.resmedicinae.resmedlib.term.String("");
    }

    /*
     * Destroys the system location.
     *
     * @param l the system location
     */
    public void destroySystemLocation(org.resmedicinae.resmedlib.term.String l) {
    }

    //
    // System arguments.
    //

    /**
     * Creates the system arguments.
     *
     * @return the system arguments
     */
    public org.resmedicinae.resmedlib.term.String createSystemArguments() {

        return new org.resmedicinae.resmedlib.term.String("");
    }

    /*
     * Destroys the system arguments.
     *
     * @param a the system arguments
     */
    public void destroySystemArguments(org.resmedicinae.resmedlib.term.String a) {
    }

    //
    // System workpath.
    //

    /**
     * Creates a system workpath.
     *
     * @return the system workpath
     */
    public org.resmedicinae.resmedlib.term.String createSystemWorkpath() {

        return new org.resmedicinae.resmedlib.term.String("");
    }

    /*
     * Destroys the system workpath.
     *
     * @param p the system workpath
     */
    public void destroySystemWorkpath(org.resmedicinae.resmedlib.term.String p) {
    }

    //
    // System.
    //

    /**
     * Creates a system.
     *
     * @param loc the location of the system or command to execute an external system
     * @param args the command line arguments to run the system
     * @param wp the default work path for the system
     * @return the system
     * @exception NullPointerException if the location is null
     * @exception NullPointerException if the system class is null
     * @exception NullPointerException if the system is null
     */
    public org.resmedicinae.resmedlib.System createSystem(org.resmedicinae.resmedlib.term.String loc, org.resmedicinae.resmedlib.term.String args, org.resmedicinae.resmedlib.term.String wp) throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.System s = null;

//??        showComponentSplashWindow(c);

        if (loc != null) {

            // Find class by name.
            Class cl = Class.forName((java.lang.String) loc.getJavaObject());

            if (cl != null) {

                // Create application from given class type.
                s = (org.resmedicinae.resmedlib.System) cl.newInstance();

            } else {

                throw new NullPointerException("Could not create system. The system class is null. Probably, a wrong location was given.");
            }

        } else {

            throw new NullPointerException("Could not create system. The location is null.");
        }

        if (s != null) {

            log(Component.INFO_LOG_LEVEL, "Globalize the system.");
            s.globalize(get(Family.GLOBALS));
            log(Component.INFO_LOG_LEVEL, "Contextualize the system.");
//??            s.set(Family.GRAPHICAL_PARENT_VIEW, get(Family.GRAPHICAL_VIEW));
            log(Component.INFO_LOG_LEVEL, "Initialize the system.");
            s.initialize();
            log(Component.INFO_LOG_LEVEL, "Link the system.");
            s.link();

        } else {

            throw new NullPointerException("Could not create system. The system is null.");
        }

//??        hideComponentSplashWindow(c);

        return s;
    }

    /**
     * Destroys the system.
     *
     * @param s the system
     * @exception NullPointerException if the system is null
     */
    public void destroySystem(org.resmedicinae.resmedlib.System s) throws Exception, NullPointerException {

        if (s != null) {

            log(Family.INFO_LOG_LEVEL, "Unlink the system.");
            s.unlink();
            log(Family.INFO_LOG_LEVEL, "Finalize the system.");
            s.finalizz();
            log(Family.INFO_LOG_LEVEL, "Decontextualize the system.");
//??            s.remove(System.GRAPHICAL_PARENT_VIEW);
            log(Family.INFO_LOG_LEVEL, "Deglobalize the system.");
            s.deglobalize(get(Family.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy system. The system is null.");
        }
    }

    //
    // External systems count.
    //

    /**
     * Creates the external systems count.
     *
     * @return the external systems count
     */
    public org.resmedicinae.resmedlib.number.Integer createExternalSystemsCount() {

        return new org.resmedicinae.resmedlib.number.Integer(0);
    }

    /*
     * Destroys the external systems count.
     *
     * @param c the external systems count
     */
    public void destroyExternalSystemsCount(org.resmedicinae.resmedlib.number.Integer c) {
    }

    //
    // External system command.
    //

    /**
     * Creates an external system command.
     *
     * @return the external system command
     */
    public org.resmedicinae.resmedlib.term.String createExternalSystemCommand() {

        return new org.resmedicinae.resmedlib.term.String("");
    }

    /*
     * Destroys the external system command.
     *
     * @param c the external system command
     */
    public void destroyExternalSystemCommand(org.resmedicinae.resmedlib.term.String c) {
    }

    //
    // External system.
    //

    /**
     * Creates an external system.
     *
     * @param cmd the command with arguments
     * @return the external system
     * @exception NullPointerException if the external system is null
     */
    public org.resmedicinae.resmedlib.System createExternalSystem(org.resmedicinae.resmedlib.term.String cmd) throws Exception, NullPointerException {

        org.resmedicinae.resmedlib.System s = new ExternalSystem();

//??        showComponentSplashWindow(c);

        if (s != null) {

            log(Family.INFO_LOG_LEVEL, "Globalize the external system.");
            s.globalize(get(Family.GLOBALS));
            log(Family.INFO_LOG_LEVEL, "Contextualize the external system.");
            s.set(ExternalSystem.COMMAND, cmd);
            log(Family.INFO_LOG_LEVEL, "Initialize the external system.");
            s.initialize();
            log(Family.INFO_LOG_LEVEL, "Link the external system.");
            s.link();

        } else {

            throw new NullPointerException("Could not create external system. The external system is null.");
        }

//??        hideComponentSplashWindow(c);

        return s;
    }

    /**
     * Destroys the external system.
     *
     * @param s the external system
     * @exception NullPointerException if the external system is null
     */
    public void destroyExternalSystem(org.resmedicinae.resmedlib.System s) throws Exception, NullPointerException {

        if (s != null) {

            log(Component.INFO_LOG_LEVEL, "Unlink the external system.");
            s.unlink();
            log(Component.INFO_LOG_LEVEL, "Finalize the external system.");
            s.finalizz();
            log(Component.INFO_LOG_LEVEL, "Decontextualize the external system.");
            s.remove(ExternalSystem.COMMAND);
            log(Component.INFO_LOG_LEVEL, "Deglobalize the external system.");
            s.deglobalize(get(Family.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy external system. The external system is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this family.
     *
     * @exception NullPointerException if the configuration is null
     * @exception NullPointerException if the systems count is null
     * @exception NullPointerException if the external systems count is null
     */
    public void initialize() throws Exception, NullPointerException {

        super.initialize();

        Configuration c = (Configuration) get(Family.CONFIGURATION);

        if (c != null) {

            //
            // Available systems.
            //

            set(Family.AVAILABLE_SYSTEMS, createAvailableSystems());

/*??
            org.resmedicinae.resmedlib.number.Integer count = getAvailableSystemsCount();
            String[] s = new String[count];
    
            for (org.resmedicinae.resmedlib.number.Integer i = 0; i < count; i++) {
    
                s[i] = getPreferences().get(PortalConfiguration.AVAILABLE_SYSTEMS + "_" + Integer.toString(i), def);
            }
    
            return s;
*/

            //
            // Systems.
            //

            int i;
            org.resmedicinae.resmedlib.term.String s;

            set(Family.SYSTEMS_COUNT, c.get(Family.SYSTEMS_COUNT, createSystemsCount()));
            set(org.resmedicinae.resmedlib.Family.SYSTEM_LOCATION, createSystemLocation());
            set(org.resmedicinae.resmedlib.Family.SYSTEM_ARGUMENTS, createSystemArguments());
            set(org.resmedicinae.resmedlib.Family.SYSTEM_WORKPATH, createSystemWorkpath());

            if (get(Family.SYSTEMS_COUNT) != null) {

                org.resmedicinae.resmedlib.term.String loc;
                org.resmedicinae.resmedlib.term.String args; 
                org.resmedicinae.resmedlib.term.String wp;
    
                // Retrieve the number of systems and create them one by one.
                for (i = 0; i < ((org.resmedicinae.resmedlib.number.Integer) get(Family.SYSTEMS_COUNT)).getJavaPrimitive(); i++) {

                    s = new org.resmedicinae.resmedlib.term.String(Family.SYSTEM + "_" + java.lang.String.valueOf(i));
                    loc = new org.resmedicinae.resmedlib.term.String(Family.SYSTEM_LOCATION + "_" + java.lang.String.valueOf(i));
                    args = new org.resmedicinae.resmedlib.term.String(Family.SYSTEM_ARGUMENTS + "_" + java.lang.String.valueOf(i));
                    wp = new org.resmedicinae.resmedlib.term.String(Family.SYSTEM_WORKPATH + "_" + java.lang.String.valueOf(i));

                    set(s, createSystem(c.get(loc, new org.resmedicinae.resmedlib.term.String("")), c.get(args, new org.resmedicinae.resmedlib.term.String("")), c.get(wp, new org.resmedicinae.resmedlib.term.String(""))));
                }

            } else {
    
                throw new NullPointerException("Could not initialize family. The systems count is null.");
            }

            //
            // External systems.
            //

            set(Family.EXTERNAL_SYSTEMS_COUNT, c.get(Family.EXTERNAL_SYSTEMS_COUNT, createExternalSystemsCount()));

            if (get(Family.EXTERNAL_SYSTEMS_COUNT) != null) {

                org.resmedicinae.resmedlib.term.String cmd;

                // Retrieve the number of external systems and create them one by one.
                for (i = 0; i < ((org.resmedicinae.resmedlib.number.Integer) get(Family.EXTERNAL_SYSTEMS_COUNT)).getJavaPrimitive(); i++) {

                    s = new org.resmedicinae.resmedlib.term.String(Family.EXTERNAL_SYSTEM + "_" + java.lang.String.valueOf(i));
                    cmd = new org.resmedicinae.resmedlib.term.String(Family.EXTERNAL_SYSTEM_COMMAND + "_" + java.lang.String.valueOf(i));

                    set(s, createExternalSystem(c.get(cmd, new org.resmedicinae.resmedlib.term.String(""))));
                }

            } else {
    
                throw new NullPointerException("Could not initialize family. The external systems count is null.");
            }

        } else {

            throw new NullPointerException("Could not initialize family. The configuration is null.");
        }
    }

    /**
     * Finalizes this family.
     *
     * @exception NullPointerException if the configuration is null
     * @exception NullPointerException if the systems count is null
     * @exception NullPointerException if the external systems count is null
     */
    public void finalizz() throws Exception, NullPointerException {

        try {

            Configuration c = (Configuration) get(Family.CONFIGURATION);

            if (c != null) {

                //
                // External systems.
                //

                int i;
                org.resmedicinae.resmedlib.term.String s;

                if (get(Family.EXTERNAL_SYSTEMS_COUNT) != null) {

                    org.resmedicinae.resmedlib.term.String cmd;

                    for (i = 0; i < ((org.resmedicinae.resmedlib.number.Integer) get(Family.EXTERNAL_SYSTEMS_COUNT)).getJavaPrimitive(); i++) {

                        s = new org.resmedicinae.resmedlib.term.String(Family.EXTERNAL_SYSTEM + "_" + java.lang.String.valueOf(i));
                        cmd = new org.resmedicinae.resmedlib.term.String(Family.EXTERNAL_SYSTEM_COMMAND + "_" + java.lang.String.valueOf(i));

                        c.set(cmd, (org.resmedicinae.resmedlib.term.String) get(cmd));

                        destroyExternalSystem((ExternalSystem) get(s));
                        remove(s);
                    }

                    c.set(Family.EXTERNAL_SYSTEMS_COUNT, (org.resmedicinae.resmedlib.number.Integer) get(Family.EXTERNAL_SYSTEMS_COUNT));
    
                } else {
        
                    throw new NullPointerException("Could not finalize family. The external systems count is null.");
                }

                //
                // Systems.
                //
    
                if (get(Family.SYSTEMS_COUNT) != null) {

                    org.resmedicinae.resmedlib.term.String loc;
                    org.resmedicinae.resmedlib.term.String args; 
                    org.resmedicinae.resmedlib.term.String wp;

                    for (i = 0; i < ((org.resmedicinae.resmedlib.number.Integer) get(Family.SYSTEMS_COUNT)).getJavaPrimitive(); i++) {

                        s = new org.resmedicinae.resmedlib.term.String(Family.SYSTEM + "_" + java.lang.String.valueOf(i));
                        loc = new org.resmedicinae.resmedlib.term.String(Family.SYSTEM_LOCATION + "_" + java.lang.String.valueOf(i));
                        args = new org.resmedicinae.resmedlib.term.String(Family.SYSTEM_ARGUMENTS + "_" + java.lang.String.valueOf(i));
                        wp = new org.resmedicinae.resmedlib.term.String(Family.SYSTEM_WORKPATH + "_" + java.lang.String.valueOf(i));

                        c.set(loc, (org.resmedicinae.resmedlib.term.String) get(loc));
                        c.set(args, (org.resmedicinae.resmedlib.term.String) get(args));
                        c.set(wp, (org.resmedicinae.resmedlib.term.String) get(wp));

                        destroySystem((System) get(s));
                        remove(s);
                    }

                    destroySystemWorkpath((org.resmedicinae.resmedlib.term.String) get(org.resmedicinae.resmedlib.Family.SYSTEM_WORKPATH));
                    remove(org.resmedicinae.resmedlib.Family.SYSTEM_WORKPATH);

                    destroySystemArguments((org.resmedicinae.resmedlib.term.String) get(org.resmedicinae.resmedlib.Family.SYSTEM_ARGUMENTS));
                    remove(org.resmedicinae.resmedlib.Family.SYSTEM_ARGUMENTS);
    
                    destroySystemLocation((org.resmedicinae.resmedlib.term.String) get(org.resmedicinae.resmedlib.Family.SYSTEM_LOCATION));
                    remove(org.resmedicinae.resmedlib.Family.SYSTEM_LOCATION);
    
                    c.set(Family.SYSTEMS_COUNT, (org.resmedicinae.resmedlib.number.Integer) get(Family.SYSTEMS_COUNT));
                    destroySystemsCount((org.resmedicinae.resmedlib.number.Integer) get(org.resmedicinae.resmedlib.Family.SYSTEMS_COUNT));
                    remove(org.resmedicinae.resmedlib.Family.SYSTEMS_COUNT);

                } else {
        
                    throw new NullPointerException("Could not finalize family. The systems count is null.");
                }

                //
                // Available systems.
                //

                destroyAvailableSystems((Family) get(Family.AVAILABLE_SYSTEMS));
                remove(Family.AVAILABLE_SYSTEMS);

/*??
                if (n != null) {

                    Enumeration enum = n.depthFirstEnumeration();
        
                    if (enum != null) {
        
                        Object o;
                        org.resmedicinae.resmedlib.number.Integer i = -1;
        
                        while (enum.hasMoreElements() == true) {
        
                            o = enum.nextElement();
                            i = i + 1;
        
                            if (o != null) {
        
                                getPreferences().put(PortalConfiguration.AVAILABLE_SYSTEMS + "_" + Integer.toString(i), o.toString());
                            }
                        }
                    }
                }
*/

            } else {

                throw new NullPointerException("Could not finalize family. The configuration is null.");
            }

        } finally {

            super.finalizz();
        }
    }
}

