/*
 * $RCSfile: IoXMLFiles.java,v $IoXMLFiles,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.application.healthcare.resadmin.utils;


import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.XMLSerializer;
import org.resmedicinae.application.healthcare.resadmin.data.Person;
import org.resmedicinae.application.healthcare.resadmin.data.XmlPersonTag;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * This class is used for xmlfile handling..
 *
 * @version $Revision: 1.1 $ $Date: 2003/02/20 13:15:19 $ $Author: chrissy $
 * @author Kumanan Kanagasabapathy <kumanan@uni.de>
 */

public class IoXMLFiles {

    private Document singleFileDoc = null;

    public Document parseXMLFile(String fileName) {

        Document doc = new DocumentImpl();
        System.out.println("Try to parse file: " + fileName);

        try {
            DOMParser p = new DOMParser();
            p.setFeature("http://xml.org/sax/features/validation", true);
            p.parse(fileName);
            doc = p.getDocument();
            doc.normalize();
            System.out.println("Parse success.. " + fileName);
        } catch (Exception e) {
            System.out.println(fileName + ": Parse error: " + e);
            doc = null;
        }
        return doc;
    }

    /**
     *Gets text data from a particular tag.
     * @param doc the document
     * @param tagName the tag name
     * @return the text from the tag
     */
    public String getTagDataFromDocument(Document doc, String tagName) {
        NodeList elementList = doc.getElementsByTagName(tagName);
        String str = null;
        if (elementList.getLength() != 0) {
            if (hasNodeValue(elementList.item(0))) {

                str = getNodeValue(elementList.item(0));
                return str;

            } else
                str = ("");
            return str;
        } else
            str = ("");
        return str;
    }

    public String getNodeValue(Node node) {
        if (hasNodeValue(node)) {
            return node.getFirstChild().getNodeValue();
        } else {
            return "";
        }
    }


    public boolean hasNodeValue(Node node) {
        if (node.getFirstChild() != null) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Saves a xml file represented by a xml document. The name of the xml file is the name of the document.
     * @param doc the document to save
     * @param fName the name of the file to save the data,
     * the path depends on the member variable globalPath of the actual controller
     * @see ReForm
     */
    public boolean saveXMLFile(Document doc, String ID, String wdir) {

        try {

            String fileName = wdir + File.separator + ID + ".xml";

            System.out.println("Speichern der Datei " + fileName);
            FileOutputStream out = new FileOutputStream(fileName);
            XMLSerializer serializer = new XMLSerializer(out, null);
            try {
                serializer.serialize(doc);
                out.flush();
                out.close();
                System.out.println("...erfolgreich.");
                return true;
            } catch (Exception e) {
                System.out.println("Document nicht vorhanden:");
                e.printStackTrace();
                return false;
            }
        } catch (IOException e) {
            System.out.println("Datei kann nicht geschrieben werden:");
            e.printStackTrace();
            return false;

        }
    }


    public boolean checkXMLDoc(Document doc, XmlPersonTag pTag) {

        Element root = doc.getDocumentElement();
        NodeList idTag = doc.getElementsByTagName(pTag.getIDTag());

        // System.out.println("XML-Documentname: " + root.getNodeName());

        if (!root.getNodeName().equals(pTag.getRootTag())) {

            System.out.println("Error RootTag: " + root.getNodeName());
            return false;
        }

        if (idTag.getLength() != 1) {

            System.out.println("ID not existing...");
            return false;
        }

        //  System.out.println("ID: " + idTag.item(0).getFirstChild().getNodeValue());
        return true;

    }

    public String checkSingeFile(File file, XmlPersonTag pTag) {


        Document doc = this.parseXMLFile(file.toString());

        if (doc == null) {


            System.out.println("errorParser");
            return "errorParser";
        }

        if (!checkXMLDoc(doc, pTag)) {
            System.out.println("errorTag");
            return "errorTag";
        }

        this.singleFileDoc = doc;

        System.out.println("ok");
        return "OK";
    }

    public Person getDataFromDocument(XmlPersonTag pTag) {

        Document doc = this.singleFileDoc;
        Person person = new Person();

        person.setPersonId(getTagDataFromDocument(doc, pTag.getIDTag()));
        person.setGroup(getTagDataFromDocument(doc, pTag.getGroupTag()));
        person.setFirstName(getTagDataFromDocument(doc, pTag.getFirstNameTag()));
        person.setLastName(getTagDataFromDocument(doc, pTag.getLastNameTag()));
        person.setStreet(getTagDataFromDocument(doc, pTag.getStreetTag()));
        person.setCity(getTagDataFromDocument(doc, pTag.getCityTag()));
        person.setZip(getTagDataFromDocument(doc, pTag.getZipTag()));
        person.setState(getTagDataFromDocument(doc, pTag.getStateTag()));
        person.setCountry(getTagDataFromDocument(doc, pTag.getCountryTag()));

        person.setGender(getTagDataFromDocument(doc, pTag.getGenderTag()));
        person.setBirth(getTagDataFromDocument(doc, pTag.getDateOfBirthTag()));

        person.setHomeTel(getTagDataFromDocument(doc, pTag.getHomeTelTag()));
        person.setWorkTel(getTagDataFromDocument(doc, pTag.getWorkTelTag()));
        person.setCellTel(getTagDataFromDocument(doc, pTag.getCellTag()));
        person.setFax(getTagDataFromDocument(doc, pTag.getFaxTag()));
        person.setEmail(getTagDataFromDocument(doc, pTag.getEmailTag()));
        person.setWebpage(getTagDataFromDocument(doc, pTag.getWebpageTag()));


        return person;

    }

    /** Creates a new Person document and save it to file. */
    public boolean setPersonDataToDocument(Person p, XmlPersonTag pTag, String wdir) {

        Document doc = new DocumentImpl();
        Element root = doc.createElement(pTag.getRootTag());
        doc.appendChild(root);

        Element idTag = doc.createElement(pTag.getIDTag());
        Element groupTag = doc.createElement(pTag.getGroupTag());
        Element lastNameTag = doc.createElement(pTag.getLastNameTag());
        Element firstNameTag = doc.createElement(pTag.getFirstNameTag());
        Element genderTag = doc.createElement(pTag.getGenderTag());
        Element birthdayTag = doc.createElement(pTag.getDateOfBirthTag());

        if (p.getPersonId() != null) idTag.appendChild(doc.createTextNode(p.getPersonId()));
        if (p.getGroup() != null) groupTag.appendChild(doc.createTextNode(p.getGroup()));
        if (p.getLastName() != null) lastNameTag.appendChild(doc.createTextNode(p.getLastName()));
        if (p.getFirstName() != null) firstNameTag.appendChild(doc.createTextNode(p.getFirstName()));
        if (p.getGender() != null) genderTag.appendChild(doc.createTextNode(p.getGender()));
        if (p.getBirth() != null) birthdayTag.appendChild(doc.createTextNode(p.getBirth()));

        Element addressTag = doc.createElement(pTag.getAddressTag());
        Element addressStreetTag = doc.createElement(pTag.getStreetTag());
        Element addressZipTag = doc.createElement(pTag.getZipTag());
        Element addressCityTag = doc.createElement(pTag.getCityTag());
        Element addressStateTag = doc.createElement(pTag.getStateTag());
        Element addressCountryTag = doc.createElement(pTag.getCountryTag());

        addressTag.appendChild(addressStreetTag);
        addressTag.appendChild(addressZipTag);
        addressTag.appendChild(addressCityTag);
        addressTag.appendChild(addressStateTag);
        addressTag.appendChild(addressCountryTag);

        if (p.getStreet() != null) addressStreetTag.appendChild(doc.createTextNode(p.getStreet()));
        if (p.getZip() != null) addressZipTag.appendChild(doc.createTextNode(p.getZip()));
        if (p.getCity() != null) addressCityTag.appendChild(doc.createTextNode(p.getCity()));
        if (p.getState() != null) addressStateTag.appendChild(doc.createTextNode(p.getState()));
        if (p.getCountry() != null) addressCountryTag.appendChild(doc.createTextNode(p.getCountry()));


        Element contactTag = doc.createElement(pTag.getContactTag());
        Element contactHomeTelTag = doc.createElement(pTag.getHomeTelTag());
        Element contactWorkTelTag = doc.createElement(pTag.getWorkTelTag());
        Element contactFaxTag = doc.createElement(pTag.getFaxTag());
        Element contactCellTag = doc.createElement(pTag.getCellTag());
        Element contactEmailTag = doc.createElement(pTag.getEmailTag());
        Element contactHomepageTag = doc.createElement(pTag.getWebpageTag());

        contactTag.appendChild(contactHomeTelTag);
        contactTag.appendChild(contactWorkTelTag);
        contactTag.appendChild(contactFaxTag);
        contactTag.appendChild(contactCellTag);
        contactTag.appendChild(contactEmailTag);
        contactTag.appendChild(contactHomepageTag);


        if (p.getHomeTel() != null) contactHomeTelTag.appendChild(doc.createTextNode(p.getHomeTel()));
        if (p.getWorkTel() != null) contactWorkTelTag.appendChild(doc.createTextNode(p.getWorkTel()));
        if (p.getFax() != null) contactFaxTag.appendChild(doc.createTextNode(p.getFax()));
        if (p.getCellTel() != null) contactCellTag.appendChild(doc.createTextNode(p.getCellTel()));
        if (p.getEmail() != null) contactEmailTag.appendChild(doc.createTextNode(p.getEmail()));
        if (p.getWebpage() != null) contactHomepageTag.appendChild(doc.createTextNode(p.getWebpage()));


        root.appendChild(idTag);
        root.appendChild(groupTag);
        root.appendChild(lastNameTag);
        root.appendChild(firstNameTag);
        root.appendChild(genderTag);
        root.appendChild(birthdayTag);
        root.appendChild(addressTag);
        root.appendChild(contactTag);


        if (this.saveXMLFile(doc, p.getPersonId(), wdir)) {
            return true;
        } else
            return false;


    }


    public void setNodeValue(NodeList node, Document doc, String value) {


        if (getNodeValue(node.item(0)).equals("")) {

            node.item(0).appendChild(doc.createTextNode(value));
            System.out.println(node.item(0).getNodeName() + ": " + node.item(0).getFirstChild().getNodeValue());
        } else {

            node.item(0).getFirstChild().setNodeValue(value);
            System.out.println(node.item(0).getNodeName() + ": " + node.item(0).getFirstChild().getNodeValue());
        }


    }

    /** update a xml file ..edit. */
    public boolean editXmlFile(Person p, String wdir, XmlPersonTag pTag) {


        File file = new File(wdir + File.separator + p.getPersonId() + ".xml");

        if (!file.isFile()) {

            System.out.println("File not existing: " + file);
            return false;
        }

        Document doc = this.parseXMLFile(file.toString());
        Element root = doc.getDocumentElement();


        // NodeList idTag = doc.getElementsByTagName(ResAdmin.XML_ID_TAG);
        NodeList groupTag = doc.getElementsByTagName(pTag.getGroupTag());
        NodeList lastNameTag = doc.getElementsByTagName(pTag.getLastNameTag());
        NodeList firstNameTag = doc.getElementsByTagName(pTag.getFirstNameTag());
        NodeList genderTag = doc.getElementsByTagName(pTag.getGenderTag());
        NodeList dateOfBirthTag = doc.getElementsByTagName(pTag.getDateOfBirthTag());


        if (groupTag.getLength() == 1) setNodeValue(groupTag, doc, p.getGroup());
        if (groupTag.getLength() != 1) {

            Element groupElement = doc.createElement(pTag.getGroupTag());
            groupElement.appendChild(doc.createTextNode(p.getGroup()));
            root.appendChild(groupElement);
        }


        //LastName

        if (lastNameTag.getLength() == 1) setNodeValue(lastNameTag, doc, p.getLastName());
        if (lastNameTag.getLength() != 1) {

            Element lastNameElement = doc.createElement(pTag.getLastNameTag());
            lastNameElement.appendChild(doc.createTextNode(p.getGroup()));
            root.appendChild(lastNameElement);
        }



        //firstName

        if (firstNameTag.getLength() == 1) setNodeValue(firstNameTag, doc, p.getFirstName());
        if (firstNameTag.getLength() != 1) {

            Element firstNameElement = doc.createElement(pTag.getFirstNameTag());
            firstNameElement.appendChild(doc.createTextNode(p.getFirstName()));
            root.appendChild(firstNameElement);
        }

        //Gender

        if (genderTag.getLength() == 1) setNodeValue(genderTag, doc, p.getGender());
        if (genderTag.getLength() != 1) {

            Element genderElement = doc.createElement(pTag.getGenderTag());
            genderElement.appendChild(doc.createTextNode(p.getGender()));
            root.appendChild(genderElement);
        }

        //DateOfBirth

        if (dateOfBirthTag.getLength() == 1) setNodeValue(dateOfBirthTag, doc, p.getBirth());
        if (dateOfBirthTag.getLength() != 1) {

            Element dateOfBirthElement = doc.createElement(pTag.getDateOfBirthTag());
            dateOfBirthElement.appendChild(doc.createTextNode(p.getBirth()));
            root.appendChild(dateOfBirthElement);
        }

        //Address Tags
        NodeList addressTag = doc.getElementsByTagName(pTag.getAddressTag());
        NodeList addressStreetTag = doc.getElementsByTagName(pTag.getStreetTag());
        NodeList addressZipTag = doc.getElementsByTagName(pTag.getZipTag());
        NodeList addressCityTag = doc.getElementsByTagName(pTag.getCityTag());
        NodeList addressStateTag = doc.getElementsByTagName(pTag.getStateTag());
        NodeList addressCountryTag = doc.getElementsByTagName(pTag.getCountryTag());

        Element addressElement = doc.createElement(pTag.getAddressTag());

        if (addressTag.getLength() != 1) {

            root.appendChild(addressElement);
        }

        //Street

        if (addressStreetTag.getLength() == 1) setNodeValue(addressStreetTag, doc, p.getStreet());
        if (addressStreetTag.getLength() != 1) {

            Element streetElement = doc.createElement(pTag.getStreetTag());
            streetElement.appendChild(doc.createTextNode(p.getStreet()));
            addressElement.appendChild(streetElement);
        }


        //Zip

        if (addressZipTag.getLength() == 1) setNodeValue(addressZipTag, doc, p.getZip());
        if (addressZipTag.getLength() != 1) {

            Element zipElement = doc.createElement(pTag.getZipTag());
            zipElement.appendChild(doc.createTextNode(p.getZip()));
            addressElement.appendChild(zipElement);
        }


        //city

        if (addressCityTag.getLength() == 1) setNodeValue(addressCityTag, doc, p.getCity());
        if (addressCityTag.getLength() != 1) {

            Element CityElement = doc.createElement(pTag.getCityTag());
            CityElement.appendChild(doc.createTextNode(p.getCity()));
            addressElement.appendChild(CityElement);
        }


        //state

        if (addressStateTag.getLength() == 1) setNodeValue(addressStateTag, doc, p.getState());
        if (addressStateTag.getLength() != 1) {

            Element stateElement = doc.createElement(pTag.getStateTag());
            stateElement.appendChild(doc.createTextNode(p.getState()));
            addressElement.appendChild(stateElement);
        }


        //country

        if (addressCountryTag.getLength() == 1) setNodeValue(addressCountryTag, doc, p.getCountry());
        if (addressCountryTag.getLength() != 1) {

            Element countryElement = doc.createElement(pTag.getCountryTag());
            countryElement.appendChild(doc.createTextNode(p.getCountry()));
            addressElement.appendChild(countryElement);
        }



        //Contact Tags
        NodeList contactTag = doc.getElementsByTagName(pTag.getContactTag());
        NodeList contactHomeTelNode = doc.getElementsByTagName(pTag.getHomeTelTag());
        NodeList contactWorkTelNode = doc.getElementsByTagName(pTag.getWorkTelTag());
        NodeList contactFaxNode = doc.getElementsByTagName(pTag.getFaxTag());
        NodeList contactCellNode = doc.getElementsByTagName(pTag.getCellTag());
        NodeList contactEmailNode = doc.getElementsByTagName(pTag.getEmailTag());
        NodeList contactHomepageNode = doc.getElementsByTagName(pTag.getWebpageTag());

        Element contactElement = doc.createElement(pTag.getContactTag());


        if (contactTag.getLength() != 1) {


            root.appendChild(contactElement);
        }


        //HomeTel

        if (contactHomeTelNode.getLength() == 1) setNodeValue(contactHomeTelNode, doc, p.getHomeTel());
        if (contactHomeTelNode.getLength() != 1) {

            Element homeTelElement = doc.createElement(pTag.getHomeTelTag());
            homeTelElement.appendChild(doc.createTextNode(p.getHomeTel()));
            contactElement.appendChild(homeTelElement);
        }

        //WorkTel
        if (contactWorkTelNode.getLength() == 1) setNodeValue(contactWorkTelNode, doc, p.getWorkTel());
        if (contactWorkTelNode.getLength() != 1) {

            Element workTelElement = doc.createElement(pTag.getWorkTelTag());
            workTelElement.appendChild(doc.createTextNode(p.getWorkTel()));
            contactElement.appendChild(workTelElement);
        }

        //Fax
        if (contactFaxNode.getLength() == 1) setNodeValue(contactFaxNode, doc, p.getFax());
        if (contactFaxNode.getLength() != 1) {

            Element faxElement = doc.createElement(pTag.getFaxTag());
            faxElement.appendChild(doc.createTextNode(p.getFax()));
            contactElement.appendChild(faxElement);
        }

        //CellTel
        if (contactCellNode.getLength() == 1) setNodeValue(contactCellNode, doc, p.getCellTel());
        if (contactCellNode.getLength() != 1) {

            Element cellElement = doc.createElement(pTag.getCellTag());
            cellElement.appendChild(doc.createTextNode(p.getCellTel()));
            contactElement.appendChild(cellElement);
        }

        //Email
        if (contactEmailNode.getLength() == 1) setNodeValue(contactEmailNode, doc, p.getEmail());
        if (contactEmailNode.getLength() != 1) {

            Element emailElement = doc.createElement(pTag.getEmailTag());
            emailElement.appendChild(doc.createTextNode(p.getEmail()));
            contactElement.appendChild(emailElement);
        }

        //Webpage
        if (contactHomepageNode.getLength() == 1) setNodeValue(contactHomepageNode, doc, p.getWebpage());
        if (contactHomepageNode.getLength() != 1) {

            Element homepageElement = doc.createElement(pTag.getWebpageTag());
            homepageElement.appendChild(doc.createTextNode(p.getWebpage()));
            contactElement.appendChild(homepageElement);
        }

        this.saveXMLFile(doc, p.getPersonId(), wdir);

        return true;


    }


}
