/*
 * $RCSfile: CustomFileFilter.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.resadmin.utils;

import java.io.FileFilter;
import java.io.File;

/**
 * This class represents the resadmin view.
 *
 * @version $Revision: 1.1 $ $Date: 2003/02/20 13:15:19 $ $Author: chrissy $
 * @author Kumanan Kanagasabapathy <kumanan@uni.de>
 */

public class CustomFileFilter implements FileFilter {

    String extension, description;

    public CustomFileFilter()
    {
        super();
        extension = "xml";

    }

    public boolean accept(File file){

        if(file.isDirectory())
        return false;

        String fileName = file.getName();
        int i = fileName.lastIndexOf('.');

        if (i> 0 && i < fileName.length() -1 ){

            String ext = fileName.substring(i+1).toLowerCase();
            if(ext.equals(extension))

                return true;
            else
             return false;
        }

        return false;
    }
}
