/*
 * $RCSfile: ResAdminTableModel.java,v $FILENAME,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.application.healthcare.resadmin.table;

import javax.swing.table.TableModel;
import javax.swing.event.*;
import java.util.ArrayList;
import java.util.Vector;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;




public class ResAdminTableModel  implements TableModel {

    public String[] colNames;
     //   public static String[] colNames; //={
/*            "ID",
            "LastName",
            "FirstName",
            "City",
            "HomeTel",
            "Email"
        };
  */
        public static final Class[] colClasses ={
            String.class,
            String.class,
            String.class,
            String.class,
            String.class,
            String.class
        };

        public static final int
        ID_COL          = 0,
        LastName_COL    = 1,
        FirstName_COL   = 2,
        City_COL        = 3,
        HomeTel_COL     = 4,
        Email_COL       = 5;


        //used to hold a list of TableModelListeners
        protected java.util.List tableModelListeners = new ArrayList();
        protected java.util.List tableMouseListeners = new ArrayList();

       // protected java.util.List data = new ArrayList();
    protected java.util.Vector data = new Vector();

        public ResAdminTableModel(){

              // colNames = colname;

        }

        public void setColnames(String[] colname){

              colNames = colname;
            //  this.s

        }



        /**
         Return the number of columns for the model.

         @return    the number of columns in the model
        */
        public int getColumnCount() {
            return colClasses.length;
        }
        /**
         Return the number of persons in an addressbook

         @return    the number or rows in the model
        */
        public int getRowCount() {
            return   data.size();

                    //super.getRowCount(); //data.size();
        }

        /**
         Return data given its location

         @param	    r   the row whose value is to be looked up
         @param	    c 	the column whose value is to be looked up
         @return	the value Object at the specified cell
        */
        public Object getValueAt(int r, int c) {

            //must get row first
            TPerson person = (TPerson)data.get(r);
            //must get value for column in this row

            switch ( c ) {
            case ID_COL:
                return person.getPersonId();
            case LastName_COL:
                return person.getLastName();
            case FirstName_COL:
                return person.getFirstName();
            case City_COL:
                return person.getCity();
            case HomeTel_COL:
                return person.getHomeTel();
            case Email_COL:
                return person.getEmail();
            }

            return null;

        }

        /**
         Return the name of column for the table.

         @param	    c   the index of column
         @return    the name of the column
        */
        public String getColumnName(int c) {
            return colNames[ c ];
        }
        /**
         Return column class

         @param      c the index of column
         @return    the common ancestor class of the object values in the model.
        */
        public Class getColumnClass(int c) {
            return colClasses[ c ];
        }

        /**
         Return false - table is not editable

         @param	    r	the row whose value is to be looked up
         @param	    c	the column whose value is to be looked up
         @return	true if the cell is editable.
        */
        public boolean isCellEditable(int r, int c) {
            return false;
        }

        /**
         This method is not implemented, because the table is not editable.

         @param	    value		 the new value
         @param	    r	 the row whose value is to be changed
         @param	    c 	 the column whose value is to be changed
        */
        public void setValueAt(Object value, int r, int c) {
        }

        public void addMouseListener(MouseListener l ) {

             if ( !tableMouseListeners.contains(l) ) {
                tableMouseListeners.add(l);
            }
        }
        /**
         Add a listener to the list that's notified each time a change
         to the data model occurs.

         @param	l		the TableModelListener
        */
        public void addTableModelListener(TableModelListener l) {
            //add a listener only if the listener is not already registered
            if ( !tableModelListeners.contains(l) ) {
                tableModelListeners.add(l);
            }
        }
        /**
         Remove a listener from the list that's notified each time a
         change to the data model occurs.

         @param	l		the TableModelListener
        */
        public void removeTableModelListener(TableModelListener l) {
            //remove a listener only if the listener is already registered
            if ( tableModelListeners.contains(l) ) {
                tableModelListeners.remove(l);
            }
        }


        //
        // Manipulation of AddressBook
        //

        /**
         Add a person to the address book

         @param     p   a Person object
         */
        public void add(TPerson p){
          //  data.add(p);
             data.addElement(p);
             fireContentsChanged();
        }

     //   public void add(TPerson p)
        /**
         Remove a person given a location of the person
         in the address book

         @param     i   a location of person
         */
        public void remove(int i){
            data.remove(i);

            //refresh table view
            fireContentsChanged();
        }

        public void removeAll(){

        //    data.removeAllElements();
            //refresh table view
            fireContentsChanged();
        }



        public void clear(){

            data.clear();
        }
        /**
         Set a Person object given a location of the person
         in the address book

         @param     i   a location of person
         @param     p   a Person object
         */
        public void set(int i, TPerson p){

            data.set(i, p);

            //refresh table view
            fireContentsChanged();
        }

        /**
         Return a Person Object given an location
         of the person in the address book

         @param     i   a location of person
         @return    a Person object
         */
        public TPerson get(int i){
            return (TPerson)data.get(i);
        }

        /**
         Return the number of person in the address book

         @return    an int number
         */
        public int size(){
            return data.size();
        }


        //
        // Utility CONTROLLER method
        //

        /**
         Save address book as a XML file
         */
        public void saveFile(){

            //save address book information to an xml file
           // IoUtils.saveAddressBook(data);

        }


        /**
         Underlying personal information has changed
         Create a TableModel event
         Notify all registerd listeners
         */

        public void fireContentsChanged()
        {
            TableModelListener ldl; //temp var


            TableModelEvent e = new TableModelEvent(this);

            for(int i=0; i<tableModelListeners.size(); i++){
                ldl = (TableModelListener)tableModelListeners.get(i);
                ldl.tableChanged(e);

            }



        }//end method
        public void mouseClicked(MouseEvent event) {
                // super.mouseClicked(event);
              // TableColumnModel colModel = getColumnModel();
           //  ResAdminModel model = (ResAdminModel) getModel();
             //   ResAdminView view = (ResAdminView) getView();
            TableModelListener ldl;
              TableModelEvent e = new TableModelEvent(this);
            for(int i =0; i < tableModelListeners.size(); i++){
            ldl = (TableModelListener)tableModelListeners. get(i);


             // System.out.println(event..getColumn());
            }
             // javax.swing.table.TableColumnModel colModel = getCoumModel();


            }


}
