/*
 * $RCSfile: ResAdminView.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.resadmin;

import org.resmedicinae.application.healthcare.resadmin.data.Person;
import org.resmedicinae.application.healthcare.resadmin.dialog.XmlStructure;
import org.resmedicinae.application.healthcare.resadmin.table.PrintableTable;
import org.resmedicinae.application.healthcare.resadmin.table.ResAdminTableModel;
import org.resmedicinae.application.healthcare.resadmin.utils.ResAdminFileFilter;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.ImageIcon;
import java.awt.*;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 * This class represents the resadmin view.
 *
 * @version $Revision: 1.1 $ $Date: 2003/02/20 13:15:18 $ $Author: chrissy $
 * @author Kumanan Kanagasabapathy <kumanan@uni.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ResAdminView extends SwingView {

    //Variables for Locale
    private Locale locale = null;

    //Menu Variables
    private ResMenuBar menuBar;

    private ResMenu menuFile;
    private ResMenuItem menuFileNew;
    private ResMenuItem menuFileOpen;
    private ResMenuItem menuFileOpenDir;
    private ResMenuItem menuFileReopen;
    private ResMenuItem menuFilePrint;
    private ResMenuItem menuFileExit;

    private ResMenu menuEdit;
    private ResMenuItem menuEditAdd;
    private ResMenuItem menuEditEdit;
    private ResMenuItem menuEditView;
    private ResMenuItem menuEditDelete;

    private ResMenu menuSetting;
    private ResMenu subMenuLanguage;

    private ResMenuItem langGerman;
    private ResMenuItem langEnglish;
    private ResMenuItem langTamil;

    private ResMenuItem menuSettingXmlStr;
    private ResMenuItem menuSettingOption;

    private ResMenu menuHelp;
    private ResMenuItem menuHelpContex;
    private ResMenuItem menuHelpAbout;

    //Variables for ToolBar
    private ResToolBar toolBar;
    private ResButton toolBarNewButton;
    private ResButton toolBarViewButton;
    private ResButton toolBarEditButton;
    private ResButton toolBarDeleteButton;
    private ResButton toolBarSearchButton;
    private ResButton toolBarPrintButton;

    private ImageIcon addIcon;
    private ImageIcon editIcon;
    private ImageIcon viewIcon;
    private ImageIcon searchIcon;
    private ImageIcon deleteIcon;
    private ImageIcon printIcon;

    //Variables for main DataSheet

    private ResLabel groupLabel;
    private ResLabel idLabel;

    private ResLabel blank1Label;
    private ResLabel blank2Label;
    private ResLabel blank3Label;
    private ResLabel blank4Label;

    private ResLabel firstNameLabel;
    private ResLabel lastNameLabel;
    private ResLabel streetLabel;
    private ResLabel zipLabel;
    private ResLabel cityLabel;
    private ResLabel stateLabel;
    private ResLabel countryLabel;

    private ResLabel genderLabel;
    private String labelMale = null;
    private String labelFemale = null;
    private ResLabel dateofBirthLabel;

    private ResLabel homeTelLabel;
    private ResLabel workTelLabel;
    private ResLabel handyLabel;
    private ResLabel faxLabel;
    private ResLabel emailLabel;
    private ResLabel webLabel;

    // Fields

    private ResTextField groupTextField;
    private ResTextField idTextField;

    private ResTextField firstNameTextField;
    private ResTextField lastNameTextField;
    private ResTextField streetTextField;
    private ResTextField zipTextField;
    private ResTextField cityTextField;
    private ResTextField stateTextField;
    private ResTextField countryTextField;

    private ResComboBox genderComboBox;

    private ResTextField genderTextField;
    private ResTextField dateofBirthTextField;

    private ResTextField homeTelTextField;
    private ResTextField workTelTextField;
    private ResTextField handyTextField;
    private ResTextField faxTextField;
    private ResTextField emailTextField;
    private ResTextField webTextField;

    //
    private GridBagLayout gridBagLayoutStd;
    private GridBagConstraints constraintsStd;

    private GridBagLayout gridBagLayoutExt;
    private GridBagConstraints constraintsExt;

    private GridBagLayout gridBagLayoutMain;
    private GridBagConstraints constraintsMain;

    private ResPanel dataStdPanel;
    private ResPanel dataExtPanel;
    private ResPanel mainPanel;
    //

    //Table
    private PrintableTable printableTable;

    // new Data Buttons
    protected ResButton newDataCancelButton;
    protected ResButton newDataClearButton;
    protected ResButton newDataSaveButton;
    protected ResPanel newDataButtonPanel;

    // editData Buttons
    protected ResButton editDataCancelButton;
    protected ResButton editDataClearButton;
    protected ResButton editDataSaveButton;
    protected ResButton editDataResetButton;
    protected ResPanel editDataButtonPanel;

    // search Buttons
    protected ResButton searchDataClearButton;
    protected ResButton searchDataCancelButton;
    protected ResButton searchDataSearchButton;
    protected ResButton searchDataAdvSearchButton;
    protected ResPanel searchDataButtonPanel;

    //FileNew Dialog
    private String newFileDialogTitle;
    private String newFileDialogApproveButtonText;
    //FileOpen Dialog
    private String openFileDialogTitle;
    private String openFileDialogApproveButtonText;
    //FileOpenDir Dialog
    private String openDirFileDialogTitle;
    private String openDirFileDialogApproveButtonText;
    // private String openFileDialogApproveButtonText;

    //StautsBar
    protected ResTextField statusDateValue;
    protected ResTextField statusMessageValue;
    protected ResTextField statusTotalRowValue;

    //MessageDialog Strings
    protected String messageDialogOK;
    protected String messageDialogYes;
    protected String messageDialogNO;
    protected String messageDialogTitleError;
    protected String messageDialogTitleInfo;
    protected String messageDialogSelectRowText;
    protected String messageDialogFileSavedText;
    protected String messageDialogFillFieldsText;
    protected String messageDialogDeleteText;

    //Fonts
    protected Font fontBigBold;
    protected Font fontSmall;
    protected Font fontMedium;
    protected Font fontBig;
    protected Font BigBold;

    protected Font labelFont;
    protected Font fieldFont;
    protected Font menuFont;



    //XmlStructureDialog
    private XmlStructure xmlStrDialog;

    public void initialize() {
        try {


            //  this.populate();
            super.initialize();


            this.locale = new Locale("en", "US");
            super.setTitle("ResAdmin");
            setResizable(true);

            setWindowBounds(createWindowBounds());

            setLayout(getLayoutManager());

            // setMenuBar(createMenuBar());
            // setToolBar(createToolBar());
            // setStatusBar(createStatusBar());

            // add(getToolBar(), BorderLayout.NORTH);
            add(createMainPanel(), BorderLayout.CENTER);
            // add(createStatusBarr(), BorderLayout.CENTER);
             add(createStatus(), BorderLayout.SOUTH);
            this.createDataPanelButtons();

            this.populate();
            this.changeDataButtonPanel("view");

        } catch (Exception e) {

            System.out.println("Fehler: " + e);
        }
    }

    /**
      * Returns the title.
      *
      * @return the title
      */
     public String getTitle() {

         return super.getTitle();
     }

     /**
      * Sets the title.
      *
      * @param title the title
      */
     public void setTitle(String title) {

         super.setTitle(title);
     }

     /**
      * Creates a title.
      *
      * @return the title
      */
     public String createTitle() {

         return "Res Medicinae";
     }


    /*
     * This Methode create the MenuBar
     */
    public ResMenuBar createMenuBar() {

        menuBar = new ResMenuBar();

        //Menu File
        menuFile = new ResMenu();

        menuFileNew = new ResMenuItem();
        menuFileNew.setActionCommand(ResAdmin.FILE_NEW);
        menuFileNew.addActionListener((ResAdmin) getController());

        menuFileOpen = new ResMenuItem();
        menuFileOpen.setActionCommand(ResAdmin.FILE_OPEN_FILE);
        menuFileOpen.addActionListener((ResAdmin) getController());

        menuFileOpenDir = new ResMenuItem();
        menuFileOpenDir.setActionCommand(ResAdmin.FILE_OPEN_DIR);
        menuFileOpenDir.addActionListener((ResAdmin) getController());

        menuFileReopen = new ResMenuItem();
        menuFileReopen.setActionCommand(ResAdmin.FILE_REOPEN);
        menuFileReopen.addActionListener((ResAdmin) getController());

        menuFilePrint = new ResMenuItem();
        menuFilePrint.setActionCommand(ResAdmin.FILE_PRINT);
        menuFilePrint.addActionListener((ResAdmin) getController());

        menuFileExit = new ResMenuItem();
        menuFileExit.setActionCommand(ResAdmin.FILE_EXIT);
        menuFileExit.addActionListener((ResAdmin) getController());

        menuFile.add(menuFileNew);
        menuFile.add(menuFileOpen);
        menuFile.add(menuFileOpenDir);
        menuFile.add(menuFileReopen);
        menuFile.addSeparator();
        menuFile.add(menuFilePrint);
        menuFile.addSeparator();
        menuFile.add(menuFileExit);

        //Menu File end

        //Menu Edit
        menuEdit = new ResMenu();

        menuEditAdd = new ResMenuItem();
        menuEditAdd.setActionCommand(ResAdmin.DATA_NEW_BUTTON_ID);
        menuEditAdd.addActionListener((ResAdmin) getController());

        menuEditEdit = new ResMenuItem();
        menuEditEdit.setActionCommand(ResAdmin.DATA_EDIT_BUTTON_ID);
        menuEditEdit.addActionListener((ResAdmin) getController());

        menuEditView = new ResMenuItem();
        menuEditView.setActionCommand(ResAdmin.DATA_VIEW_BUTTON_ID);
        menuEditView.addActionListener((ResAdmin) getController());

        menuEditDelete = new ResMenuItem();
        menuEditDelete.setActionCommand(ResAdmin.DATA_DELETE_BUTTON_ID);
        menuEditDelete.addActionListener((ResAdmin) getController());

        menuEdit.add(menuEditAdd);
        menuEdit.add(menuEditView);
        menuEdit.add(menuEditEdit);
        menuEdit.add(menuEditDelete);

        //Menu edit end

        //Menu Setting
        menuSetting = new ResMenu();

        subMenuLanguage = new ResMenu();
        subMenuLanguage.setActionCommand(ResAdmin.SETTING_LANGUAGE);
        subMenuLanguage.addActionListener((ResAdmin) getController());

        langGerman = new ResMenuItem();
        langGerman.setActionCommand(ResAdmin.SETTING_LANGUAGE_GERMAN);
        langGerman.addActionListener((ResAdmin) getController());

        langEnglish = new ResMenuItem();
        langEnglish.setActionCommand(ResAdmin.SETTING_LANGUAGE_ENGLISH);
        langEnglish.addActionListener((ResAdmin) getController());

        langTamil = new ResMenuItem();
        langTamil.setActionCommand(ResAdmin.SETTING_LANGUAGE_TAMIL);
        langTamil.addActionListener((ResAdmin) getController());

        subMenuLanguage.add(langEnglish);
        subMenuLanguage.add(langGerman);
        subMenuLanguage.add(langTamil);

        menuSettingXmlStr = new ResMenuItem();
        menuSettingXmlStr.setActionCommand(ResAdmin.SETTING_XMLSTRUCTURE);
        menuSettingXmlStr.addActionListener((ResAdmin) getController());

        menuSettingOption = new ResMenuItem();
        menuSettingOption.setActionCommand(ResAdmin.SETTING_OPTION);
        menuSettingOption.addActionListener((ResAdmin) getController());

        menuSetting.add(subMenuLanguage);
        menuSetting.add(menuSettingXmlStr);
        menuSetting.addSeparator();
        menuSetting.add(menuSettingOption);

        menuHelp = new ResMenu();

        menuHelpAbout = new ResMenuItem();
        menuHelpAbout.setActionCommand(ResAdmin.HELP_ABOUT);
        menuHelpAbout.addActionListener((ResAdmin) getController());

        menuHelpContex = new ResMenuItem();
        menuHelpContex.setActionCommand(ResAdmin.HELP_CONTEXT);
        menuHelpContex.addActionListener((ResAdmin) getController());

        menuHelp.add(menuHelpAbout);
        menuHelp.add(menuHelpContex);

        menuBar.add(menuFile);
        menuBar.add(menuEdit);
        menuBar.add(menuSetting);
        menuBar.add(menuHelp);

        return menuBar;
    }

    /*
     * This Methode create the MenuBar
     */
    public ResToolBar createToolBar() {

        toolBar = new ResToolBar();

        toolBarNewButton = new ResButton();
        toolBarNewButton.setVerticalTextPosition(AbstractButton.BOTTOM);
        toolBarNewButton.setHorizontalTextPosition(AbstractButton.CENTER);
        toolBarNewButton.setActionCommand(ResAdmin.DATA_NEW_BUTTON_ID);
        toolBarNewButton.addActionListener((ResAdmin) getController());

        toolBarViewButton = new ResButton();
        toolBarViewButton.setVerticalTextPosition(AbstractButton.BOTTOM);
        toolBarViewButton.setHorizontalTextPosition(AbstractButton.CENTER);
        toolBarViewButton.setActionCommand(ResAdmin.DATA_VIEW_BUTTON_ID);
        toolBarViewButton.addActionListener((ResAdmin) getController());

        toolBarEditButton = new ResButton();
        toolBarEditButton.setVerticalTextPosition(AbstractButton.BOTTOM);
        toolBarEditButton.setHorizontalTextPosition(AbstractButton.CENTER);
        toolBarEditButton.setActionCommand(ResAdmin.DATA_EDIT_BUTTON_ID);
        toolBarEditButton.addActionListener((ResAdmin) getController());

        toolBarDeleteButton = new ResButton();
        toolBarDeleteButton.setVerticalTextPosition(AbstractButton.BOTTOM);
        toolBarDeleteButton.setHorizontalTextPosition(AbstractButton.CENTER);
        toolBarDeleteButton.setActionCommand(ResAdmin.DATA_DELETE_BUTTON_ID);
        toolBarDeleteButton.addActionListener((ResAdmin) getController());

        toolBarSearchButton = new ResButton();
        toolBarSearchButton.setVerticalTextPosition(AbstractButton.BOTTOM);
        toolBarSearchButton.setHorizontalTextPosition(AbstractButton.CENTER);
        toolBarSearchButton.setActionCommand(ResAdmin.DATA_SEARCH_BUTTON_ID);
        toolBarSearchButton.addActionListener((ResAdmin) getController());

        toolBarPrintButton = new ResButton();
        toolBarPrintButton.setVerticalTextPosition(AbstractButton.BOTTOM);
        toolBarPrintButton.setHorizontalTextPosition(AbstractButton.CENTER);
        toolBarPrintButton.setActionCommand(ResAdmin.DATA_PRINT_BUTTON_ID);
        toolBarPrintButton.addActionListener((ResAdmin) getController());

        toolBar.add(toolBarNewButton);
        toolBar.add(toolBarViewButton);
        toolBar.add(toolBarEditButton);
        toolBar.addSeparator();
        toolBar.add(toolBarDeleteButton);
        toolBar.add(toolBarSearchButton);
        toolBar.add(toolBarPrintButton);

        this.setPrintButton(false);
        this.setNewButton(false);
        this.setViewButton(false);
        this.setEditButton(false);
        this.setDeleteButton(false);
        this.setSearchButton(false);
        this.menuFilePrint.setEnabled(false);

        return toolBar;
    }

    /*
     * This Methode create the StatusBar Panel
    */
    public ResPanel createStatus(){

        statusDateValue = new ResTextField();
        statusMessageValue = new ResTextField();
        statusTotalRowValue = new ResTextField();
        ResPanel statusBarPanel = new ResPanel();

        statusBarPanel.setLayout(new FlowLayout());

        statusMessageValue.setEditable(false);
        statusMessageValue.setColumns(45);

        statusDateValue.setEditable(false);
        statusDateValue.setColumns(20);

        statusTotalRowValue.setEditable(false);
        statusTotalRowValue.setColumns(4);

        statusBarPanel.add(statusMessageValue, FlowLayout.LEFT);
        statusBarPanel.add(statusDateValue, FlowLayout.CENTER );
        statusBarPanel.add(statusTotalRowValue, FlowLayout.RIGHT);

        return statusBarPanel;
    }

    public void setStatusMessage(String str){

        this.statusMessageValue.setText(str);
    }

    public void setStatusDate(String str){

        this.statusDateValue.setText(str);
    }

    public void setStatusRow(String str){

        this.statusTotalRowValue.setText(str);
    }
    /*
     * This Methode create the main ResPanel
    */
    public ResPanel createMainPanel() {

        ResPanel r = new ResPanel();

        r.setLayout(new BorderLayout());

        r.add(getToolBar(), BorderLayout.NORTH);

        JSplitPane splitPaneV = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        splitPaneV.setDividerLocation(300);
        splitPaneV.setContinuousLayout(true);
        splitPaneV.setTopComponent(createTopSplitPanel());

        splitPaneV.setBottomComponent(createBottomSplitPanel());
        splitPaneV.setOneTouchExpandable(true);

        r.add(splitPaneV);

        return r;
    }

    public ResPanel createTopSplitPanel() {

        this.createLabelNames();
        this.createTextField();

        gridBagLayoutMain = new GridBagLayout();
        constraintsMain = new GridBagConstraints();
        mainPanel = new ResPanel();

        mainPanel.setLayout(gridBagLayoutMain);
        constraintsMain.fill = GridBagConstraints.HORIZONTAL;

        constraintsMain.gridy = 0;
        constraintsMain.gridx = 0;
        constraintsMain.gridwidth = 1;
        ResPanel lStd = createLayoutStd();
        gridBagLayoutMain.setConstraints(lStd, constraintsMain);
        mainPanel.add(lStd);

        constraintsMain.gridy = 0;
        constraintsMain.gridx = 1;
        constraintsMain.gridwidth = 1;
        ResPanel lExt = createLayoutExt();
        gridBagLayoutMain.setConstraints(lExt, constraintsMain);
        mainPanel.add(lExt);

        return mainPanel;
    }

    public ResPanel createBottomSplitPanel() {

        ResPanel tablePanel = new ResPanel();
        printableTable = new PrintableTable();


        // table setting
        printableTable.setRowSelectionAllowed(true);
        printableTable.setSelectionBackground(Color.ORANGE);
       // printableTable.add
        printableTable.addMouseListener((ResAdmin) getController());
       // printableTable.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        printableTable.setColumnSelectionAllowed(false);
        printableTable.setRowSelectionAllowed(true);
       // printableTable.getSelectionModel().addListSelectionListener((ResAdmin) getController());
        printableTable.getSelectionModel().addListSelectionListener((ResAdmin) getController());

        tablePanel.setLayout(new BorderLayout());

        tablePanel.add(new ResScrollPane(printableTable), BorderLayout.CENTER);

        return tablePanel;
    }

    //Create the Labels
    public void createLabelNames() {

        blank1Label = new ResLabel();
        blank2Label = new ResLabel();
        blank3Label = new ResLabel();
        blank4Label = new ResLabel();

        idLabel = new ResLabel();
        groupLabel = new ResLabel();
        firstNameLabel = new ResLabel();
        lastNameLabel = new ResLabel();
        streetLabel = new ResLabel();
        zipLabel = new ResLabel();
        cityLabel = new ResLabel();
        stateLabel = new ResLabel();
        countryLabel = new ResLabel();
        genderLabel = new ResLabel();
        dateofBirthLabel = new ResLabel();

        homeTelLabel = new ResLabel();
        workTelLabel = new ResLabel();
        handyLabel = new ResLabel();
        faxLabel = new ResLabel();
        emailLabel = new ResLabel();
        webLabel = new ResLabel();

        blank1Label.setText("    ");
        blank2Label.setText("    ");
        blank3Label.setText("    ");
        blank4Label.setText("    ");

        groupLabel.setHorizontalAlignment(ResLabel.RIGHT);
        idLabel.setHorizontalAlignment(ResLabel.RIGHT);
        firstNameLabel.setHorizontalAlignment(ResLabel.RIGHT);
        lastNameLabel.setHorizontalAlignment(ResLabel.RIGHT);
        streetLabel.setHorizontalAlignment(ResLabel.RIGHT);
        zipLabel.setHorizontalAlignment(ResLabel.RIGHT);
        cityLabel.setHorizontalAlignment(ResLabel.RIGHT);
        stateLabel.setHorizontalAlignment(ResLabel.RIGHT);
        countryLabel.setHorizontalAlignment(ResLabel.RIGHT);
        genderLabel.setHorizontalAlignment(ResLabel.RIGHT);
        dateofBirthLabel.setHorizontalAlignment(ResLabel.RIGHT);
        homeTelLabel.setHorizontalAlignment(ResLabel.RIGHT);
        workTelLabel.setHorizontalAlignment(ResLabel.RIGHT);
        handyLabel.setHorizontalAlignment(ResLabel.RIGHT);
        faxLabel.setHorizontalAlignment(ResLabel.RIGHT);
        emailLabel.setHorizontalAlignment(ResLabel.RIGHT);
        webLabel.setHorizontalAlignment(ResLabel.RIGHT);
    }

    //Create the TextFields
    public void createTextField() {

        idTextField = new ResTextField();
        idTextField.setColumns(10);

        groupTextField = new ResTextField();
        groupTextField.setColumns(12);

        firstNameTextField = new ResTextField();
        firstNameTextField.setColumns(22);

        lastNameTextField = new ResTextField();
        lastNameTextField.setColumns(22);

        streetTextField = new ResTextField();
        streetTextField.setColumns(22);

        zipTextField = new ResTextField();
        zipTextField.setColumns(7);

        cityTextField = new ResTextField();
        cityTextField.setColumns(15);

        stateTextField = new ResTextField();
        stateTextField.setColumns(22);

        countryTextField = new ResTextField();
        countryTextField.setColumns(22);

        genderTextField = new ResTextField();
        genderTextField.setColumns(8);
        genderComboBox = new ResComboBox();
        genderComboBox.addItem(this.labelMale);
        genderComboBox.addItem(this.labelFemale);

        dateofBirthTextField = new ResTextField();
        dateofBirthTextField.setColumns(12);

        homeTelTextField = new ResTextField();
        homeTelTextField.setColumns(20);

        workTelTextField = new ResTextField();
        workTelTextField.setColumns(20);

        handyTextField = new ResTextField();
        handyTextField.setColumns(20);

        faxTextField = new ResTextField();
        faxTextField.setColumns(20);

        emailTextField = new ResTextField();
        emailTextField.setColumns(20);

        webTextField = new ResTextField();
        webTextField.setColumns(20);

        this.setFields();
    }

    public void setFieldToPlain(ResTextField field) {



        field.setBorder(BorderFactory.createEmptyBorder());
        field.setForeground(Color.BLUE);
        field.setFont(fontMedium);
        field.setEditable(false);
    }

    public ResButton getToolBarViewButton() {

        return this.toolBarViewButton;
    }

    public void setFieldToPlain() {

        Color labelNormalColor = Color.BLACK;

        this.idLabel.setForeground(labelNormalColor);
        this.firstNameLabel.setForeground(labelNormalColor);
        this.lastNameLabel.setForeground(labelNormalColor);
        this.streetLabel.setForeground(labelNormalColor);
        this.zipLabel.setForeground(labelNormalColor);
        this.cityLabel.setForeground(labelNormalColor);
        this.stateLabel.setForeground(labelNormalColor);
        this.countryLabel.setForeground(labelNormalColor);

        setFieldToPlain(this.idTextField);
        setFieldToPlain(this.groupTextField);
        setFieldToPlain(this.firstNameTextField);
        setFieldToPlain(this.lastNameTextField);
        setFieldToPlain(this.streetTextField);
        setFieldToPlain(this.zipTextField);
        setFieldToPlain(this.cityTextField);
        setFieldToPlain(this.stateTextField);
        setFieldToPlain(this.countryTextField);
        setFieldToPlain(this.genderTextField);

        setFieldToPlain(this.dateofBirthTextField);
        setFieldToPlain(this.homeTelTextField);
        setFieldToPlain(this.workTelTextField);
        setFieldToPlain(this.handyTextField);

        setFieldToPlain(this.faxTextField);
        setFieldToPlain(this.emailTextField);
        setFieldToPlain(this.webTextField);

    }

    public void setFieldToEdit(ResTextField field) {

        field.setBorder(BorderFactory.createEtchedBorder());
        field.setFont(fontMedium);
        field.setForeground(Color.BLACK);
        field.setEditable(true);
        field.setHorizontalAlignment(ResTextField.LEFT);
    }

    public void setDataFieldtoClear() {

        this.groupTextField.setText("");
        this.firstNameTextField.setText("");
        this.lastNameTextField.setText("");
        this.streetTextField.setText("");
        this.zipTextField.setText("");
        this.cityTextField.setText("");
        this.stateTextField.setText("");
        this.countryTextField.setText("");

        this.genderTextField.setText("");
        this.dateofBirthTextField.setText("");
        this.homeTelTextField.setText("");
        this.workTelTextField.setText("");
        this.handyTextField.setText("");
        this.faxTextField.setText("");
        this.emailTextField.setText("");
        this.webTextField.setText("");
    }

    public void setFields() {

        Color labelImpColor = Color.RED;

        this.idLabel.setForeground(labelImpColor);
        this.firstNameLabel.setForeground(labelImpColor);
        this.lastNameLabel.setForeground(labelImpColor);
        this.streetLabel.setForeground(labelImpColor);
        this.zipLabel.setForeground(labelImpColor);
        this.cityLabel.setForeground(labelImpColor);
        this.stateLabel.setForeground(labelImpColor);
        this.countryLabel.setForeground(labelImpColor);

        setFieldToPlain(this.idTextField);
        setFieldToEdit(this.groupTextField);
        setFieldToEdit(this.firstNameTextField);
        setFieldToEdit(this.lastNameTextField);
        setFieldToEdit(this.streetTextField);
        setFieldToEdit(this.zipTextField);
        setFieldToEdit(this.cityTextField);
        setFieldToEdit(this.stateTextField);
        setFieldToEdit(this.countryTextField);

        setFieldToEdit(this.genderTextField);
        setFieldToEdit(this.dateofBirthTextField);
        setFieldToEdit(this.homeTelTextField);
        setFieldToEdit(this.workTelTextField);
        setFieldToEdit(this.handyTextField);
        setFieldToEdit(this.faxTextField);
        setFieldToEdit(this.emailTextField);
        setFieldToEdit(this.webTextField);
    }

    public void setFieldToSearch() {

        setFieldToEdit(this.idTextField);
        setFieldToEdit(this.firstNameTextField);
        setFieldToEdit(this.lastNameTextField);
        setFieldToEdit(this.cityTextField);

        setFieldToPlain(this.homeTelTextField);
        setFieldToPlain(this.emailTextField);

        setFieldToPlain(this.groupTextField);
        setFieldToPlain(this.streetTextField);
        setFieldToPlain(this.zipTextField);
        setFieldToPlain(this.stateTextField);
        setFieldToPlain(this.countryTextField);
        setFieldToPlain(this.genderTextField);

        setFieldToPlain(this.dateofBirthTextField);
        setFieldToPlain(this.workTelTextField);
        setFieldToPlain(this.handyTextField);
        setFieldToPlain(this.faxTextField);
        setFieldToPlain(this.webTextField);
    }

    public ResPanel createLayoutStd() {

        gridBagLayoutStd = new GridBagLayout();
        constraintsStd = new GridBagConstraints();
        dataStdPanel = new ResPanel();

        constraintsStd.fill = GridBagConstraints.HORIZONTAL;
        constraintsStd.insets = new Insets(2, 2, 2, 2);

        dataStdPanel.setLayout(gridBagLayoutStd);

        constraintsStd.gridy = 0;
        constraintsStd.gridx = 0;
        gridBagLayoutStd.setConstraints(idLabel, constraintsStd);
        dataStdPanel.add(idLabel);

        constraintsStd.gridy = 0;
        constraintsStd.gridx = 1;
        gridBagLayoutStd.setConstraints(idTextField, constraintsStd);
        dataStdPanel.add(idTextField);

        constraintsStd.gridy = 0;
        constraintsStd.gridx = 2;
        gridBagLayoutStd.setConstraints(groupLabel, constraintsStd);
        dataStdPanel.add(groupLabel);

        constraintsStd.gridy = 0;
        constraintsStd.gridx = 3;
        gridBagLayoutStd.setConstraints(groupTextField, constraintsStd);
        dataStdPanel.add(groupTextField);

        constraintsStd.gridy = 1;
        constraintsStd.gridx = 0;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(blank1Label, constraintsStd);
        dataStdPanel.add(blank1Label);


        constraintsStd.gridy = 2;
        constraintsStd.gridx = 0;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(firstNameLabel, constraintsStd);
        dataStdPanel.add(firstNameLabel);

        constraintsStd.gridy = 2;
        constraintsStd.gridx = 1;
        constraintsStd.gridwidth = 3;
        gridBagLayoutStd.setConstraints(firstNameTextField, constraintsStd);
        dataStdPanel.add(firstNameTextField);

        constraintsStd.gridy = 3;
        constraintsStd.gridx = 0;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(lastNameLabel, constraintsStd);
        dataStdPanel.add(lastNameLabel);

        constraintsStd.gridy = 3;
        constraintsStd.gridx = 1;
        constraintsStd.gridwidth = 3;
        gridBagLayoutStd.setConstraints(lastNameTextField, constraintsStd);
        dataStdPanel.add(lastNameTextField);

        constraintsStd.gridy = 4;
        constraintsStd.gridx = 0;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(streetLabel, constraintsStd);
        dataStdPanel.add(streetLabel);

        constraintsStd.gridy = 4;
        constraintsStd.gridx = 1;
        constraintsStd.gridwidth = 3;
        gridBagLayoutStd.setConstraints(streetTextField, constraintsStd);
        dataStdPanel.add(streetTextField);

        constraintsStd.gridy = 5;
        constraintsStd.gridx = 0;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(zipLabel, constraintsStd);
        dataStdPanel.add(zipLabel);

        constraintsStd.gridy = 5;
        constraintsStd.gridx = 1;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(zipTextField, constraintsStd);
        dataStdPanel.add(zipTextField);

        constraintsStd.gridy = 5;
        constraintsStd.gridx = 2;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(cityLabel, constraintsStd);
        dataStdPanel.add(cityLabel);

        constraintsStd.gridy = 5;
        constraintsStd.gridx = 3;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(cityTextField, constraintsStd);
        dataStdPanel.add(cityTextField);

        constraintsStd.gridy = 6;
        constraintsStd.gridx = 0;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(stateLabel, constraintsStd);
        dataStdPanel.add(stateLabel);

        constraintsStd.gridy = 6;
        constraintsStd.gridx = 1;
        constraintsStd.gridwidth = 3;
        gridBagLayoutStd.setConstraints(stateTextField, constraintsStd);
        dataStdPanel.add(stateTextField);

        constraintsStd.gridy = 7;
        constraintsStd.gridx = 0;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(blank2Label, constraintsStd);
        dataStdPanel.add(blank2Label);

        constraintsStd.gridy = 8;
        constraintsStd.gridx = 0;
        constraintsStd.gridwidth = 1;
        gridBagLayoutStd.setConstraints(countryLabel, constraintsStd);
        dataStdPanel.add(countryLabel);

        constraintsStd.gridy = 8;
        constraintsStd.gridx = 1;
        constraintsStd.gridwidth = 3;
        gridBagLayoutStd.setConstraints(countryTextField, constraintsStd);
        dataStdPanel.add(countryTextField);

        return dataStdPanel;
    }

    public ResPanel createLayoutExt() {

        gridBagLayoutExt = new GridBagLayout();
        constraintsExt = new GridBagConstraints();
        dataExtPanel = new ResPanel();

        constraintsExt.fill = GridBagConstraints.HORIZONTAL;
        constraintsExt.insets = new Insets(2, 2, 2, 2);

        dataExtPanel.setLayout(gridBagLayoutExt);
        // dataExtPanel.setBorder(BorderFactory.createTitledBorder("ExtPerson"));

        constraintsExt.gridy = 0;
        constraintsExt.gridx = 0;
        gridBagLayoutExt.setConstraints(genderLabel, constraintsExt);
        dataExtPanel.add(genderLabel);

        constraintsExt.gridy = 0;
        constraintsExt.gridx = 1;
        gridBagLayoutExt.setConstraints(genderTextField, constraintsExt);
        dataExtPanel.add(genderTextField);

        constraintsExt.gridy = 0;
        constraintsExt.gridx = 2;
        gridBagLayoutExt.setConstraints(dateofBirthLabel, constraintsExt);
        dataExtPanel.add(dateofBirthLabel);

        constraintsExt.gridy = 0;
        constraintsExt.gridx = 3;
        gridBagLayoutExt.setConstraints(dateofBirthTextField, constraintsExt);
        dataExtPanel.add(dateofBirthTextField);

        constraintsExt.gridy = 1;
        constraintsExt.gridx = 0;
        constraintsExt.gridwidth = 1;
        gridBagLayoutExt.setConstraints(blank3Label, constraintsExt);
        dataExtPanel.add(blank3Label);

        constraintsExt.gridy = 2;
        constraintsExt.gridx = 0;
        constraintsExt.gridwidth = 1;
        gridBagLayoutExt.setConstraints(homeTelLabel, constraintsExt);
        dataExtPanel.add(homeTelLabel);

        constraintsExt.gridy = 2;
        constraintsExt.gridx = 1;
        constraintsExt.gridwidth = 3;
        gridBagLayoutExt.setConstraints(homeTelTextField, constraintsExt);
        dataExtPanel.add(homeTelTextField);

        constraintsExt.gridy = 3;
        constraintsExt.gridx = 0;
        constraintsExt.gridwidth = 1;
        gridBagLayoutExt.setConstraints(workTelLabel, constraintsExt);
        dataExtPanel.add(workTelLabel);

        constraintsExt.gridy = 3;
        constraintsExt.gridx = 1;
        constraintsExt.gridwidth = 3;
        gridBagLayoutExt.setConstraints(workTelTextField, constraintsExt);
        dataExtPanel.add(workTelTextField);

        constraintsExt.gridy = 4;
        constraintsExt.gridx = 0;
        constraintsExt.gridwidth = 1;
        gridBagLayoutExt.setConstraints(handyLabel, constraintsExt);
        dataExtPanel.add(handyLabel);

        constraintsExt.gridy = 4;
        constraintsExt.gridx = 1;
        constraintsExt.gridwidth = 3;
        gridBagLayoutExt.setConstraints(handyTextField, constraintsExt);
        dataExtPanel.add(handyTextField);

        constraintsExt.gridy = 5;
        constraintsExt.gridx = 0;
        constraintsExt.gridwidth = 1;
        gridBagLayoutExt.setConstraints(faxLabel, constraintsExt);
        dataExtPanel.add(faxLabel);

        constraintsExt.gridy = 5;
        constraintsExt.gridx = 1;
        constraintsExt.gridwidth = 3;
        gridBagLayoutExt.setConstraints(faxTextField, constraintsExt);
        dataExtPanel.add(faxTextField);

        constraintsExt.gridy = 6;
        constraintsExt.gridx = 0;
        constraintsExt.gridwidth = 1;
        gridBagLayoutExt.setConstraints(blank4Label, constraintsExt);
        dataExtPanel.add(blank4Label);


        constraintsExt.gridy = 7;
        constraintsExt.gridx = 0;
        constraintsExt.gridwidth = 1;
        gridBagLayoutExt.setConstraints(emailLabel, constraintsExt);
        dataExtPanel.add(emailLabel);

        constraintsExt.gridy = 7;
        constraintsExt.gridx = 1;
        constraintsExt.gridwidth = 3;
        gridBagLayoutExt.setConstraints(emailTextField, constraintsExt);
        dataExtPanel.add(emailTextField);

        constraintsExt.gridy = 8;
        constraintsExt.gridx = 0;
        constraintsExt.gridwidth = 1;
        gridBagLayoutExt.setConstraints(webLabel, constraintsExt);
        dataExtPanel.add(webLabel);

        constraintsExt.gridy = 8;
        constraintsExt.gridx = 1;
        constraintsExt.gridwidth = 3;
        gridBagLayoutExt.setConstraints(webTextField, constraintsExt);
        dataExtPanel.add(webTextField);

        return dataExtPanel;
    }

    public void createDataPanelButtons() {

        //NewData Buttons
        this.newDataClearButton = new ResButton();
        this.newDataClearButton.addActionListener((ResAdmin) getController());
        this.newDataClearButton.setActionCommand(ResAdmin.NEW_DATA_CLEAR_BUTTON);

        this.newDataSaveButton = new ResButton();
        this.newDataSaveButton.addActionListener((ResAdmin) getController());
        this.newDataSaveButton.setActionCommand(ResAdmin.NEW_DATA_SAVE_BUTTON);

        this.newDataCancelButton = new ResButton();
        this.newDataCancelButton.addActionListener((ResAdmin) getController());
        this.newDataCancelButton.setActionCommand(ResAdmin.NEW_DATA_CANCEL_BUTTON);

        this.newDataButtonPanel = new ResPanel();
        this.newDataButtonPanel.add(newDataClearButton);
        this.newDataButtonPanel.add(newDataSaveButton);
        this.newDataButtonPanel.add(newDataCancelButton);

        //editData Buttons
        this.editDataClearButton = new ResButton();
        this.editDataClearButton.addActionListener((ResAdmin) getController());
        this.editDataClearButton.setActionCommand(ResAdmin.EDIT_DATA_CLEAR_BUTTON);

        this.editDataResetButton = new ResButton();
        this.editDataResetButton.addActionListener((ResAdmin) getController());
        this.editDataResetButton.setActionCommand(ResAdmin.EDIT_DATA_RESET_BUTTON);

        this.editDataSaveButton = new ResButton();
        this.editDataSaveButton.addActionListener((ResAdmin) getController());
        this.editDataSaveButton.setActionCommand(ResAdmin.EDIT_DATA_SAVE_BUTTON);

        this.editDataCancelButton = new ResButton();
        this.editDataCancelButton.addActionListener((ResAdmin) getController());
        this.editDataCancelButton.setActionCommand(ResAdmin.EDIT_DATA_CANCEL_BUTTON);

        this.editDataButtonPanel = new ResPanel();
        this.editDataButtonPanel.add(editDataClearButton);
        this.editDataButtonPanel.add(editDataResetButton);
        this.editDataButtonPanel.add(editDataSaveButton);
        this.editDataButtonPanel.add(editDataCancelButton);

        // dataSearch buttons
        this.searchDataSearchButton = new ResButton();
        this.searchDataSearchButton.addActionListener((ResAdmin) getController());
        this.searchDataSearchButton.setActionCommand(ResAdmin.SEARCH_DATA_SEARCH_BUTTON);

        this.searchDataClearButton = new ResButton();
        this.searchDataClearButton.addActionListener((ResAdmin) getController());
        this.searchDataClearButton.setActionCommand(ResAdmin.SEARCH_DATA_CLEAR_BUTTON);

        this.searchDataCancelButton = new ResButton();
        this.searchDataCancelButton.addActionListener((ResAdmin) getController());
        this.searchDataCancelButton.setActionCommand(ResAdmin.SEARCH_DATA_CANCEL_BUTTON);

        this.searchDataButtonPanel = new ResPanel();
        this.searchDataButtonPanel.add(searchDataClearButton);
        this.searchDataButtonPanel.add(searchDataSearchButton);
        this.searchDataButtonPanel.add(searchDataCancelButton);
    }

    public void setNewButton(boolean v){

        this.toolBarNewButton.setEnabled(v);
        this.menuEditAdd.setEnabled(v);
    }

    public void setEditButton(boolean v){

        this.toolBarEditButton.setEnabled(v);
        this.menuEditEdit.setEnabled(v);
    }

    public void setViewButton(boolean v){

        this.toolBarViewButton.setEnabled(v);
        this.menuEditView.setEnabled(v);
    }

    public void setDeleteButton(boolean v){

        this.toolBarDeleteButton.setEnabled(v);
        this.menuEditDelete.setEnabled(v);
    }

    public void setSearchButton(boolean v){

        this.toolBarSearchButton.setEnabled(v);
    }

    public void setPrintButton(boolean v){

        this.toolBarPrintButton.setEnabled(v);
        this.menuFilePrint.setEnabled(v);
    }



    public void changeDataButtonPanel(String s) {

        this.constraintsMain.gridy = 1;
        this.constraintsMain.gridx = 0;
        this.constraintsMain.gridwidth = 1;

        if (s == "new" || s.equals("new")) {


            if (newDataButtonPanel.isShowing()) {
                this.mainPanel.remove(newDataButtonPanel);
            }
            if (editDataButtonPanel.isShowing()) {
                this.mainPanel.remove(editDataButtonPanel);
            }

            if (searchDataButtonPanel.isShowing()) {
                this.mainPanel.remove(searchDataButtonPanel);
            }

            this.gridBagLayoutMain.setConstraints(newDataButtonPanel, this.constraintsMain);
            this.mainPanel.add(newDataButtonPanel);
            this.mainPanel.repaint();
            this.mainPanel.updateUI();
            this.setFields();
            this.setDataFieldtoClear();
        }

        if (s == "edit" || s.equals("edit")) {

            if (newDataButtonPanel.isShowing()) {
                this.mainPanel.remove(newDataButtonPanel);
            }

            if (editDataButtonPanel.isShowing()) {
                this.mainPanel.remove(editDataButtonPanel);
            }

            if (searchDataButtonPanel.isShowing()) {
                this.mainPanel.remove(searchDataButtonPanel);
            }

            this.gridBagLayoutMain.setConstraints(editDataButtonPanel, this.constraintsMain);
            this.mainPanel.add(editDataButtonPanel);
            this.mainPanel.repaint();
            this.mainPanel.updateUI();
            this.setFieldToPlain(this.idTextField);
            this.setFields();
        }

        if (s == "search" || s.equals("search")) {

            if (newDataButtonPanel.isShowing()) {
                this.mainPanel.remove(newDataButtonPanel);
            }
            if (editDataButtonPanel.isShowing()) {
                this.mainPanel.remove(editDataButtonPanel);
            }

            if (searchDataButtonPanel.isShowing()) {
                this.mainPanel.remove(searchDataButtonPanel);
            }

            this.gridBagLayoutMain.setConstraints(searchDataButtonPanel, this.constraintsMain);
            this.mainPanel.add(searchDataButtonPanel);
            this.mainPanel.repaint();
            this.mainPanel.updateUI();
            this.setFieldToSearch();
            this.setDataFieldtoClear();
        }

        if (s == "view" || s.equals("view")) {

            if (newDataButtonPanel.isShowing()) {
                this.mainPanel.remove(newDataButtonPanel);
            }
            if (editDataButtonPanel.isShowing()) {
                this.mainPanel.remove(editDataButtonPanel);
            }

            if (searchDataButtonPanel.isShowing()) {
                this.mainPanel.remove(searchDataButtonPanel);
            }

            this.mainPanel.repaint();
            this.mainPanel.updateUI();
            this.setFieldToPlain();
            // this.setDataFieldtoClear();
        }
    }

    public void setFieldId(String id) {

        this.idTextField.setText(id);
    }

    public void setPersonFields(Person p) {

        this.idTextField.setText(p.getPersonId());
        this.groupTextField.setText(p.getGroup());
        this.firstNameTextField.setText(p.getFirstName());
        this.lastNameTextField.setText(p.getLastName());
        this.streetTextField.setText(p.getStreet());
        this.zipTextField.setText(p.getZip());
        this.stateTextField.setText(p.getState());
        this.cityTextField.setText(p.getCity());
        this.countryTextField.setText(p.getCountry());
        this.genderTextField.setText(p.getGender());
        this.dateofBirthTextField.setText(p.getBirth());
        this.homeTelTextField.setText(p.getHomeTel());
        this.workTelTextField.setText(p.getWorkTel());
        this.faxTextField.setText(p.getFax());
        this.handyTextField.setText(p.getCellTel());
        this.emailTextField.setText(p.getEmail());
        this.webTextField.setText(p.getWebpage());
    }

    public Person getPersonFields() {

        Person p = new Person();

        p.setPersonId(this.idTextField.getText());
        p.setGroup(this.groupTextField.getText());
        p.setFirstName(this.firstNameTextField.getText());
        p.setLastName(this.lastNameTextField.getText());
        p.setStreet(this.streetTextField.getText());
        p.setZip(this.zipTextField.getText());
        p.setCity(this.cityTextField.getText());
        p.setState(this.stateTextField.getText());
        p.setCountry(this.countryTextField.getText());
        p.setGender(this.genderTextField.getText());
        p.setBirth(this.dateofBirthTextField.getText());
        p.setHomeTel(this.homeTelTextField.getText());
        p.setWorkTel(this.workTelTextField.getText());
        p.setFax(this.faxTextField.getText());
        p.setCellTel(this.handyTextField.getText());
        p.setEmail(this.emailTextField.getText());
        p.setWebpage(this.webTextField.getText());

        return p;
    }

    //FileNew
    public JFileChooser getFileNewDialog() {

        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(this.newFileDialogTitle);
        jfc.setApproveButtonText(this.newFileDialogApproveButtonText);
        jfc.setMultiSelectionEnabled(false);

        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        //jfc.

        return jfc;
    }

    //FileOpen
    public JFileChooser getFileDialog() {

        JFileChooser jfc = new JFileChooser();
        /*
         UIManager.put("FileChooser.openButtonText","Abrir");
         UIManager.put("FileChooser.cancelButtonText","Anular");
         UIManager.put("FileChooser.saveButtonText","Archivar");
         UIManager.put("FileChooser.filesOfTypeLabelText","Tipo de fila:");
         UIManager.put("FileChooser.fileNameLabelText","Nombre de fila:");
         UIManager.put("FileChooser.lookInLabelText","Mira a:");
          */
        jfc.setDialogTitle(this.openFileDialogTitle);
        jfc.setApproveButtonText(this.openFileDialogApproveButtonText);
        jfc.setMultiSelectionEnabled(false);

        ResAdminFileFilter filterXML = new ResAdminFileFilter();
        filterXML.addExtension("xml");
        filterXML.setDescription("XML Files");

        jfc.setFileFilter(filterXML);
        jfc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);

        return jfc;
    }
    //end FileOpen

    //FileOpenDir
    public JFileChooser getFileDirDialog() {

        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(this.openDirFileDialogTitle);
        jfc.setApproveButtonText(this.openDirFileDialogApproveButtonText);
        jfc.setMultiSelectionEnabled(false);

        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

        return jfc;
    }
    //end FileOpenDir

    //Setting Option xmlStructure
    public XmlStructure createXmlStructureDialog() {

        this.xmlStrDialog = new XmlStructure();

        this.xmlStrDialog.setModel(getModel());
        this.xmlStrDialog.setController(getController());
        this.xmlStrDialog.createWindowBounds();

        try {

            this.xmlStrDialog.initialize();
        }
        catch (Exception e) {
            System.out.println("Fehler createXmlStructureDialog: " + e);
        }

        return xmlStrDialog;
    }

    public void destroyXmlStructureDialog() {

        // this.xmlStrDialog.

    }

    public void setXmlStructureDialog(XmlStructure xmlStrD) {

        this.xmlStrDialog = xmlStrD;
    }

    public XmlStructure getXmlStructureDialog() {

        return this.xmlStrDialog;
    }

    public void setResAdminTableModel(ResAdminTableModel model) {

        this.printableTable.setModel(model);
    }

    public JTable getTable() {

        return this.printableTable;
    }

    public void printTable(){

        this.printableTable.doPrintActions();
    }

    public void showMessage(String type){


        JOptionPane jp = new JOptionPane();

        jp.setFont(fontBigBold);
       if(type=="srow") {
         JOptionPane.showMessageDialog( null, "Select a row!!!!"
                          ,"Message",JOptionPane.INFORMATION_MESSAGE);
       }

       if(type=="filesaved"){



       }

    }

    public Locale getResAdminLocale() {

        return this.locale;
    }

    public void setResAdminLocale(Locale loc) {

        this.locale = loc;
    }

    public void populate() {

        ResourceBundle resources = ResourceBundle.getBundle("locale.ResAdmin", this.locale);

        //Fonts
        fontSmall = new Font(resources.getString("FontSmall"), Font.PLAIN, 10);
        fontMedium = new Font(resources.getString("FontMedium"), Font.PLAIN, 12);
        fontBig = new Font(resources.getString("FontBig"), Font.PLAIN, 14);

        labelFont = new Font(resources.getString("LabelFont"), Font.PLAIN, 12);
        fieldFont = new Font(resources.getString("FieldFont"), Font.PLAIN, 14);
        menuFont =  new Font(resources.getString("MenuFont"), Font.PLAIN, 12);
        //MenuFile String
        try {

            this.printableTable.setFont(labelFont);

            menuFile.setFont(menuFont);
            menuFile.setText(resources.getString("MenuFile"));
            menuFile.setMnemonic(resources.getString("MenuFileMn").charAt(0));

            menuFileNew.setFont(menuFont);
            menuFileNew.setText(resources.getString("MenuFileNew"));
            menuFileNew.setMnemonic(resources.getString("MenuFileNewMn").charAt(0));

            menuFileOpen.setFont(menuFont);
            menuFileOpen.setText(resources.getString("MenuFileOpen"));
            menuFileOpen.setMnemonic(resources.getString("MenuFileOpenMn").charAt(0));

            menuFileOpenDir.setFont(menuFont);
            menuFileOpenDir.setText(resources.getString("MenuFileOpenDir"));
            menuFileOpenDir.setMnemonic(resources.getString("MenuFileOpenDirMn").charAt(0));

            menuFileReopen.setFont(menuFont);
            menuFileReopen.setText(resources.getString("MenuFileReopen"));
            menuFileReopen.setMnemonic(resources.getString("MenuFileReopenMn").charAt(0));

            menuFilePrint.setFont(menuFont);
            menuFilePrint.setText(resources.getString("MenuFilePrint"));
            menuFilePrint.setMnemonic(resources.getString("MenuFilePrintMn").charAt(0));

            menuFileExit.setFont(menuFont);
            menuFileExit.setText(resources.getString("MenuFileExit"));
            menuFileExit.setMnemonic(resources.getString("MenuFileExitMn").charAt(0));

            //MenuEdit String
            menuEdit.setFont(menuFont);
            menuEdit.setText(resources.getString("MenuEdit"));
            menuEdit.setMnemonic(resources.getString("MenuEditMn").charAt(0));

            menuEditAdd.setFont(menuFont);
            menuEditAdd.setText(resources.getString("MenuEditAdd"));
            menuEditAdd.setMnemonic(resources.getString("MenuEditAddMn").charAt(0));

            menuEditView.setFont(menuFont);
            menuEditView.setText(resources.getString("MenuEditView"));
            menuEditView.setMnemonic(resources.getString("MenuEditViewMn").charAt(0));

            menuEditEdit.setFont(menuFont);
            menuEditEdit.setText(resources.getString("MenuEditEdit"));
            menuEditEdit.setMnemonic(resources.getString("MenuEditEditMn").charAt(0));

            menuEditDelete.setFont(menuFont);
            menuEditDelete.setText(resources.getString("MenuEditDelete"));
            menuEditDelete.setMnemonic(resources.getString("MenuEditDeleteMn").charAt(0));

            //MenuSetting String
            menuSetting.setFont(menuFont);
            menuSetting.setText(resources.getString("MenuSetting"));
            menuSetting.setMnemonic(resources.getString("MenuSettingMn").charAt(0));

            subMenuLanguage.setFont(menuFont);
            subMenuLanguage.setText(resources.getString("MenuSettingLanguage"));
            subMenuLanguage.setMnemonic(resources.getString("MenuSettingLanguageMn").charAt(0));

            langGerman.setFont(menuFont);
            langGerman.setText(resources.getString("MenuLanguageGerman"));
            langEnglish.setFont(menuFont);
            langEnglish.setText(resources.getString("MenuLanguageEnglish"));
            langTamil.setFont(menuFont);
            langTamil.setText(resources.getString("MenuLanguageTamil"));

            menuSettingXmlStr.setFont(menuFont);
            menuSettingXmlStr.setText(resources.getString("MenuSettingXmlStr"));
            menuSettingXmlStr.setMnemonic(resources.getString("MenuSettingXmlStrMn").charAt(0));

            menuSettingOption.setFont(menuFont);
            menuSettingOption.setText(resources.getString("MenuSettingOption"));
            menuSettingOption.setMnemonic(resources.getString("MenuSettingOptionMn").charAt(0));

            //MenuHelp String
            menuHelp.setFont(menuFont);
            menuHelp.setText(resources.getString("MenuHelp"));
            menuHelp.setMnemonic(resources.getString("MenuHelpMn").charAt(0));

            menuHelpContex.setFont(menuFont);
            menuHelpContex.setText(resources.getString("MenuHelpContex"));
            menuHelpContex.setMnemonic(resources.getString("MenuHelpContexMn").charAt(0));

            menuHelpAbout.setFont(menuFont);
            menuHelpAbout.setText(resources.getString("MenuHelpAbout"));
            menuHelpAbout.setMnemonic(resources.getString("MenuHelpAboutMn").charAt(0));

        }
        catch (Exception exp) {
            System.out.println("Locale change error populate, MenuBar: " + exp);
        }

        //Toolbar
        try {

            addIcon = new ImageIcon(ResAdmin.iconDir + resources.getString("ToolBarIconNew"));
            toolBarNewButton.setIcon(addIcon);
            toolBarNewButton.setFont(fontSmall);
            toolBarNewButton.setText(resources.getString("ToolBarNew"));

            viewIcon = new ImageIcon(ResAdmin.iconDir + resources.getString("ToolBarIconView"));
            toolBarViewButton.setIcon(viewIcon);
            toolBarViewButton.setFont(fontSmall);
            toolBarViewButton.setText(resources.getString("ToolBarView"));

            editIcon = new ImageIcon(ResAdmin.iconDir + resources.getString("ToolBarIconEdit"));
            toolBarEditButton.setIcon(editIcon);
            toolBarEditButton.setFont(fontSmall);
            toolBarEditButton.setText(resources.getString("ToolBarEdit"));

            deleteIcon = new ImageIcon(ResAdmin.iconDir + resources.getString("ToolBarIconDelete"));
            toolBarDeleteButton.setIcon(deleteIcon);
            toolBarDeleteButton.setFont(fontSmall);
            toolBarDeleteButton.setText(resources.getString("ToolBarDelete"));

            searchIcon = new ImageIcon(ResAdmin.iconDir + resources.getString("ToolBarIconSearch"));
            toolBarSearchButton.setIcon(searchIcon);
            toolBarSearchButton.setFont(fontSmall);
            toolBarSearchButton.setText(resources.getString("ToolBarSearch"));

            printIcon = new ImageIcon(ResAdmin.iconDir + resources.getString("ToolBarIconPrint"));
            toolBarPrintButton.setIcon(printIcon);
            toolBarPrintButton.setFont(fontSmall);
            toolBarPrintButton.setText(resources.getString("ToolBarPrint"));


        }
        catch (Exception exp) {
            System.out.println("Locale change error populate, ToolBar: " + exp);
        }

        try {

            this.groupTextField.setFont(fieldFont);
            groupLabel.setFont(labelFont);
            groupLabel.setText(resources.getString("LabelGroup"));

           // this.idTextField.setFont(fieldFont);
            idLabel.setFont(labelFont);
            idLabel.setText(resources.getString("LabelID"));

            this.firstNameTextField.setFont(fieldFont);
            firstNameLabel.setFont(labelFont);
            firstNameLabel.setText(resources.getString("LabelFirstName"));

            this.lastNameTextField.setFont(fieldFont);
            lastNameLabel.setFont(labelFont);
            lastNameLabel.setText(resources.getString("LabelLastName"));

            this.streetTextField.setFont(fieldFont);
            streetLabel.setFont(labelFont);
            streetLabel.setText(resources.getString("LabelStreet"));

            this.zipTextField.setFont(fieldFont);
            zipLabel.setFont(labelFont);
            zipLabel.setText(resources.getString("LabelZip"));

            this.cityTextField.setFont(fieldFont);
            cityLabel.setFont(labelFont);
            cityLabel.setText(resources.getString("LabelCity"));

            this.stateTextField.setFont(fieldFont);
            stateLabel.setFont(labelFont);
            stateLabel.setText(resources.getString("LabelState"));

            this.countryTextField.setFont(fieldFont);
            countryLabel.setFont(labelFont);
            countryLabel.setText(resources.getString("LabelCountry"));

            this.genderTextField.setFont(fieldFont);
            genderLabel.setFont(labelFont);
            genderLabel.setText(resources.getString("LabelGender"));

            this.dateofBirthTextField.setFont(fieldFont);
            dateofBirthLabel.setFont(labelFont);
            dateofBirthLabel.setText(resources.getString("LabelBirth"));

            this.homeTelTextField.setFont(fieldFont);
            homeTelLabel.setFont(labelFont);
            homeTelLabel.setText(resources.getString("LabelHomeTel"));

            this.workTelTextField.setFont(fieldFont);
            workTelLabel.setFont(labelFont);
            workTelLabel.setText(resources.getString("LabelWorkTel"));

            this.handyTextField.setFont(fieldFont);
            handyLabel.setFont(labelFont);
            handyLabel.setText(resources.getString("LabelCellphone"));

            this.faxTextField.setFont(fieldFont);
            faxLabel.setFont(labelFont);
            faxLabel.setText(resources.getString("LabelFax"));

            emailLabel.setFont(labelFont);
            emailLabel.setText(resources.getString("LabelEmail"));

            webLabel.setFont(labelFont);
            webLabel.setText(resources.getString("LabelWebpage"));

        }
        catch (Exception exp) {
            System.out.println("Locale change error populate, Labels: " + exp);
        }
        //DataButtons
        try {

            this.newDataClearButton.setFont(fontMedium);
            this.newDataClearButton.setText(resources.getString("ClearButton"));

            this.newDataSaveButton.setFont(fontMedium);
            this.newDataSaveButton.setText(resources.getString("SaveButton"));

            this.newDataCancelButton.setFont(fontMedium);
            this.newDataCancelButton.setText(resources.getString("CancelButton"));

            //editDataButtons
            this.editDataClearButton.setFont(fontMedium);
            this.editDataClearButton.setText(resources.getString("ClearButton"));

            this.editDataResetButton.setFont(fontMedium);
            this.editDataResetButton.setText(resources.getString("ResetButton"));

            this.editDataSaveButton.setFont(fontMedium);
            this.editDataSaveButton.setText(resources.getString("SaveButton"));

            this.editDataCancelButton.setFont(fontMedium);
            this.editDataCancelButton.setText(resources.getString("CancelButton"));

            // dataSearch buttons
            this.searchDataSearchButton.setFont(fontMedium);
            this.searchDataSearchButton.setText(resources.getString("SearchButton"));

            this.searchDataClearButton.setFont(fontMedium);
            this.searchDataClearButton.setText(resources.getString("ClearButton"));

            this.searchDataCancelButton.setFont(fontMedium);
            this.searchDataCancelButton.setText(resources.getString("CancelButton"));

            this.labelMale = resources.getString("LabelMale");
            this.labelFemale = resources.getString("LabelFemale");

        }
        catch (Exception exp) {
            System.out.println("Locale change error populate, DataButtons: " + exp);
        }

        //FileNew Dialog
        this.newFileDialogTitle = resources.getString("newFileDialogTitle");
        this.newFileDialogApproveButtonText = resources.getString("newFileDialogApproveButtonText");

        //FileOpenDialog
        this.openFileDialogTitle = resources.getString("openFileDialogTitle");
        this.openFileDialogApproveButtonText = resources.getString("openFileDialogApproveButtonText");

        //FileOpenDirDialog
        this.openDirFileDialogTitle = resources.getString("openDirFileDialogTitle");
        this.openDirFileDialogApproveButtonText = resources.getString("openDirFileDialogApproveButtonText");

        /*
        UIManager.put("FileChooser.lookInLabelText",resources.getString("FClookInLabelText"));
        UIManager.put("FileChooser.filesOfTypeLabelText",resources.getString("FCfilesOfTypeLabelText"));
        UIManager.put("FileChooser.upFolderToolTipText",resources.getString("FCupFolderToolTipText"));
        UIManager.put("FileChooser.fileNameLabelText",resources.getString("FCfileNameLabelText"));
        UIManager.put("FileChooser.homeFolderToolTipText",resources.getString("FChomeFolderToolTipText"));
        UIManager.put("FileChooser.newFolderToolTipText",resources.getString("FCnewFolderToolTipText"));
        UIManager.put("FileChooser.listViewButtonToolTipTextlist",resources.getString("FClistViewButtonToolTipTextlist"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText",resources.getString("FCdetailsViewButtonToolTipText"));
       */
        UIManager.put("FileChooser.saveButtonText",resources.getString("FCsaveButtonText"));
        UIManager.put("FileChooser.openButtonText",resources.getString("FCopenButtonText"));
        UIManager.put("FileChooser.cancelButtonText",resources.getString("FCcancelButtonText"));

        UIManager.put("OptionPane.okButtonText",resources.getString("OK"));
        UIManager.put("OptionPane.yesButtonText",resources.getString("YES"));
        UIManager.put("OptionPane.noButtonText",resources.getString("NO"));

        /*
        messageDialogOK = resources.getString("messageDialogOK");
        messageDialogYes = resources.getString("messageDialogYes");
        messageDialogNO = resources.getString("messageDialogNO");
        messageDialogTitleError = resources.getString("messageDialogTitleError");
        messageDialogTitleInfo = resources.getString("messageDialogTitleInfo");
        messageDialogSelectRowText = resources.getString("messageDialogSelectRowText");
        messageDialogFileSavedText = resources.getString("messageDialogFileSavedText");
        messageDialogFillFieldsText = resources.getString("messageDialogFillFieldsText");
        messageDialogDeleteText = resources.getString("messageDialogDeleteText");
          */
       /*
        UIManager.put("FileChooser.updateButtonText",resources.getString("FCupdateButtonText"));
        UIManager.put("FileChooser.helpButtonText",resources.getString("FChelpButtonText"));
        UIManager.put("FileChooser.saveButtonToolTipText",resources.getString("FCsaveButtonToolTipText"));
        UIManager.put("FileChooser.openButtonToolTipText",resources.getString("FCopenButtonToolTipText"));
        UIManager.put("FileChooser.cancelButtonToolTipText",resources.getString("FCcancelButtonToolTipText"));
        UIManager.put("FileChooser.updateButtonToolTipText",resources.getString("FCupdateButtonToolTipText"));
        UIManager.put("FileChooser.helpButtonToolTipText",resources.getString("FChelpButtonToolTipText"));
        */
        //  this.printableTable.setFont(fontBigBold);

    }


}

