/*
 * $RCSfile: ResAdminModel.java,v $FILENAME,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.application.healthcare.resadmin;

import org.resmedicinae.resmedlib.component.model.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import org.resmedicinae.application.healthcare.resadmin.ResAdmin;
import org.resmedicinae.application.healthcare.resadmin.table.*;
import org.resmedicinae.application.healthcare.resadmin.utils.*;
import org.resmedicinae.application.healthcare.resadmin.data.*;
import org.w3c.dom.Document;

import java.util.*;
import java.io.File;
import java.awt.*;
// import java.util.Locale;

/**
 * This class represents the resadmin model.
 *
 * @version $Revision: 1.2 $ $Date: 2003/02/20 15:24:35 $ $Author: chrissy $
 * @author Kumanan Kanagasabapathy <kumanan@uni.de>
 */
public class ResAdminModel extends Model {

    //
    // Children.
    //
    
    /** The swing view. */
    public static final String SWING_VIEW = new String("swing_view");

    /** The table model. */
    public static final String TABLE_MODEL = new String("table_model");

    private Locale modelLocale=null;

    private String[] tableColumnNames=null;

    private File workingDir=null;
    private File openFile=null;

    private XmlPersonTag personTag;
    private Person person;
    private int selectedRow;


    public void initialize(){

        this.createTableColumnNames();
        this.createResAdminTableModel();
        this.personTag = new XmlPersonTag();
    }

    public void createResAdminLocale(){

        ResAdminView view = (ResAdminView) getView();
        this.modelLocale = view.getResAdminLocale();
    }

    public void setColumnNames(String[] column){

        this.tableColumnNames = column;
    }

    public void createTableColumnNames(){

        modelLocale =  new Locale ("en", "US");

        ResourceBundle resources = ResourceBundle.getBundle("locale.ResAdmin" , this.modelLocale);

        String[] colum = {resources.getString("LabelID"),resources.getString("LabelLastName"),
                            resources.getString("LabelFirstName"),resources.getString("LabelCity"),
                            resources.getString("LabelHomeTel"),resources.getString("LabelEmail")};
        this.tableColumnNames = colum;
    }

    public void createResAdminTableModel(){

        this.resAdminTableModel = new ResAdminTableModel();
        this.resAdminTableModel.setColnames(tableColumnNames);
        this.resAdminTableModel.clear();

    }

    public File getFileName(TPerson tp){

      File file = new File(this.getWorkingDir() + File.separator + tp.getPersonId() + ".xml");
      System.out.println(file);
      return file;

    }
     public boolean checkXMLFile(File file){

          File f[] = file.listFiles(new CustomFileFilter());
          if (f.length>0){

              return true;
          }
          else return false;
     }
    //load xmlfiles from a Directory
    public boolean loadFileFromDir(File workDir){

        ResAdminView view = (ResAdminView) getView();
        this.setWorkingDir(workDir);
        File dir = this.workingDir;
        File allFiles[] = dir.listFiles(new CustomFileFilter());


        if(allFiles.length>0) {

            IoXMLFiles ioxml = new IoXMLFiles();
            this.clearResTableModel();

            for (int i=0; i < allFiles.length; i++){

                try {

                    System.out.println(allFiles[i].toString());
                    String checkMessage = ioxml.checkSingeFile(allFiles[i], this.personTag);

                    if(checkMessage.equals("OK")){

                       Person person = ioxml.getDataFromDocument(this.personTag);

                       this.addPersonToTable(person);
                   }

               }

                catch (Exception exc) { System.out.println(exc); }
            }

           return true;
       }

       else return false;

   }



    public ResAdminTableModel getResTableModel(){

        return this.resAdminTableModel;
    }

    public void clearResTableModel(){

        this.resAdminTableModel.clear();
    }
    public void setResTableModel(ResAdminTableModel model){

        this.resAdminTableModel = model;

    }

    public void setPerson(Person p){

        this.person = p;
    }
    public Person getPerson(){

        return this.person;
    }

    public void setWorkingDir(File dir){

        this.workingDir = dir;
    }

    public File getWorkingDir(){

        return this.workingDir;

    }

    public Person openXmlFile(File file){

        ResAdminView view = (ResAdminView) getView();
        IoXMLFiles ioxml = new IoXMLFiles();

        String checkMessage = ioxml.checkSingeFile(file, this.personTag);

        if(checkMessage.equals("OK")){

           return ioxml.getDataFromDocument(this.personTag);
        }
        else {

            System.out.println("error in openXMlFile..");
            return null;
        }

    }

    public void updatePersonToTable(Person p, int row){

        TPerson tp = new TPerson();

        tp.setPersonId(p.getPersonId());
        tp.setFirstName(p.getFirstName());
        tp.setLastName(p.getLastName());
        tp.setCity(p.getCity());
        tp.setHomeTel(p.getHomeTel());
        tp.setEmail(p.getEmail());

        this.resAdminTableModel.set(row,tp);
    }

    public void addPersonToTable(Person p){

        TPerson tp = new TPerson();

        tp.setPersonId(p.getPersonId());
        tp.setFirstName(p.getFirstName());
        tp.setLastName(p.getLastName());
        tp.setCity(p.getCity());
        tp.setHomeTel(p.getHomeTel());
        tp.setEmail(p.getEmail());

        this.resAdminTableModel.add(tp);

    }

    public Vector searchPerson(Person p){

        ResAdminView view = (ResAdminView) getView();
        Vector result = new Vector();

        for(int i=0; i < this.resAdminTableModel.size();i++){

               TPerson dataTp = this.getResTableModel().get(i);

               if(dataTp.getPersonId().equals(p.getPersonId()) ||
                  dataTp.getFirstName().equals(p.getFirstName())||
                  dataTp.getLastName().equals(p.getLastName()) ||
                  dataTp.getCity().equals(p.getCity())){

                  result.add(String.valueOf(i));
                  System.out.println("String find at row: " + i);
                  view.getTable().addRowSelectionInterval(i,i);
               }
        }

        System.out.println("Total search result: " + result.size());

        return result;
    }


   public void saveEditFile(Person p, int row){


       IoXMLFiles ioxml = new IoXMLFiles();
       ioxml.editXmlFile(p, this.workingDir.toString(), this.getPersonTag());

       this.updatePersonToTable(p, this.selectedRow);

    }

   public boolean saveNewFile(Person p){

       ResAdminView view = (ResAdminView) getView();
       IoXMLFiles iox = new IoXMLFiles();
       if(iox.setPersonDataToDocument(p, this.getPersonTag(), this.workingDir.toString())){

       }
       else {

         System.out.println("There was an error in SaveNewFile..");
          return false;
       }

       return true;
   }

   public String createTimeBasedID(){

       Date d = new Date();

       String ID = Long.toString(d.getTime());
       System.out.println("Time based ID genereded: " + ID);

       return ID;

   }

    public void setPersonTag(XmlPersonTag pTag){

        this.personTag = pTag;
    }

    public XmlPersonTag getPersonTag(){

        return this.personTag;
    }

     public void setView(SwingView view) {

        this.view = view;

    }

     public SwingView getView() {

        return this.view;

    }

    public void populate(){

        ResAdminView view = (ResAdminView) getView();
        ResourceBundle resources = ResourceBundle.getBundle("locale.ResAdmin" , this.modelLocale);

        Font labelFont = new Font(resources.getString("LabelFont"), Font.PLAIN, 12);

        view.getTable().getTableHeader().setFont(labelFont);
        view.getTable().getColumnModel().getColumn(0).setHeaderValue(resources.getString("LabelID"));
        view.getTable().getColumnModel().getColumn(1).setHeaderValue(resources.getString("LabelLastName"));
        view.getTable().getColumnModel().getColumn(2).setHeaderValue(resources.getString("LabelFirstName"));
        view.getTable().getColumnModel().getColumn(3).setHeaderValue(resources.getString("LabelCity"));
        view.getTable().getColumnModel().getColumn(4).setHeaderValue(resources.getString("LabelHomeTel"));
        view.getTable().getColumnModel().getColumn(5).setHeaderValue(resources.getString("LabelEmail"));

        view.getTable().getTableHeader().repaint();

    }


}
