/*
 * $RCSfile: HealthRecordIndex.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.xml;

import java.net.*;
import java.util.*;
import java.sql.*;


/** This class represents a healthRecord index that include the id, name and first name of all healthRecords. */
public class HealthRecordIndex extends Vector {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String FIRSTNAME = "firstnam";


    /** The biggest ID that is actual used */
    //  private Integer maximumId;

    /** The constructor initialzes the member varuables */
    public HealthRecordIndex() {
        //setMaximumId(new Integer(-1));
    }

    /**
     * Add a HealthRecord to the HealthRecordIndex
     * @param healthRecordData Hashtable that includes all necessary data
     */
    public void addHealthRecord(Hashtable healthRecordData) {
        this.add(healthRecordData);
    }

    /**
     * Returns a Vector object that includes hashtables of all healthRecords
     * @return Vector of Hastable of healthRecord data
     */
    public Vector getAllHealthRecords() {
        return this;
    }

    /**
     * Sets the member variable maximumId to the biggest actual used ID
     * @param id Integer that includes the new maximum ID
     */
/*    public void setMaximumId(Integer id) {
        this.maximumId = id;
    }
*/
    /**
     * Returns the biggest actual used ID
     * @return the maximum ID
     */
/*    public Integer getMaximumId() {
        return this.maximumId;
    }
*/
}
