package reform.resmedicinae.reform.system.server.rmi;

import reform.resmedicinae.reform.system.server.*;
import org.resmedicinae.domain.healthcare.*;

import java.rmi.*;
import java.net.*;

/**
 * User: zonie
 * Date: Jan 9, 2003
 * Time: 4:39:51 PM
 */
public class RMIGeneralServicesImpl extends RMIServer implements RMIGeneralServices {
    private HealthRecord healthRecord;
    private static String serverID;

    public RMIGeneralServicesImpl() throws RemoteException {
        super();
    }

    public void initialize() throws java.rmi.RemoteException {

    }

    public String sayHello() {
        return "Hello, wonderful World!";
    }

    public long add(long a, long b)
            throws java.rmi.RemoteException {
        return a + b;
    }

    public long sub(long a, long b)
            throws java.rmi.RemoteException {
        return a - b;
    }

    public long mul(long a, long b)
            throws java.rmi.RemoteException {
        return a * b;
    }

    public long div(long a, long b)
            throws java.rmi.RemoteException {
        return a / b;
    }

    public void setCurrentHealthRecord(HealthRecord healthRecord) throws java.rmi.RemoteException {
        this.healthRecord = healthRecord;
    }

    public HealthRecord getCurrentHealthRecord() throws java.rmi.RemoteException {
        return this.healthRecord;
    }

    public static void setServerID(String id) {
        serverID = id;
    }

    public static String getServerID() {
        return serverID;
    }

    public void unbindServer(String rmiHost) throws java.rmi.RemoteException {
        try {
            Naming.unbind(getServerID());
        } catch (Exception e) {
            System.out.println("RMIGeneralServices err: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void bind(String rmiHost) throws java.rmi.RemoteException {
        try {
            // Create and install a security manager
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }

            setServerID(rmiHost);

            RMIGeneralServicesImpl obj = new RMIGeneralServicesImpl();

            // Bind this object instance to the name "HelloServer"
            Naming.rebind(getServerID(), obj);

            System.out.println("RMIGeneralServices bound in registry");
        } catch (Exception e) {
            System.out.println("RMIGeneralServices err: " + e.getMessage());
            e.printStackTrace();
        }
    }


/*    public static void main(String args[]) {
        try {
            // Create and install a security manager
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }

            setServerID(args[0]);

            RMIGeneralServicesImpl obj = new RMIGeneralServicesImpl();

            // Bind this object instance to the name "HelloServer"
            Naming.rebind(getServerID(), obj);

            System.out.println("RMIGeneralServices bound in registry");
        } catch(Exception e) {
            System.out.println("RMIGeneralServices err: " + e.getMessage());
            e.printStackTrace();
        }
    }
*/
}
