/*
 * $RCSfile: CreateTablePartialContacts.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package reform.resmedicinae.reform.sqlstatement.create;

import reform.resmedicinae.reform.sqlstatement.*;

/**
 * This class represents a SQL statement.
 * @version $Revision: 1.2 $ $Date: 2003/03/24 20:12:23 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class CreateTablePartialContacts extends CreateTable {

    public void initialize() throws Exception {
        super.initialize();
        setTableName(new org.resmedicinae.resmedlib.term.String("partialcontacts"));
        setStatement(new org.resmedicinae.resmedlib.term.String(
                "CREATE TABLE PartialContacts ( PartialContactID VARCHAR(80) NOT NULL, EpisodeID VARCHAR(70)," +
                "ProblemID VARCHAR(60), HRID VARCHAR(50), Date VARCHAR(32), Subjective VARCHAR(1000), " +
                "Assessment VARCHAR(1000), Plan VARCHAR(1000)," +
                "Timestamp VARCHAR(32), PRIMARY KEY (PartialContactID),  FOREIGN KEY (EpisodeID) " +
                "REFERENCES Episodes (EpisodeID) ON DELETE CASCADE ON UPDATE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE," +
                "FOREIGN KEY (ProblemID) REFERENCES Problems (ProblemID) ON DELETE CASCADE ON UPDATE CASCADE " +
                "NOT DEFERRABLE INITIALLY IMMEDIATE, FOREIGN KEY (HRID) REFERENCES HealthRecords (HRID) " +
                "ON DELETE CASCADE ON UPDATE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE)"
        ));
    }

}