/*
 * $RCSfile: CreateTableEpisodes.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package reform.resmedicinae.reform.sqlstatement.create;

import reform.resmedicinae.reform.sqlstatement.*;

/**
 * This class represents a SQL statement.
 * @version $Revision: 1.1 $ $Date: 2003/03/11 12:53:51 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class CreateTableEpisodes extends CreateTable {

    public void initialize() throws Exception {
        super.initialize();
        setTableName(new org.resmedicinae.resmedlib.term.String("episodes"));
        setStatement(new org.resmedicinae.resmedlib.term.String(
                "CREATE TABLE Episodes ( EpisodeID VARCHAR(70) NOT NULL, ProblemID VARCHAR(60)," +
                "HRID VARCHAR(50), Timestamp VARCHAR(32), PRIMARY KEY (EpisodeID), FOREIGN KEY (ProblemID) " +
                "REFERENCES Problems (ProblemID) ON DELETE CASCADE ON UPDATE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE," +
                "FOREIGN KEY (HRID) REFERENCES HealthRecords (HRID) ON DELETE CASCADE ON UPDATE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE )"
        ));
    }

}