/*
 * $RCSfile: SQLStatement.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package reform.resmedicinae.reform.sqlstatement;

import org.resmedicinae.resmedlib.*;

import java.sql.*;
import java.util.*;

/**
 * This class represents a SQL statement.
 * @version $Revision: 1.1 $ $Date: 2003/03/11 12:53:51 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class SQLStatement extends Item {

    private org.resmedicinae.resmedlib.term.String statement;
    private Connection connection;
    private ArrayList sqlParameter;

    public void initialize() throws Exception {
        super.initialize();
        sqlParameter = new ArrayList();
    }

    public org.resmedicinae.resmedlib.term.String getStatement() {
        return this.statement;
    }

    protected void setStatement(org.resmedicinae.resmedlib.term.String statement) {
        this.statement = statement;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void addSqlParameter(org.resmedicinae.resmedlib.term.String oneSqlParameter) {
        this.sqlParameter.add(oneSqlParameter);
    }

    public void setSqlParameter(ArrayList sqlParameter) {
        this.sqlParameter = sqlParameter;
    }

    public ArrayList getSqlParameter() {
        return this.sqlParameter;
    }
}
