/*
 * $RCSfile: SQLInsertUpdate.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package reform.resmedicinae.reform.sqlstatement;

import java.sql.*;
import java.util.*;

/**
 * This class represents a SQL statement.
 * @version $Revision: 1.2 $ $Date: 2003/03/24 20:12:22 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class SQLInsertUpdate extends SQLStatement {

    public void initialize() throws Exception {
        super.initialize();
    }

    public void execute() {
        try {
            System.out.println(">>>>>>>>>>>SQLInsertUpdate");
            PreparedStatement s;
            if (getStatement() != null) {
                if (getConnection() != null) {
                    s = getConnection().prepareStatement(getStatement().getValue());
                    if (s != null) {
                        System.out.println(">>>>>>vor dem Einfgen der Parameter: " + s);
                        int i = 0;
                        while (s.toString().indexOf("?") > -1) {
                            if (getSqlParameter().get(i) != null)
                                s.setString(i + 1, ((org.resmedicinae.resmedlib.term.String) getSqlParameter().get(i)).getValue());
                            else
                                s.setString(i + 1, "");
                            i++;
                        }
                        System.out.println(">>>>>>>nach dem Einfgen der Parameter: " + s);
                        try {
                            s.executeUpdate();
                        } catch (SQLException e) {
                            throw new SQLException(e.toString());
                        } finally {
                            s.close();
                        }
                    } else {
                        throw new NullPointerException("Could not execute query. The find statement is null.");
                    }
                } else {
                    throw new NullPointerException("Could not find object by last name. The connection object is null.");
                }
            } else {
                throw new NullPointerException("Could not find object. The SQL-statement object is null.");
            }
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

}
