/*
 * $RCSfile: SQLFind.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package reform.resmedicinae.reform.sqlstatement;

import java.sql.*;
import java.util.*;

/**
 * This class represents a SQL statement.
 * @version $Revision: 1.1 $ $Date: 2003/03/11 12:53:51 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class SQLFind extends SQLStatement {

    public void initialize() throws Exception {
        super.initialize();
    }

    public ArrayList execute() {
        try {
            PreparedStatement s;
            ResultSet rs = null;
            ArrayList result = new ArrayList();
            if (getStatement() != null) {
                if (getConnection() != null) {
                    s = getConnection().prepareStatement(getStatement().getValue());
                    if (s != null) {
                        try {
                            System.out.println(">>>>>>vor dem Einfgen der Parameter: " + s);
                            if ((getSqlParameter() != null) && (getSqlParameter().size() > 0)) {
                                int i = 0;
                                while (s.toString().indexOf("?") > -1) {
                                    if (getSqlParameter().get(i) != null)
                                        s.setString(i + 1, ((org.resmedicinae.resmedlib.term.String)
                                                getSqlParameter().get(i)).getValue());
                                    else
                                        s.setString(i + 1, "");
                                    i++;
                                }
                                System.out.println(">>>>>>>nach dem Einfgen der Parameter: " + s);
                            }
                            rs = s.executeQuery();
                            if (rs != null) {
                                //  System.out.println("<<<<<<<<<<rs!=null ");

                                /* Insert the column names into the returning ArrayList */

                                ResultSetMetaData rsmd = rs.getMetaData();

                                Vector v = new Vector();
                                int numberOfColumns = rsmd.getColumnCount();
                                // System.out.println("<<<<<<<<<<numberOfColumns: "+numberOfColumns);
                                v = new Vector();
                                for (int i = 1; i <= numberOfColumns; i++) {
                                    //  System.out.println("<<<<<<<<<<rsmd.getColumnName("+i+"): "+rsmd.getColumnName(i));
                                    v.add(rsmd.getColumnName(i));
                                }
                                result.add(v);

                                /* Insert the values of the result set into the returning ArrayList */
                                while (rs.next()) {
                                    //  System.out.println("<<<<<<<<<<rs.next() ");
                                    v = new Vector();
                                    for (int i = 1; i <= numberOfColumns; i++) {
                                        // System.out.println("<<<<<<<<<<rs.getString(i): "+rs.getString(i));
                                        v.add(rs.getString(i));
                                    }
                                    result.add(v);
                                }
                            } else {
                                throw new NullPointerException("Could not assemble result object list. The result set is null.");
                            }
                        } catch (SQLException e) {
                            throw new SQLException(e.toString());
                        } finally {
                            s.close();
                        }
                    } else {
                        throw new NullPointerException("Could not execute query. The find statement is null.");
                    }
                } else {
                    throw new NullPointerException("Could not find object. The connection object is null.");
                }
            } else {
                throw new NullPointerException("Could not find object. The SQL-statement object is null.");
            }
            return result;
        } catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}
