/*
 * $RCSfile: HealthRecordViewModel.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.region.model;

import reform.resmedicinae.reform.application.common.basic.*;
import reform.resmedicinae.reform.region.*;
import reform.resmedicinae.reform.xml.*;
import org.resmedicinae.domain.healthcare.*;
import org.resmedicinae.domain.healthcare.description.*;
import org.resmedicinae.domain.healthcare.heading.problem.*;
import org.resmedicinae.domain.healthcare.unit.*;
import org.resmedicinae.resmedlib.region.model.*;

import java.util.*;

/**
 * This class represents a view model. A view model's task is to support the data structure of a view,
 * i.e. to map the domain model's tree structure to simpler structures
 * such as a list supporting a combo box or a table structure.
 * @version $Revision: 1.1 $ $Date: 2003/03/11 12:53:50 $ $Author: zone3 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class HealthRecordViewModel extends ViewModel {
    public static final String VIEW_MODEL_KEY = "HEALTH_RECORD_VIEW_MODEL_KEY";
    private AdvancedBasicApplication controller = null;

/*    public void setController(AdvancedBasicApplication controller) {
        this.controller = controller;
    }

    public AdvancedBasicApplication getController() {
        return this.controller;
    }
*/

    /** instance of HealthRecordIndex */
    private HealthRecordIndex healthRecordIndex = null;

    /** instance of LoadedHealthRecords */
    private LoadedHealthRecords loadedHealthRecords = null;

    /**
     * instance of HealthRecord The current healthRecord. This object represents the healthRecord currently in the system.
     * This healthRecord can be used by the application for adding new problems.
     */
    private HealthRecord currentHealthRecord = null;

    /** a boolean help variable */
    //    private boolean afterChange = false;

    /** creates the member variable healthRecord. */
    public void createHealthRecord() {
        this.currentHealthRecord = new HealthRecord();
    }

    /**
     * Sets the member variable healthRecord.
     * @param healthRecord the new value for the member variable healthRecord
     */
    public void setCurrentHealthRecord(HealthRecord healthRecord) {
        this.currentHealthRecord = healthRecord;
    }

    /**
     * Returns the member variable healthRecord.
     * @return healthRecord
     */
    public HealthRecord getCurrentHealthRecord() {
        return this.currentHealthRecord;
    }

    /** creates the member variable healthRecordIndex. */
    public void createHealthRecordIndex() {
        this.healthRecordIndex = new HealthRecordIndex();
    }

    /**
     * Sets the member variable healthRecordIndex.
     * @param healthRecordIndex the new value for the member variable healthRecordIndex
     */
    public void setHealthRecordIndex(HealthRecordIndex healthRecordIndex) {
        this.healthRecordIndex = healthRecordIndex;
    }

    /**
     * Returns the member variable healthRecordIndex.
     * @return healthRecordIndex
     */
    public HealthRecordIndex getHealthRecordIndex() {
        return this.healthRecordIndex;
    }

    /** creates the member variable loadedHealthRecords. */
    public void createLoadedHealthRecords() {
        this.loadedHealthRecords = new LoadedHealthRecords();
    }

    /**
     * Sets the member variable loadedHealthRecords.
     * @param loadedHealthRecords the new value for the member variable loadedHealthRecords
     */
    public void setLoadedHealthRecords(LoadedHealthRecords loadedHealthRecords) {
        this.loadedHealthRecords = loadedHealthRecords;
    }

    /**
     * Returns the member variable loadedHealthRecords.
     * @return loadedHealthRecords
     */
    public LoadedHealthRecords getLoadedHealthRecords() {
        return this.loadedHealthRecords;
    }

    /**
     * The current problem. This object represents the problem currently in the system.
     * This healthRecord can be used by the application for adding new partialContacts.
     */
    private Problem currentProblem;

    /** Reference to the current episode */
    private Episode currentEpisode;

    /** Reference to the current partialContact */
    private PartialContact currentPartialContact;

    /** Reference to the current partialContact */
    private Medication currentMedication;

    /** Reference to the current object */
    private Objective currentObjective;

    /** Calendar object for date and time */
    private Calendar calendar;

    /** Sets the current problem */
    public void setCurrentProblem(Problem problem) {
        this.currentProblem = problem;
    }

    /** Gets the current problem */
    public Problem getCurrentProblem() {
        return this.currentProblem;
    }

    /** Changes the current problem to the probelm with this name */
    public void changeProblem(Problem problem) {
        setCurrentProblem(problem);
    }

    /** Reloads the current problem. Needed when changing partialContacts. */

    /*public void reloadProblem() {
        Problem problem = getCurrentProblem();
        setCurrentProblem(problem);
        ((RecordView) getView()).changeProblem(problem);
    }*/

    /**
     *Sets the current partialContact.
     * @param partialContact the current partialContact
     */
    public void setCurrentPartialContact(PartialContact partialContact) {
        this.currentPartialContact = partialContact;
    }

    /**
     *Gets the current partialContact.
     * @return the current partialContact
     */
    public PartialContact getCurrentPartialContact() {
        return this.currentPartialContact;
    }

    public Objective getCurrentObject() {
        return currentObjective;
    }

    public void setCurrentObject(Objective currentObjective) {
        this.currentObjective = currentObjective;
    }

    public Episode getCurrentEpisode() {
        return currentEpisode;
    }

    public void setCurrentEpisode(Episode currentEpisode) {
        this.currentEpisode = currentEpisode;
    }

    public Medication getCurrentMedication() {
        return currentMedication;
    }

    public void setCurrentMedication(Medication currentMedication) {
        this.currentMedication = currentMedication;
    }

    /** Creates a new problem with problem name and anamnese */
    public void createNewProblem(String problemName, String anamnese) throws Exception {
        Problem problem = new Problem();
        problem.setName(new org.resmedicinae.resmedlib.term.String(problemName));
        problem.setAnamnese(new org.resmedicinae.resmedlib.term.String(anamnese));
        problem.setIdentifier(ObjectID.getNewOId());
        getCurrentHealthRecord().set(problem.getIdentifier(), problem);

        //saveEHRToXMLFile(createEHRDocument(getCurrentHealthRecord()));
    }


    public void createEpisodeForCurrentProblem() throws Exception {
        Episode episode = new Episode();
        episode.initialize();
        org.resmedicinae.resmedlib.term.String tempProblemId = ObjectID.getNewOId();
        episode.setIdentifier(tempProblemId);
        getCurrentProblem().set(tempProblemId, episode);
    }

    public void createNewCaveEntryForCurrentPatient(org.resmedicinae.resmedlib.term.String caveName, org.resmedicinae.resmedlib.term.String caveDescription) throws Exception {
        try {
            Cave cave = new Cave();
            cave.setIdentifier(ObjectID.getNewOId());
            cave.setName(caveName);
            cave.setDescription(caveDescription);
            String tempCaveId = (new Integer(getCurrentHealthRecord().getCavesCount())).toString();
            org.resmedicinae.resmedlib.term.String caveId = new org.resmedicinae.resmedlib.term.String(tempCaveId);
            getCurrentHealthRecord().set(caveId, cave);
            cave.setIdentifier(caveId);
        } catch (Exception e) {
            throw new Exception(e);
        }
    }

    public Object[] getCaveByName(String caveName) {
        Object[] caves = getCurrentHealthRecord().getCaves();
        Vector returnVector = new Vector();
        try {
            for (int i = 0; i < caves.length; i++) {
                Cave cave = (Cave) caves[i];
                if (cave.getName().equals(caveName)) {
                    returnVector.add(cave);
                }
            }
        } catch (Exception e) {
            System.out.println("Error");
        }
        return returnVector.toArray();
    }


    /** Creates a new partialContact with SOAP properties */
    public void createPartialContactTemplateForCurrentEpisode() throws Exception {
        try {
            PartialContact partialContactTemplate = new PartialContact();
            org.resmedicinae.resmedlib.term.String partialContactTemplateId = ObjectID.getNewOId();
            partialContactTemplate.setIdentifier(partialContactTemplateId);
            Calendar calendarInstance = Calendar.getInstance();
            partialContactTemplate.setPartialContactDate(new org.resmedicinae.resmedlib.term.String(calendarInstance.getTime().toString()));
            partialContactTemplate.initialize();
            Subjective soapSubjectTemplate = new Subjective("*leer*");
            soapSubjectTemplate.initialize();
            Objective soapObjectTemplate = new Objective("*leer*");
            soapObjectTemplate.initialize();
            soapObjectTemplate.setIdentifier(ObjectID.getNewOId());
            Plan soapPlanTemplate = new Plan("*leer*");
            soapPlanTemplate.initialize();
            Assessment soapAssessmentTemplate = new Assessment("*leer*");
            soapAssessmentTemplate.initialize();
            partialContactTemplate.set(new org.resmedicinae.resmedlib.term.String("subjective"), soapSubjectTemplate);

            /* partialContactTemplate.addObjective(soapObjectTemplate);
             partialContactTemplate.add(soapObjectTemplate);*/

            partialContactTemplate.set(new org.resmedicinae.resmedlib.term.String("assessment"), soapAssessmentTemplate);
            partialContactTemplate.set(new org.resmedicinae.resmedlib.term.String("plan"), soapPlanTemplate);
            if (getCurrentEpisode() == null) {
                System.out.println("Current Episode is null");
            }
            getCurrentEpisode().initialize();
            //getCurrentEpisode().addPartialContact(partialContactTemplate);
            getCurrentEpisode().set(partialContactTemplateId, partialContactTemplate);
            setCurrentPartialContact(partialContactTemplate);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public void initialize() throws Exception {
        try {
            super.initialize();
            this.createHealthRecord();
            this.createHealthRecordIndex();
            this.createLoadedHealthRecords();
        } catch (Exception e) {
            throw new Exception(e);
        }
    }

}
