/*
 * $RCSfile: CommonObjectRequestBrokerArchitectureModel.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.region.model;

import reform.resmedicinae.reform.application.common.basic.AdvancedBasicApplication;
import org.resmedicinae.resmedlib.region.model.DataTransferModel;
import org.resmedicinae.resmedlib.term.String;

/**
 * This class represents a data transfer model.
 *
 * A data transfer model is a special, simplified model to be used for
 * data transfer between remote machines. It has a reduced number of
 * attributes/methods to ease and speed up communication.
 *
 * @version $Revision: 1.2 $ $Date: 2003/03/24 20:12:20 $ $Author: zone3 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class CommonObjectRequestBrokerArchitectureModel extends DataTransferModel {

    public static final String MODEL_KEY = new String("COMMON_OBJECT_REQUEST_BROKER_ARCHITECTURE_MODEL_KEY");
    private AdvancedBasicApplication controller = null;

    public void setController(AdvancedBasicApplication controller) {
        this.controller = controller;
    }

    public AdvancedBasicApplication getController() {
        return this.controller;
    }

    public void initialize() throws Exception {
        try {
            super.initialize();
        } catch (Exception e) {
            throw new Exception(e);
        }
    }

}

