/*
 * $RCSfile: CommunicationSelectorPanel.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.region;

import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/**
 * This class represents the reform controller.
 * @version $Revision: 1.1 $ $Date: 2003/03/11 12:53:49 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class CommunicationSelectorPanel extends SwingView {
    public static final String XML_RADIOBUTTON_KEY = "XML_RADIOBUTTON_KEY";
    public static final String DB_RADIOBUTTON_KEY = "DB_RADIOBUTTON_KEY";
    public static final String JMS_RADIOBUTTON_KEY = "JMS_RADIOBUTTON_KEY";
    public static final String RMI_RADIOBUTTON_KEY = "RMI_RADIOBUTTON_KEY";
    public static final String CORBA_RADIOBUTTON_KEY = "CORBA_RADIOBUTTON_KEY";

    /** Initializes the ReForm view. */
    public void initialize() {
        try {
            super.initialize();
            //	setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            // Set panel properties and add child components.
            this.setTitle("CommunicationSelector");
            setResizable(true);
            setLayout(new BorderLayout());
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            setDialogBounds(createDialogBounds());
            add(createPanel(), BorderLayout.CENTER);
        } catch (Exception e) {
            //?? getLogger().log("");
            System.out.println("Fehler: " + e);
        }
    }

    /**
     * Creates a title.
     * @return the title
     */
    public String createTitle() {
        return "Printer";
    }

    /**
     * Creates a icon.
     * @return the icon
     */
    public String createIcon() {
        return "Icon";
    }

    /**
     * Creates a border layout.
     * @return the border layout
     */
    public BorderLayout createBorderLayout() {
        return new BorderLayout();
    }

    public BasicController getActionListener() {
        return (BasicController) getController();
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 400;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = 0;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 265;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = 100;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a ResPanel.
     * @return the ResPanel
     */
    public JPanel createPanel() {
        JPanel csPanel = new JPanel();
        JPanel dbxmlPanel = new JPanel();
        JPanel dbxmlSubPanel = new JPanel();
        JPanel corbarmiPanel = new JPanel();
        JPanel corbarmiSubPanel = new JPanel();
        csPanel.setLayout(new GridLayout(2, 1));
        dbxmlSubPanel.setLayout(new GridLayout(2, 1));
        corbarmiSubPanel.setLayout(new GridLayout(3, 1));
        JRadioButton rbXML = new JRadioButton("Store data in XML-files", true);
        rbXML.setActionCommand(XML_RADIOBUTTON_KEY);
        rbXML.addActionListener(getActionListener());
        JRadioButton rbDB = new JRadioButton("Store data in a data base", false);
        rbDB.setActionCommand(DB_RADIOBUTTON_KEY);
        rbDB.addActionListener(getActionListener());
        ButtonGroup bgDBXML = new ButtonGroup();
        bgDBXML.add(rbXML);
        bgDBXML.add(rbDB);
        dbxmlSubPanel.add(rbXML);
        dbxmlSubPanel.add(rbDB);
        dbxmlPanel.add(dbxmlSubPanel);
        dbxmlPanel.setBorder(BorderFactory.createTitledBorder("Persistance"));
        csPanel.add(dbxmlPanel);
        JRadioButton rbJMS = new JRadioButton("Transfer data via Java Message Service", true);
        rbJMS.setActionCommand(JMS_RADIOBUTTON_KEY);
        rbJMS.addActionListener(getActionListener());
        JRadioButton rbRMI = new JRadioButton("Transfer data via Remote Method Invocation", false);
        rbRMI.setActionCommand(RMI_RADIOBUTTON_KEY);
        rbRMI.addActionListener(getActionListener());
        JRadioButton rbCorba = new JRadioButton("Transfer data via Common Object Request Broker Architecture", false);
        rbCorba.setActionCommand(CORBA_RADIOBUTTON_KEY);
        rbCorba.addActionListener(getActionListener());
        ButtonGroup bgCorbaRMI = new ButtonGroup();
        bgCorbaRMI.add(rbJMS);
        bgCorbaRMI.add(rbRMI);
        bgCorbaRMI.add(rbCorba);
        corbarmiSubPanel.add(rbJMS);
        corbarmiSubPanel.add(rbRMI);
        corbarmiSubPanel.add(rbCorba);
        corbarmiPanel.add(corbarmiSubPanel);
        corbarmiPanel.setBorder(BorderFactory.createTitledBorder("Data Transfer Service"));
        csPanel.add(corbarmiPanel);

        /** functionality background still not implemented *** */
        rbJMS.setEnabled(false);
        rbRMI.setEnabled(false);
        rbCorba.setEnabled(false);

        /**  */
        return csPanel;
    }
}
